/*
 * Decompiled with CFR 0.152.
 */
package darkotweaks.core;

import darkotweaks.BlockTorchFire;
import darkotweaks.ItemBON;
import darkotweaks.core.proxies.CommonProxy;
import darkotweaks.handlers.ConfigHandler;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;

@Mod(modid="darkotweaks", version="1.0.4", name="Darko Tweaks", acceptedMinecraftVersions="[1.10.2]")
public class DarkoTweaks {
    public static final String MODID = "darkotweaks";
    public static final String VERSION = "1.0.4";
    public static final String NAME = "Darko Tweaks";
    public static final String PROXY = "darkotweaks.core.proxies";
    @Mod.Instance(value="darkotweaks")
    public static DarkoTweaks instance;
    @SidedProxy(clientSide="darkotweaks.core.proxies.ClientProxy", serverSide="darkotweaks.core.proxies.CommonProxy")
    public static CommonProxy proxy;
    public static Logger logger;
    public static Block fireTorch;
    public static Item bookOfNotch;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        ConfigHandler.config = new Configuration(event.getSuggestedConfigurationFile(), true);
        ConfigHandler.initConfigs();
        proxy.registerHandlers();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        DarkoTweaks.registerBlock(fireTorch, "fire_torch");
        DarkoTweaks.registerItem(bookOfNotch, "book_of_notch");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.registerRenderers();
        Blocks.field_150480_ab.func_180686_a(Blocks.field_150415_aT, 5, 20);
    }

    public static void registerBlock(Block b, String name) {
        DarkoTweaks.registerBlock(b, new ItemBlock(b), name);
    }

    public static void registerBlock(Block b, ItemBlock i, String name) {
        ResourceLocation res = new ResourceLocation("darkotweaks:" + name);
        if (i.getRegistryName() == null) {
            i.setRegistryName(res);
        }
        GameRegistry.register((IForgeRegistryEntry)b, (ResourceLocation)res);
        GameRegistry.register((IForgeRegistryEntry)i);
    }

    public static void registerItem(Item i, String name) {
        ResourceLocation res = new ResourceLocation("darkotweaks:" + name);
        GameRegistry.register((IForgeRegistryEntry)i.setRegistryName(res));
    }

    static {
        fireTorch = new BlockTorchFire();
        bookOfNotch = new ItemBON();
    }
}

