/*
 * Decompiled with CFR 0.152.
 */
package darkotweaks;

import darkotweaks.core.DT_Settings;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTorchFire
extends Block {
    protected static final AxisAlignedBB STANDING_AABB = new AxisAlignedBB((double)0.4f, 0.0, (double)0.4f, (double)0.6f, (double)0.6f, (double)0.6f);
    protected static final AxisAlignedBB TORCH_NORTH_AABB = new AxisAlignedBB((double)0.35f, (double)0.2f, (double)0.7f, (double)0.65f, (double)0.8f, 1.0);
    protected static final AxisAlignedBB TORCH_SOUTH_AABB = new AxisAlignedBB((double)0.35f, (double)0.2f, 0.0, (double)0.65f, (double)0.8f, (double)0.3f);
    protected static final AxisAlignedBB TORCH_WEST_AABB = new AxisAlignedBB((double)0.7f, (double)0.2f, (double)0.35f, 1.0, (double)0.8f, (double)0.65f);
    protected static final AxisAlignedBB TORCH_EAST_AABB = new AxisAlignedBB(0.0, (double)0.2f, (double)0.35f, (double)0.3f, (double)0.8f, (double)0.65f);

    public BlockTorchFire() {
        super(Material.field_151594_q);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.UP));
        this.func_149675_a(true);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149711_c(0.0f);
        this.func_149715_a(0.9375f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149663_c("torch");
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)BlockTorch.field_176596_a)) {
            case EAST: {
                return TORCH_EAST_AABB;
            }
            case WEST: {
                return TORCH_WEST_AABB;
            }
            case SOUTH: {
                return TORCH_SOUTH_AABB;
            }
            case NORTH: {
                return TORCH_NORTH_AABB;
            }
        }
        return STANDING_AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    private boolean canPlaceOn(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.isSideSolid((IBlockAccess)worldIn, pos, EnumFacing.UP)) {
            return true;
        }
        return state.func_177230_c().canPlaceTorchOnTop(state, (IBlockAccess)worldIn, pos);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : BlockTorch.field_176596_a.func_177700_c()) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    private boolean canPlaceAt(World worldIn, BlockPos pos, EnumFacing facing) {
        BlockPos blockpos = pos.func_177972_a(facing.func_176734_d());
        boolean flag = facing.func_176740_k().func_176722_c();
        return flag && worldIn.isSideSolid(blockpos, facing, true) || facing.equals((Object)EnumFacing.UP) && this.canPlaceOn(worldIn, blockpos);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (this.canPlaceAt(worldIn, pos, facing)) {
            return this.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)facing);
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!worldIn.isSideSolid(pos.func_177972_a(enumfacing.func_176734_d()), enumfacing, true)) continue;
            return this.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)enumfacing);
        }
        return this.func_176223_P();
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.checkForDrop(worldIn, pos, state);
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn) + worldIn.field_73012_v.nextInt(10));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        this.onNeighborChangeInternal(worldIn, pos, state);
    }

    protected boolean onNeighborChangeInternal(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.checkForDrop(worldIn, pos, state)) {
            return true;
        }
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)BlockTorch.field_176596_a);
        EnumFacing.Axis enumfacing$axis = enumfacing.func_176740_k();
        EnumFacing enumfacing1 = enumfacing.func_176734_d();
        boolean flag = false;
        if (enumfacing$axis.func_176722_c() && !worldIn.isSideSolid(pos.func_177972_a(enumfacing1), enumfacing, true)) {
            flag = true;
        } else if (enumfacing$axis.func_176720_b() && !this.canPlaceOn(worldIn, pos.func_177972_a(enumfacing1))) {
            flag = true;
        }
        if (flag) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
            return true;
        }
        return false;
    }

    protected boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this && this.canPlaceAt(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)BlockTorch.field_176596_a))) {
            return true;
        }
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        EnumFacing enumfacing = (EnumFacing)stateIn.func_177229_b((IProperty)BlockTorch.field_176596_a);
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + 0.7;
        double d2 = (double)pos.func_177952_p() + 0.5;
        if (enumfacing.func_176740_k().func_176722_c()) {
            EnumFacing enumfacing1 = enumfacing.func_176734_d();
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + 0.27 * (double)enumfacing1.func_82601_c(), d1 + 0.22, d2 + 0.27 * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
            worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + 0.27 * (double)enumfacing1.func_82601_c(), d1 + 0.22, d2 + 0.27 * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
        } else {
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            worldIn.func_175688_a(EnumParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P();
        switch (meta) {
            case 1: {
                iblockstate = iblockstate.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.EAST);
                break;
            }
            case 2: {
                iblockstate = iblockstate.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.WEST);
                break;
            }
            case 3: {
                iblockstate = iblockstate.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.SOUTH);
                break;
            }
            case 4: {
                iblockstate = iblockstate.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.NORTH);
                break;
            }
            default: {
                iblockstate = iblockstate.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.UP);
            }
        }
        return iblockstate;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        switch ((EnumFacing)state.func_177229_b((IProperty)BlockTorch.field_176596_a)) {
            case EAST: {
                i |= 1;
                break;
            }
            case WEST: {
                i |= 2;
                break;
            }
            case SOUTH: {
                i |= 3;
                break;
            }
            case NORTH: {
                i |= 4;
                break;
            }
            default: {
                i |= 5;
            }
        }
        return i;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)BlockTorch.field_176596_a)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)BlockTorch.field_176596_a)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockTorch.field_176596_a});
    }

    public int func_149738_a(World worldIn) {
        return 30;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!DT_Settings.fireTorches) {
            return;
        }
        if (worldIn.func_82736_K().func_82766_b("doFireTick")) {
            worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn) + rand.nextInt(10));
            boolean flag1 = worldIn.func_180502_D(pos);
            int j = 0;
            if (flag1) {
                j = -50;
            }
            this.tryCatchFire(worldIn, pos.func_177974_f(), 300 + j, rand, 0, EnumFacing.WEST);
            this.tryCatchFire(worldIn, pos.func_177976_e(), 300 + j, rand, 0, EnumFacing.EAST);
            this.tryCatchFire(worldIn, pos.func_177977_b(), 250 + j, rand, 0, EnumFacing.UP);
            this.tryCatchFire(worldIn, pos.func_177984_a(), 250 + j, rand, 0, EnumFacing.DOWN);
            this.tryCatchFire(worldIn, pos.func_177978_c(), 300 + j, rand, 0, EnumFacing.SOUTH);
            this.tryCatchFire(worldIn, pos.func_177968_d(), 300 + j, rand, 0, EnumFacing.NORTH);
            for (int k = -1; k <= 1; ++k) {
                for (int l = -1; l <= 1; ++l) {
                    for (int i1 = -1; i1 <= 4; ++i1) {
                        BlockPos blockpos;
                        int k1;
                        if (k == 0 && i1 == 0 && l == 0) continue;
                        int j1 = 100;
                        if (i1 > 1) {
                            j1 += (i1 - 1) * 100;
                        }
                        if ((k1 = this.getNeighborEncouragement(worldIn, blockpos = pos.func_177982_a(k, i1, l))) <= 0) continue;
                        int l1 = (k1 + 40 + worldIn.func_175659_aa().func_151525_a() * 7) / 30;
                        if (flag1) {
                            l1 /= 2;
                        }
                        if (l1 <= 0 || rand.nextInt(j1) > l1) continue;
                        worldIn.func_180501_a(blockpos, Blocks.field_150480_ab.func_176223_P().func_177226_a((IProperty)BlockFire.field_176543_a, (Comparable)Integer.valueOf(0)), 3);
                    }
                }
            }
        }
    }

    private void tryCatchFire(World worldIn, BlockPos pos, int chance, Random random, int age, EnumFacing face) {
        int i = worldIn.func_180495_p(pos).func_177230_c().getFlammability((IBlockAccess)worldIn, pos, face);
        if (random.nextInt(chance) < i) {
            IBlockState iblockstate = worldIn.func_180495_p(pos);
            if (random.nextInt(age + 10) < 5 && !worldIn.func_175727_C(pos)) {
                int j = age + random.nextInt(5) / 4;
                if (j > 15) {
                    j = 15;
                }
                worldIn.func_180501_a(pos, Blocks.field_150480_ab.func_176223_P().func_177226_a((IProperty)BlockFire.field_176543_a, (Comparable)Integer.valueOf(j)), 3);
            } else {
                worldIn.func_175698_g(pos);
            }
            if (iblockstate.func_177230_c() == Blocks.field_150335_W) {
                Blocks.field_150335_W.func_176206_d(worldIn, pos, iblockstate.func_177226_a((IProperty)BlockTNT.field_176246_a, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    private int getNeighborEncouragement(World worldIn, BlockPos pos) {
        if (!worldIn.func_175623_d(pos)) {
            return 0;
        }
        int i = 0;
        for (EnumFacing enumfacing : EnumFacing.values()) {
            i = Math.max(worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c().getFireSpreadSpeed((IBlockAccess)worldIn, pos.func_177972_a(enumfacing), enumfacing.func_176734_d()), i);
        }
        return i;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)Blocks.field_150478_aa);
    }

    protected ItemStack func_180643_i(IBlockState state) {
        Item item = Item.func_150898_a((Block)Blocks.field_150478_aa);
        if (item == null) {
            return null;
        }
        int i = 0;
        if (item.func_77614_k()) {
            i = this.func_176201_c(state);
        }
        return new ItemStack(item, 1, i);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        Item item = Item.func_150898_a((Block)Blocks.field_150478_aa);
        return item == null ? null : new ItemStack(item, 1, this.func_180651_a(state));
    }
}

