/*
 * Decompiled with CFR 0.152.
 */
package littlelooter.loot;

import com.google.common.cache.LoadingCache;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import littlelooter.JsonHelper;
import littlelooter.core.LittleLooter;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.logging.log4j.Level;

public class CustomLootTableManager {
    public static HashMap<ResourceLocation, ArrayList<ResourceLocation>> LOOT_MAP = new HashMap();
    static final Gson GSON = new GsonBuilder().registerTypeAdapter(RandomValueRange.class, (Object)new RandomValueRange.Serializer()).registerTypeAdapter(LootPool.class, (Object)new LootPool.Serializer()).registerTypeAdapter(LootTable.class, (Object)new LootTable.Serializer()).registerTypeHierarchyAdapter(LootEntry.class, (Object)new LootEntry.Serializer()).registerTypeHierarchyAdapter(LootFunction.class, (Object)new LootFunctionManager.Serializer()).registerTypeHierarchyAdapter(LootCondition.class, (Object)new LootConditionManager.Serializer()).registerTypeHierarchyAdapter(LootContext.EntityTarget.class, (Object)new LootContext.EntityTarget.Serializer()).create();

    public static void LoadLoot(File file, LootTableManager manager) {
        if (!file.exists()) {
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            CustomLootTableManager.GenerateDefault(file);
        }
        JsonObject json = JsonHelper.ReadObjectFromFile(file);
        LOOT_MAP.clear();
        for (JsonElement e : JsonHelper.GetArray(json, "blockLoot")) {
            if (e == null || !e.isJsonObject()) continue;
            JsonObject eObj = e.getAsJsonObject();
            ResourceLocation res = new ResourceLocation(JsonHelper.GetString(eObj, "blockID", "littlelooter:air_drop"));
            if (!Block.field_149771_c.func_148741_d((Object)res)) {
                LittleLooter.logger.log(Level.ERROR, "Unable to load loot table mapping for block " + res.toString());
                continue;
            }
            ArrayList<ResourceLocation> tbls = new ArrayList<ResourceLocation>();
            for (JsonElement e2 : JsonHelper.GetArray(eObj, "tables")) {
                if (e2 == null || !e2.isJsonPrimitive()) continue;
                tbls.add(new ResourceLocation(e2.getAsString()));
            }
            LOOT_MAP.put(res, tbls);
        }
        for (JsonElement e : JsonHelper.GetArray(json, "lootTables")) {
            if (e == null || !e.isJsonObject()) continue;
            CustomLootTable tbl = new CustomLootTable();
            tbl.readFromJson(e.getAsJsonObject());
            JsonArray fmtAry = new JsonArray();
            fmtAry.add((JsonElement)tbl.getFormatted());
            JsonObject fmtObj = new JsonObject();
            fmtObj.add("pools", (JsonElement)fmtAry);
            String fmt = new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)fmtObj);
            try {
                LootTable vanTable = ForgeHooks.loadLootTable((Gson)GSON, (ResourceLocation)new ResourceLocation(tbl.name), (String)fmt, (boolean)true);
                LoadingCache registeredLootTables = (LoadingCache)ObfuscationReflectionHelper.getPrivateValue(LootTableManager.class, (Object)manager, (String[])new String[]{"field_186527_c", "registeredLootTables"});
                registeredLootTables.put((Object)new ResourceLocation(tbl.name), (Object)vanTable);
            }
            catch (Exception ex) {
                LittleLooter.logger.log(Level.ERROR, "Unable to register custom loot table " + tbl.name, (Throwable)ex);
                continue;
            }
            LittleLooter.logger.log(Level.INFO, "Registered custom loot table " + tbl.name);
        }
    }

    private static void GenerateDefault(File file) {
        JsonObject parentJson = new JsonObject();
        JsonArray blockLoot = new JsonArray();
        JsonObject jBlk = new JsonObject();
        jBlk.addProperty("blockID", "littlelooter:air_drop");
        JsonArray bTbls = new JsonArray();
        bTbls.add((JsonElement)new JsonPrimitive("littlelooter:orbital_drop"));
        jBlk.add("tables", (JsonElement)bTbls);
        blockLoot.add((JsonElement)jBlk);
        parentJson.add("blockLoot", (JsonElement)blockLoot);
        JsonArray tables = new JsonArray();
        CustomLootTable ltb = new CustomLootTable();
        ltb.name = "littlelooter:orbital_drop";
        ltb.maxItems = 10;
        CustomLootEntry len = new CustomLootEntry();
        len.maxStack = 8;
        ltb.entries.add(len);
        tables.add((JsonElement)ltb.writeToJson(new JsonObject()));
        parentJson.add("lootTables", (JsonElement)tables);
        JsonHelper.WriteToFile(file, (JsonElement)parentJson);
    }

    public static class CustomLootEntry {
        String id = "minecraft:diamond";
        int minStack = 1;
        int maxStack = 1;
        int meta = 0;
        int weight = 1;

        public void readFromJson(JsonObject json) {
            this.id = JsonHelper.GetString(json, "id", "minecraft:diamond");
            this.minStack = JsonHelper.GetNumber(json, "minStack", this.minStack).intValue();
            this.maxStack = JsonHelper.GetNumber(json, "maxStack", this.maxStack).intValue();
            this.meta = JsonHelper.GetNumber(json, "meta", 0).intValue();
            this.weight = JsonHelper.GetNumber(json, "weight", 1).intValue();
        }

        public JsonObject writeToJson(JsonObject json) {
            json.addProperty("id", this.id);
            json.addProperty("minStack", (Number)this.minStack);
            json.addProperty("maxStack", (Number)this.maxStack);
            json.addProperty("meta", (Number)this.meta);
            json.addProperty("weight", (Number)this.weight);
            return json;
        }

        public JsonObject getFormatted() {
            JsonObject func;
            JsonObject json = new JsonObject();
            json.addProperty("type", "item");
            json.addProperty("name", this.id);
            json.addProperty("weight", (Number)this.weight);
            JsonArray fList = new JsonArray();
            if (this.meta > 0) {
                func = new JsonObject();
                func.addProperty("function", "set_data");
                func.addProperty("data", (Number)this.meta);
                fList.add((JsonElement)func);
            }
            if (this.maxStack > 1) {
                func = new JsonObject();
                func.addProperty("function", "set_count");
                if (this.maxStack != this.minStack) {
                    JsonObject cnt = new JsonObject();
                    cnt.addProperty("min", (Number)this.minStack);
                    cnt.addProperty("max", (Number)this.maxStack);
                    func.add("count", (JsonElement)cnt);
                } else {
                    func.addProperty("count", (Number)this.maxStack);
                }
                fList.add((JsonElement)func);
            }
            json.add("functions", (JsonElement)fList);
            return json;
        }
    }

    public static class CustomLootTable {
        ArrayList<CustomLootEntry> entries = new ArrayList();
        String name = "littlelootergeneric";
        int minItems = 1;
        int maxItems = 100;

        public void readFromJson(JsonObject json) {
            this.name = JsonHelper.GetString(json, "name", "generic");
            this.minItems = JsonHelper.GetNumber(json, "minItems", 1).intValue();
            this.maxItems = JsonHelper.GetNumber(json, "maxItems", 100).intValue();
            this.entries.clear();
            for (JsonElement e : JsonHelper.GetArray(json, "entries")) {
                if (e == null || !e.isJsonObject()) continue;
                CustomLootEntry entry = new CustomLootEntry();
                entry.readFromJson(e.getAsJsonObject());
                this.entries.add(entry);
            }
        }

        public JsonObject writeToJson(JsonObject json) {
            json.addProperty("name", this.name);
            json.addProperty("minItems", (Number)this.minItems);
            json.addProperty("maxItems", (Number)this.maxItems);
            JsonArray eAry = new JsonArray();
            for (CustomLootEntry e : this.entries) {
                eAry.add((JsonElement)e.writeToJson(new JsonObject()));
            }
            json.add("entries", (JsonElement)eAry);
            return json;
        }

        public JsonObject getFormatted() {
            JsonObject json = new JsonObject();
            JsonObject rolls = new JsonObject();
            rolls.addProperty("min", (Number)this.minItems);
            rolls.addProperty("max", (Number)this.maxItems);
            json.add("rolls", (JsonElement)rolls);
            JsonArray eAry = new JsonArray();
            for (CustomLootEntry e : this.entries) {
                eAry.add((JsonElement)e.getFormatted());
            }
            json.add("entries", (JsonElement)eAry);
            return json;
        }
    }
}

