/*
 * Decompiled with CFR 0.152.
 */
package littlelooter.items.weapons;

import com.google.common.collect.Multimap;
import java.util.HashMap;
import littlelooter.core.LittleLooter;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMeleeWeapon
extends Item {
    private HashMap<Block, Float> effBlocks = new HashMap();
    private HashMap<Material, Float> effMat = new HashMap();
    private int attackDamage = 0;
    private float attackSpeed = -2.0f;

    public ItemMeleeWeapon(int damage, float speed, int uses) {
        this.func_77625_d(1);
        this.func_77656_e(uses);
        this.func_77637_a(LittleLooter.tabMelee);
        this.attackDamage = damage - 1;
        this.attackSpeed = speed;
    }

    public ItemMeleeWeapon setEffectiveBlocks(float multiplier, Block ... blocks) {
        for (Block b : blocks) {
            this.effBlocks.put(b, Float.valueOf(multiplier));
        }
        return this;
    }

    public ItemMeleeWeapon setEffectiveMaterials(float multiplier, Material ... mats) {
        for (Material m : mats) {
            this.effMat.put(m, Float.valueOf(multiplier));
        }
        return this;
    }

    public ItemMeleeWeapon makeUtility() {
        this.func_77642_a(this);
        this.setNoRepair();
        return this;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        if (stack == null || stack.func_77952_i() >= this.getMaxDamage(stack) || this.func_77668_q() == null) {
            return null;
        }
        ItemStack s = stack.func_77946_l();
        s.func_77964_b(s.func_77952_i() + 1);
        return s;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        Block block = state.func_177230_c();
        Float f = this.effBlocks.get(block);
        f = f != null ? f : this.effMat.get(state.func_185904_a());
        return f != null ? f.floatValue() : 1.0f;
    }

    public float getDamageVsEntity() {
        return this.attackDamage;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(1, attacker);
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if (state.func_185887_b(worldIn, pos) != 0.0f) {
            stack.func_77972_a(2, entityLiving);
        }
        return true;
    }

    public boolean func_150897_b(IBlockState state) {
        Block block = state.func_177230_c();
        Float f = this.effBlocks.get(block);
        f = f != null ? f : this.effMat.get(state.func_185904_a());
        return f != null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.attackDamage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)this.attackSpeed, 0));
        }
        return multimap;
    }
}

