/*
 * Decompiled with CFR 0.152.
 */
package littlelooter.items.misc;

import littlelooter.blocks.BlockBarbedWire;
import littlelooter.blocks.material.MaterialWire;
import littlelooter.core.LittleLooter;
import littlelooter.items.food.FoodRegistry;
import littlelooter.items.misc.ItemUtility;
import littlelooter.utils.QuickRegister;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class MiscRegistry {
    public static ItemUtility canOpener;
    public static ItemUtility wireCutter;
    public static ItemUtility solderingIron;
    public static ItemUtility screwdriver;
    public static Item nails;
    public static Item screws;
    public static Item wire;
    public static Item tape;
    public static Item metalBits;
    public static Item emptyBottle;
    public static Item components;
    public static Item smallBattery;
    public static Block barbedWire;

    public static void initRegistry() {
        canOpener = MiscRegistry.GenerateUtilityItem("can_opener", 24);
        wireCutter = MiscRegistry.GenerateUtilityItem("wire_cutter", 64).setEffectiveMaterials(15.0f, MaterialWire.WIRE);
        solderingIron = MiscRegistry.GenerateUtilityItem("soldering_iron", 24);
        screwdriver = MiscRegistry.GenerateUtilityItem("screwdriver", 64);
        nails = MiscRegistry.GenerateMiscItem("nails", 64);
        screws = MiscRegistry.GenerateMiscItem("screws", 64);
        wire = MiscRegistry.GenerateMiscItem("wire", 16);
        tape = MiscRegistry.GenerateMiscItem("tape", 16);
        metalBits = MiscRegistry.GenerateMiscItem("metal_bits", 64);
        emptyBottle = MiscRegistry.GenerateMiscItem("empty_bottle", 16);
        components = MiscRegistry.GenerateMiscItem("components", 64);
        smallBattery = MiscRegistry.GenerateMiscItem("small_battery", 64);
        QuickRegister.registerBlock(barbedWire, "barbed_wire");
        OreDictionary.registerOre((String)"nuggetIron", (Item)metalBits);
    }

    public static void initRecipes() {
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(metalBits, 4), (Object[])new Object[]{new ItemStack((Item)FoodRegistry.canEmpty, 1, Short.MAX_VALUE), new ItemStack((Item)wireCutter, 1, Short.MAX_VALUE)});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(barbedWire, 16), new Object[]{"BWB", "W W", "BWB", Character.valueOf('B'), "nuggetIron", Character.valueOf('W'), new ItemStack(wire)}));
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)solderingIron), (Object[])new Object[]{new ItemStack((Item)solderingIron, 1, Short.MAX_VALUE), new ItemStack(smallBattery)});
    }

    private static Item GenerateMiscItem(String name, int stack) {
        Item item = new Item();
        item.func_77655_b("littlelooter." + name);
        item.func_77637_a(LittleLooter.tabMisc);
        item.func_77625_d(stack);
        QuickRegister.registerItem(item, name);
        return item;
    }

    private static ItemUtility GenerateUtilityItem(String name, int uses) {
        ItemUtility util = new ItemUtility(name, uses);
        util.func_77637_a(LittleLooter.tabMisc);
        QuickRegister.registerItem(util, name);
        return util;
    }

    @SideOnly(value=Side.CLIENT)
    public static void initRenderers() {
        QuickRegister.registerItemModel(canOpener);
        QuickRegister.registerItemModel(wireCutter);
        QuickRegister.registerItemModel(solderingIron);
        QuickRegister.registerItemModel(screwdriver);
        QuickRegister.registerItemModel(nails);
        QuickRegister.registerItemModel(screws);
        QuickRegister.registerItemModel(wire);
        QuickRegister.registerItemModel(tape);
        QuickRegister.registerItemModel(metalBits);
        QuickRegister.registerItemModel(emptyBottle);
        QuickRegister.registerItemModel(components);
        QuickRegister.registerItemModel(smallBattery);
        QuickRegister.registerBlockModel(barbedWire);
    }

    static {
        barbedWire = new BlockBarbedWire();
    }
}

