/*
 * Decompiled with CFR 0.152.
 */
package littlelooter.items.food;

import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import littlelooter.core.LittleLooter;
import littlelooter.items.ILabelColor;
import littlelooter.items.food.FoodRegistry;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCannedFood
extends ItemFood
implements ILabelColor {
    int colBase = Color.WHITE.getRGB();
    int colLabel = Color.WHITE.getRGB();
    boolean edible = true;
    boolean needCooking = false;
    boolean safeRaw = true;

    public ItemCannedFood(int amount, boolean isWolfFood) {
        this(amount, 0.6f, isWolfFood);
    }

    public ItemCannedFood(int amount, float saturation, boolean isWolfFood) {
        super(amount, saturation, isWolfFood);
        this.func_77637_a(LittleLooter.tabFood);
        this.func_77627_a(true);
        this.func_77625_d(4);
    }

    public ItemCannedFood setIndedible() {
        this.edible = false;
        return this;
    }

    public ItemCannedFood setCookable(boolean safeRaw) {
        this.needCooking = true;
        this.safeRaw = safeRaw;
        return this;
    }

    public int func_150905_g(ItemStack stack) {
        if (stack.func_77952_i() <= 0) {
            return 0;
        }
        if (stack.func_77952_i() == 1 && this.needCooking) {
            return super.func_150905_g(stack) / 2;
        }
        return super.func_150905_g(stack);
    }

    public float func_150906_h(ItemStack stack) {
        if (stack.func_77952_i() <= 0) {
            return 0.0f;
        }
        if (stack.func_77952_i() == 1 && this.needCooking) {
            return super.func_150906_h(stack) / 2.0f;
        }
        return super.func_150906_h(stack);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return stack.func_77952_i() > 0 && this.edible ? EnumAction.EAT : EnumAction.NONE;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (stack.func_77952_i() <= 0 || !this.edible) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        return super.func_77659_a(stack, world, player, hand);
    }

    @Nullable
    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        ItemStack sRet = super.func_77654_b(stack, worldIn, entityLiving);
        if (sRet.field_77994_a == 0) {
            return new ItemStack((Item)FoodRegistry.canEmpty, 1, stack.func_77952_i());
        }
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            ItemStack sEmp = new ItemStack((Item)FoodRegistry.canEmpty, 1, stack.func_77952_i());
            if (!player.field_71071_by.func_70441_a(sEmp)) {
                player.func_146097_a(sEmp, true, true);
            }
        }
        return sRet;
    }

    protected void func_77849_c(ItemStack stack, World world, EntityPlayer player) {
        super.func_77849_c(stack, world, player);
        if (!world.field_72995_K && this.needCooking && !this.safeRaw && stack.func_77952_i() == 1 && world.field_73012_v.nextBoolean()) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 600));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 1));
        if (this.needCooking) {
            list.add(new ItemStack(item, 1, 2));
        }
    }

    public String func_77667_c(ItemStack stack) {
        String base = super.func_77667_c(stack);
        switch (stack.func_77952_i()) {
            case 2: {
                return base + ".cooked";
            }
        }
        return base;
    }

    public ItemCannedFood setLabelColor(Color label) {
        return this.setLabelColor(Color.WHITE, label);
    }

    public ItemCannedFood setLabelColor(Color base, Color label) {
        this.colBase = base.getRGB();
        this.colLabel = label.getRGB();
        return this;
    }

    @Override
    public int getLabelColor(ItemStack stack, int layer) {
        return layer == 0 ? this.colBase : this.colLabel;
    }
}

