/*
 * Decompiled with CFR 0.152.
 */
package littlelooter.items.food;

import java.awt.Color;
import java.util.ArrayList;
import littlelooter.client.renderer.ItemColoredLabel;
import littlelooter.items.food.ItemCannedFood;
import littlelooter.items.food.ItemFoodBar;
import littlelooter.items.food.ItemFoodPacket;
import littlelooter.items.food.ItemJuiceBox;
import littlelooter.items.food.ItemSodaCan;
import littlelooter.items.misc.MiscRegistry;
import littlelooter.utils.QuickRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FoodRegistry {
    private static ArrayList<ItemCannedFood> allCans = new ArrayList();
    public static ItemCannedFood canEmpty;
    public static ItemCannedFood canDogFood;
    public static ItemCannedFood canChickenSoup;
    public static ItemCannedFood canPumpkinSoup;
    public static ItemCannedFood canTomatoSoup;
    public static ItemCannedFood canBakedBeans;
    public static ItemCannedFood canKidneyBeans;
    public static ItemCannedFood canVegetables;
    public static ItemCannedFood canBeefChunks;
    public static ItemCannedFood canSpam;
    public static ItemCannedFood canTuna;
    public static ItemCannedFood canPineapple;
    public static ItemCannedFood canBeetroot;
    public static ItemCannedFood canPeaches;
    private static ArrayList<ItemSodaCan> allSoda;
    public static ItemSodaCan sodaEmpty;
    public static ItemSodaCan sodaCola;
    public static ItemSodaCan sodaRootBeer;
    public static ItemSodaCan sodaGingerBeer;
    public static ItemSodaCan sodaGingerAle;
    public static ItemSodaCan sodaCreaming;
    public static ItemSodaCan sodaCrush;
    public static ItemSodaCan sodaLemonade;
    public static ItemSodaCan sodaSarsaparilla;
    public static ItemSodaCan sodaLemLimBit;
    public static ItemSodaCan sodaGuava;
    public static ItemSodaCan sodaPassionfruit;
    public static ItemSodaCan sodaPineapple;
    public static ItemSodaCan sodaRaspberry;
    private static ArrayList<ItemJuiceBox> allJuice;
    public static ItemJuiceBox juiceApple;
    public static ItemJuiceBox juiceOrange;
    public static ItemJuiceBox juicePineapple;
    public static ItemJuiceBox juiceGrape;
    public static ItemJuiceBox juiceMango;
    public static ItemJuiceBox juiceMilkPlain;
    public static ItemJuiceBox juiceMilkStrawberry;
    public static ItemJuiceBox juiceMilkBanana;
    public static ItemJuiceBox juiceMilkChocolate;
    private static ArrayList<ItemFoodBar> allBars;
    public static ItemFoodBar barChocolate;
    public static ItemFoodBar barDarkChoc;
    public static ItemFoodBar barWhiteChoc;
    public static ItemFoodBar barTrailMix;
    private static ArrayList<ItemFoodPacket> allPackets;
    public static ItemFoodPacket plainChips;
    public static ItemFoodPacket svChips;
    public static ItemFoodPacket chickenChips;

    public static void initRegistry() {
        canEmpty = FoodRegistry.CreateCan("empty", 0, 0.0f, false).setLabelColor(Color.WHITE).setIndedible();
        canDogFood = FoodRegistry.CreateCan("dog_food", 2, 0.2f, true).setLabelColor(new Color(96, 64, 32));
        canChickenSoup = FoodRegistry.CreateCan("chicken_soup", 8, false).setLabelColor(new Color(255, 255, 128));
        canPumpkinSoup = FoodRegistry.CreateCan("pumpkin_soup", 8, false).setLabelColor(new Color(255, 192, 0));
        canTomatoSoup = FoodRegistry.CreateCan("tomato_soup", 8, false).setLabelColor(Color.RED);
        canBakedBeans = FoodRegistry.CreateCan("baked_beans", 6, false).setLabelColor(new Color(255, 128, 0));
        canKidneyBeans = FoodRegistry.CreateCan("kidney_beans", 6, false).setLabelColor(new Color(96, 32, 32));
        canVegetables = FoodRegistry.CreateCan("vegetables", 6, false).setLabelColor(new Color(0, 255, 0));
        canBeefChunks = FoodRegistry.CreateCan("beef_chunks", 8, true).setLabelColor(new Color(128, 0, 0));
        canSpam = FoodRegistry.CreateCan("spam", 6, false).setLabelColor(new Color(255, 128, 128));
        canTuna = FoodRegistry.CreateCan("tuna", 6, false).setLabelColor(new Color(128, 192, 255));
        canPineapple = FoodRegistry.CreateCan("pineapple", 6, false).setLabelColor(Color.YELLOW);
        canBeetroot = FoodRegistry.CreateCan("beetroot", 6, false).setLabelColor(new Color(64, 0, 64));
        canPeaches = FoodRegistry.CreateCan("peaches", 6, false).setLabelColor(new Color(192, 128, 0));
        sodaEmpty = FoodRegistry.CreateSoda("empty", 0, 0.0f).setIndedible();
        sodaCola = FoodRegistry.CreateSoda("cola", 4).setLabelColor(Color.RED, Color.WHITE);
        sodaRootBeer = FoodRegistry.CreateSoda("root_beer", 4).setLabelColor(new Color(96, 64, 32), new Color(128, 72, 64));
        sodaGingerBeer = FoodRegistry.CreateSoda("ginger_beer", 4).setLabelColor(new Color(192, 128, 96), new Color(128, 72, 64));
        sodaGingerAle = FoodRegistry.CreateSoda("ginger_ale", 4).setLabelColor(new Color(0, 108, 0), new Color(128, 192, 0));
        sodaCreaming = FoodRegistry.CreateSoda("creaming", 4).setLabelColor(new Color(255, 96, 96), Color.PINK);
        sodaCrush = FoodRegistry.CreateSoda("orange", 4).setLabelColor(new Color(255, 192, 0), Color.BLUE);
        sodaLemonade = FoodRegistry.CreateSoda("lemonade", 4).setLabelColor(Color.BLUE, new Color(128, 128, 255));
        sodaSarsaparilla = FoodRegistry.CreateSoda("sarsaparilla", 4).setLabelColor(Color.DARK_GRAY, Color.BLACK);
        sodaLemLimBit = FoodRegistry.CreateSoda("lem_lim_bit", 4).setLabelColor(Color.GREEN, Color.YELLOW);
        sodaGuava = FoodRegistry.CreateSoda("guava", 4).setLabelColor(Color.PINK, Color.RED);
        sodaPassionfruit = FoodRegistry.CreateSoda("passionfruit", 4).setLabelColor(Color.YELLOW, new Color(255, 128, 255));
        sodaPineapple = FoodRegistry.CreateSoda("pineapple", 4).setLabelColor(Color.YELLOW, Color.WHITE);
        sodaRaspberry = FoodRegistry.CreateSoda("raspberry", 4).setLabelColor(Color.PINK, Color.PINK);
        juiceApple = FoodRegistry.CreateJuice("apple", 3).setLabelColor(Color.RED, Color.WHITE);
        juiceOrange = FoodRegistry.CreateJuice("orange", 3).setLabelColor(new Color(255, 192, 0), new Color(255, 192, 0));
        juicePineapple = FoodRegistry.CreateJuice("pineapple", 3).setLabelColor(Color.YELLOW, Color.YELLOW);
        juiceGrape = FoodRegistry.CreateJuice("grape", 3).setLabelColor(new Color(255, 0, 255), new Color(192, 0, 192));
        juiceMango = FoodRegistry.CreateJuice("mango", 3).setLabelColor(Color.YELLOW, new Color(255, 192, 0));
        juiceMilkPlain = FoodRegistry.CreateJuice("milk_plain", 4).setLabelColor(Color.WHITE, Color.BLUE);
        juiceMilkStrawberry = FoodRegistry.CreateJuice("milk_strawberry", 4).setLabelColor(Color.WHITE, Color.PINK);
        juiceMilkChocolate = FoodRegistry.CreateJuice("milk_chocolate", 4).setLabelColor(Color.WHITE, new Color(96, 64, 32));
        barChocolate = FoodRegistry.CreateBar("chocolate", 3).setLabelColor(new Color(96, 64, 32), new Color(96, 64, 32));
        barDarkChoc = FoodRegistry.CreateBar("dark_choc", 3).setLabelColor(new Color(96, 64, 32), new Color(64, 32, 16));
        barWhiteChoc = FoodRegistry.CreateBar("white_choc", 3).setLabelColor(new Color(96, 64, 32), Color.WHITE);
        barTrailMix = FoodRegistry.CreateBar("trail_mix", 4).setLabelColor(new Color(170, 150, 110), new Color(200, 180, 140));
        plainChips = FoodRegistry.CreatePacket("plain_chips", 5).setLabelColor(Color.BLUE, Color.YELLOW);
        svChips = FoodRegistry.CreatePacket("sv_chips", 5).setLabelColor(new Color(255, 0, 255), Color.YELLOW);
        chickenChips = FoodRegistry.CreatePacket("chicken_chips", 5).setLabelColor(Color.GREEN, Color.YELLOW);
    }

    public static void initRecipes() {
        for (ItemCannedFood can : allCans) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)can, 1, 1), (Object[])new Object[]{new ItemStack((Item)MiscRegistry.canOpener, 1, Short.MAX_VALUE), new ItemStack((Item)can, 1, 0)});
        }
        FoodRegistry.SetCookableCan(canEmpty, true);
        FoodRegistry.SetCookableCan(canChickenSoup, false);
        FoodRegistry.SetCookableCan(canPumpkinSoup, true);
        FoodRegistry.SetCookableCan(canTomatoSoup, true);
        FoodRegistry.SetCookableCan(canBeefChunks, false);
        FoodRegistry.SetCookableCan(canSpam, true);
    }

    private static ItemCannedFood CreateCan(String name, int food, boolean dogFood) {
        return FoodRegistry.CreateCan(name, food, 0.6f, dogFood);
    }

    private static ItemCannedFood CreateCan(String name, int food, float sat, boolean dogFood) {
        ItemCannedFood can = new ItemCannedFood(food, sat, dogFood);
        can.func_77655_b("littlelooter.can." + name);
        QuickRegister.registerItem((Item)can, "can_" + name);
        allCans.add(can);
        return can;
    }

    private static ItemSodaCan CreateSoda(String name, int food) {
        return FoodRegistry.CreateSoda(name, food, 0.6f);
    }

    private static ItemSodaCan CreateSoda(String name, int food, float sat) {
        ItemSodaCan soda = new ItemSodaCan(food, sat);
        soda.func_77655_b("littlelooter.soda." + name);
        QuickRegister.registerItem((Item)soda, "soda_" + name);
        allSoda.add(soda);
        return soda;
    }

    private static ItemFoodBar CreateBar(String name, int food) {
        return FoodRegistry.CreateBar(name, food, 0.6f);
    }

    private static ItemFoodBar CreateBar(String name, int food, float sat) {
        ItemFoodBar bar = new ItemFoodBar(food, sat);
        bar.func_77655_b("littlelooter.bar." + name);
        QuickRegister.registerItem((Item)bar, "bar_" + name);
        allBars.add(bar);
        return bar;
    }

    private static ItemJuiceBox CreateJuice(String name, int food) {
        return FoodRegistry.CreateJuice(name, food, 0.6f);
    }

    private static ItemJuiceBox CreateJuice(String name, int food, float sat) {
        ItemJuiceBox juice = new ItemJuiceBox(food, sat);
        juice.func_77655_b("littlelooter.juice." + name);
        QuickRegister.registerItem((Item)juice, "juice_" + name);
        allJuice.add(juice);
        return juice;
    }

    private static ItemFoodPacket CreatePacket(String name, int food) {
        return FoodRegistry.CreatePacket(name, food, 0.6f);
    }

    private static ItemFoodPacket CreatePacket(String name, int food, float sat) {
        ItemFoodPacket packet = new ItemFoodPacket(food, sat);
        packet.func_77655_b("littlelooter.packet." + name);
        QuickRegister.registerItem((Item)packet, "packet_" + name);
        allPackets.add(packet);
        return packet;
    }

    private static void SetCookableCan(ItemCannedFood can, boolean safeRaw) {
        can.setCookable(safeRaw);
        GameRegistry.addSmelting((ItemStack)new ItemStack((Item)can, 1, 1), (ItemStack)new ItemStack((Item)can, 1, 2), (float)0.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public static void initRenderers() {
        for (ItemCannedFood can : allCans) {
            FoodRegistry.registerCanRender(can);
        }
        for (ItemSodaCan soda : allSoda) {
            FoodRegistry.registerSodaRender(soda);
        }
        for (ItemJuiceBox juice : allJuice) {
            FoodRegistry.registerJuiceRender(juice);
        }
        for (ItemFoodBar bar : allBars) {
            FoodRegistry.registerBarRender(bar);
        }
        for (ItemFoodPacket packet : allPackets) {
            FoodRegistry.registerPacketRender(packet);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerCanRender(ItemCannedFood can) {
        QuickRegister.registerItemModel((Item)can, "can_closed", "can_opened", "can_cooked");
        QuickRegister.registerColors(ItemColoredLabel.INSTANCE, new Item[]{can});
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerSodaRender(ItemSodaCan soda) {
        QuickRegister.registerItemModel((Item)soda, "soda_can");
        QuickRegister.registerColors(ItemColoredLabel.INSTANCE, new Item[]{soda});
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerBarRender(ItemFoodBar bar) {
        QuickRegister.registerItemModel((Item)bar, "food_bar");
        QuickRegister.registerColors(ItemColoredLabel.INSTANCE, new Item[]{bar});
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerJuiceRender(ItemJuiceBox juice) {
        QuickRegister.registerItemModel((Item)juice, "juice_box");
        QuickRegister.registerColors(ItemColoredLabel.INSTANCE, new Item[]{juice});
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerPacketRender(ItemFoodPacket packet) {
        QuickRegister.registerItemModel((Item)packet, "packet");
        QuickRegister.registerColors(ItemColoredLabel.INSTANCE, new Item[]{packet});
    }

    static {
        allSoda = new ArrayList();
        allJuice = new ArrayList();
        allBars = new ArrayList();
        allPackets = new ArrayList();
    }
}

