/*
 * Decompiled with CFR 0.152.
 */
package littlelooter.core;

import littlelooter.blocks.BlockAirDrop;
import littlelooter.blocks.BlockBarrel;
import littlelooter.blocks.BlockLaserBeacon;
import littlelooter.blocks.BlockLaserBeaconActive;
import littlelooter.blocks.BlockLootableBase;
import littlelooter.blocks.BlockStoreShelf;
import littlelooter.blocks.tiles.TileEntityAirDrop;
import littlelooter.blocks.tiles.TileEntityBarrel;
import littlelooter.blocks.tiles.TileEntityLaserBeacon;
import littlelooter.blocks.tiles.TileEntityStoreShelf;
import littlelooter.core.TabFood;
import littlelooter.core.TabLootables;
import littlelooter.core.TabMelee;
import littlelooter.core.TabMisc;
import littlelooter.core.proxies.CommonProxy;
import littlelooter.handlers.ConfigHandler;
import littlelooter.handlers.GuiHandler;
import littlelooter.handlers.LLSounds;
import littlelooter.items.blocks.ItemBlockLootable;
import littlelooter.items.food.FoodRegistry;
import littlelooter.items.misc.MiscRegistry;
import littlelooter.items.weapons.MeleeRegistry;
import littlelooter.utils.QuickRegister;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.Logger;

@Mod(modid="littlelooter", version="1.0.3", name="Little Looter", guiFactory="littlelooter.handlers.ConfigGuiFactory", acceptedMinecraftVersions="[1.10.2]")
public class LittleLooter {
    public static final String MODID = "littlelooter";
    public static final String VERSION = "1.0.3";
    public static final String HASH = "CI_MOD_HASH";
    public static final String BRANCH = "CI_MOD_BRANCH";
    public static final String NAME = "Little Looter";
    public static final String PROXY = "littlelooter.core.proxies";
    public static final String CHANNEL = "LL_NET_CHAN";
    @Mod.Instance(value="littlelooter")
    public static LittleLooter instance;
    @SidedProxy(clientSide="littlelooter.core.proxies.ClientProxy", serverSide="littlelooter.core.proxies.CommonProxy")
    public static CommonProxy proxy;
    public SimpleNetworkWrapper network;
    public static Logger logger;
    public static CreativeTabs tabLootables;
    public static CreativeTabs tabFood;
    public static CreativeTabs tabMelee;
    public static CreativeTabs tabMisc;
    public static Block airDrop;
    public static Block laserBeaconIdle;
    public static Block laserBeaconActive;
    public static BlockLootableBase storeShelf;
    public static BlockLootableBase barrel;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        this.network = NetworkRegistry.INSTANCE.newSimpleChannel(CHANNEL);
        ConfigHandler.config = new Configuration(event.getSuggestedConfigurationFile(), true);
        ConfigHandler.initConfigs();
        proxy.registerHandlers();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        QuickRegister.registerBlock(airDrop, "air_drop");
        QuickRegister.registerBlock(laserBeaconActive, "laser_beacon_active");
        QuickRegister.registerBlock(laserBeaconIdle, "laser_beacon_idle");
        QuickRegister.registerBlock((Block)storeShelf, new ItemBlockLootable(storeShelf), "store_shelf");
        QuickRegister.registerBlock((Block)barrel, new ItemBlockLootable(barrel), "barrel");
        GameRegistry.registerTileEntity(TileEntityLaserBeacon.class, (String)"laser_beacon");
        GameRegistry.registerTileEntity(TileEntityAirDrop.class, (String)"air_drop");
        GameRegistry.registerTileEntity(TileEntityStoreShelf.class, (String)"store_shelf");
        GameRegistry.registerTileEntity(TileEntityBarrel.class, (String)"barrel");
        FoodRegistry.initRegistry();
        MeleeRegistry.initRegistry();
        MiscRegistry.initRegistry();
        FoodRegistry.initRecipes();
        MeleeRegistry.initRecipes();
        MiscRegistry.initRecipes();
        proxy.registerRenderers();
        LLSounds.RegisterSounds();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    static {
        tabLootables = new TabLootables();
        tabFood = new TabFood();
        tabMelee = new TabMelee();
        tabMisc = new TabMisc();
        airDrop = new BlockAirDrop();
        laserBeaconIdle = new BlockLaserBeacon();
        laserBeaconActive = new BlockLaserBeaconActive();
        storeShelf = new BlockStoreShelf();
        barrel = new BlockBarrel();
    }
}

