/*
 * Decompiled with CFR 0.152.
 */
package littlelooter.blocks.tiles;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import littlelooter.core.LL_Settings;
import littlelooter.inventory.ContainerLootable;
import littlelooter.loot.CustomLootTableManager;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;

public abstract class TileEntityLootableBase
extends TileEntity
implements IInventory,
IInteractionObject,
ITickable {
    protected boolean restockable = false;
    protected ItemStack[] stacks = new ItemStack[0];
    protected String customName;
    protected long lastRestock = 0L;

    public TileEntityLootableBase(int size) {
        this.stacks = new ItemStack[size];
    }

    public void setRestockable(boolean flag) {
        this.restockable = flag;
    }

    public boolean canRestock() {
        return this.restockable;
    }

    public String getUnlocalisedName() {
        return this.field_145854_h != null ? this.func_145838_q().func_149739_a() + ".name" : "tile.chest.name";
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : this.getUnlocalisedName();
    }

    public boolean func_145818_k_() {
        return this.customName != null;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_70302_i_() {
        return this.stacks.length;
    }

    public ItemStack func_70301_a(int index) {
        return this.stacks[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a((ItemStack[])this.stacks, (int)index, (int)count);
        if (itemstack != null) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a((ItemStack[])this.stacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.stacks[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.stacks.length; ++i) {
            this.stacks[i] = null;
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        this.stacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.stacks.length) continue;
            this.stacks[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
        this.restockable = compound.func_74767_n("restockable");
        this.lastRestock = compound.func_74763_f("restocked");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.stacks.length; ++i) {
            if (this.stacks[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            this.stacks[i].func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        compound.func_74757_a("restockable", this.restockable);
        compound.func_74772_a("restocked", this.lastRestock);
        return compound;
    }

    public void setRestocked(World world) {
        this.lastRestock = world.func_82737_E();
    }

    public long TimeSinceRestock(World world) {
        return world.func_82737_E() - this.lastRestock;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerLootable((IInventory)playerInventory, this);
    }

    public String func_174875_k() {
        return null;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K || !this.canRestock() || this.TimeSinceRestock(this.field_145850_b) < (long)LL_Settings.restockTime) {
            return;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        AxisAlignedBB tBounds = state.func_185900_c((IBlockAccess)this.field_145850_b, this.field_174879_c).func_186670_a(this.field_174879_c).func_186662_g((double)LL_Settings.restockDist);
        List list = this.field_145850_b.func_72872_a(EntityPlayer.class, tBounds);
        if (list == null || list.size() <= 0) {
            LootTable table;
            this.func_174888_l();
            ArrayList<ResourceLocation> loots = CustomLootTableManager.LOOT_MAP.get(state.func_177230_c().getRegistryName());
            if (loots != null && loots.size() > 0 && (table = this.field_145850_b.func_184146_ak().func_186521_a(loots.get(this.field_145850_b.field_73012_v.nextInt(loots.size())))) != null) {
                int i;
                LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)this.field_145850_b);
                List contents = table.func_186462_a(this.field_145850_b.field_73012_v, lootcontext$builder.func_186471_a());
                ArrayList<Integer> slots = new ArrayList<Integer>();
                for (i = 0; i < this.func_70302_i_(); ++i) {
                    slots.add(i);
                }
                Collections.shuffle(slots, this.field_145850_b.field_73012_v);
                for (i = 0; i < contents.size() && i < slots.size(); ++i) {
                    this.func_70299_a((Integer)slots.get(i), (ItemStack)contents.get(i));
                }
                this.setRestocked(this.field_145850_b);
            }
            this.field_145850_b.func_73046_m().func_184103_al().func_148543_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 64.0, this.field_145850_b.field_73011_w.getDimension(), (Packet)this.func_189518_D_());
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }
}

