/*
 * Decompiled with CFR 0.152.
 */
package littlelooter.blocks;

import javax.annotation.Nullable;
import littlelooter.blocks.tiles.TileEntityLootableBase;
import littlelooter.core.LittleLooter;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class BlockLootableBase
extends BlockContainer {
    protected boolean quickLoot = true;

    public BlockLootableBase(Material materialIn) {
        super(materialIn);
        this.func_149675_a(true);
    }

    public BlockLootableBase setQuickLoot(boolean allow) {
        this.quickLoot = allow;
        return this;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityLootableBase) {
            TileEntityLootableBase lootable = (TileEntityLootableBase)tile;
            if (playerIn.func_70093_af() || !this.quickLoot) {
                playerIn.openGui((Object)LittleLooter.instance, 0, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            } else {
                for (int i = 0; i < lootable.func_70302_i_(); ++i) {
                    ItemStack stack = lootable.func_70304_b(i);
                    if (stack == null) continue;
                    if (!playerIn.field_71071_by.func_70441_a(stack)) {
                        playerIn.func_146097_a(stack, true, false);
                        continue;
                    }
                    worldIn.func_184148_a((EntityPlayer)null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((playerIn.func_70681_au().nextFloat() - playerIn.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                }
            }
            worldIn.func_73046_m().func_184103_al().func_148540_a((Packet)lootable.func_189518_D_());
        }
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityLootableBase) {
            TileEntityLootableBase lootable = (TileEntityLootableBase)tile;
            if (stack.func_82837_s()) {
                lootable.setCustomName(stack.func_82833_r());
            }
            if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("restockable")) {
                lootable.setRestockable(true);
            }
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityLootableBase) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((TileEntityLootableBase)tileentity));
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public abstract TileEntityLootableBase createTileLootable(World var1, int var2);

    public final TileEntity func_149915_a(World worldIn, int meta) {
        return this.createTileLootable(worldIn, meta);
    }
}

