/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.utility.debug;

import com.infinityraider.infinitylib.InfinityLib;
import com.infinityraider.infinitylib.utility.debug.DebugMode;
import com.infinityraider.infinitylib.utility.debug.IDebuggable;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;

public class DebugModeFeedback
extends DebugMode {
    @Override
    public String debugName() {
        return "feedback";
    }

    @Override
    public void debugActionBlockClicked(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        this.getDebugData(world, pos, l -> {
            InfinityLib.instance.getLogger().debug((String)l, new Object[0]);
            player.func_146105_b((ITextComponent)new TextComponentString(l));
        });
    }

    @Override
    public void debugActionClicked(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
    }

    @Override
    public void debugActionEntityClicked(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
    }

    private void getDebugData(World world, BlockPos pos, Consumer<String> consumer) {
        Side side = world.field_72995_K ? Side.CLIENT : Side.SERVER;
        TileEntity tile = world.func_175625_s(pos);
        consumer.accept("------------------");
        consumer.accept(side + " debug info:");
        consumer.accept("------------------");
        consumer.accept("Clicked block at (" + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p() + ")");
        if (tile instanceof IDebuggable) {
            IDebuggable debuggable = (IDebuggable)tile;
            if (side == Side.CLIENT) {
                debuggable.addClientDebugInfo(consumer);
            } else {
                debuggable.addServerDebugInfo(consumer);
            }
        } else {
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            consumer.accept("Block: " + Block.field_149771_c.func_177774_c((Object)block));
            consumer.accept("Meta: " + block.func_176201_c(state));
        }
        consumer.accept(" ");
    }
}

