/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.render.block;

import com.google.common.base.Function;
import com.infinityraider.infinitylib.block.BlockBase;
import com.infinityraider.infinitylib.render.DefaultTransforms;
import com.infinityraider.infinitylib.render.block.IBlockRenderingHandler;
import com.infinityraider.infinitylib.render.item.BakedInfItemSuperModel;
import com.infinityraider.infinitylib.render.tessellation.TessellatorBakedQuad;
import com.infinityraider.infinitylib.utility.HashableBlockState;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class BakedInfBlockModel<B extends BlockBase>
implements IBakedModel {
    private final B block;
    private final VertexFormat format;
    private final IBlockRenderingHandler<B> renderer;
    private final Function<ResourceLocation, TextureAtlasSprite> textures;
    private final BakedInfItemSuperModel itemRenderer;
    private final Map<HashableBlockState, Map<EnumFacing, List<BakedQuad>>> cachedQuads;

    BakedInfBlockModel(B block, VertexFormat format, IBlockRenderingHandler<B> renderer, Function<ResourceLocation, TextureAtlasSprite> textures, boolean inventory) {
        this.block = (BlockBase)Objects.requireNonNull(block, "The block for a BakedInfBlockModel must not be null!");
        this.format = Objects.requireNonNull(format, "The vertex format for a BakedInfBlockModel must not be null!");
        this.renderer = Objects.requireNonNull(renderer, "The renderer for a BakedInfBlockModel must not be null!");
        this.textures = Objects.requireNonNull(textures, "The texture provider for a BakedInfBlockModel must not be null!");
        this.itemRenderer = inventory ? new BakedInfItemSuperModel<IBlockRenderingHandler<B>>(format, this.renderer, textures, DefaultTransforms::getBlockMatrix) : null;
        this.cachedQuads = new HashMap<HashableBlockState, Map<EnumFacing, List<BakedQuad>>>();
    }

    public List<BakedQuad> func_188616_a(IBlockState state, @Nullable EnumFacing side, long rand) {
        return this.cachedQuads.computeIfAbsent(new HashableBlockState(state), e -> new HashMap()).computeIfAbsent(side, s -> this.createQuads(state, (EnumFacing)s, rand));
    }

    private List<BakedQuad> createQuads(IBlockState state, EnumFacing side, long rand) {
        TessellatorBakedQuad tessellator = TessellatorBakedQuad.getInstance().setTextureFunction(this.textures).setCurrentFace(side);
        tessellator.startDrawingQuads(this.format);
        this.renderer.renderWorldBlockStatic(tessellator, state, this.block, side);
        List<BakedQuad> result = tessellator.getQuads();
        tessellator.draw();
        return result;
    }

    public boolean func_177555_b() {
        return this.renderer.applyAmbientOcclusion();
    }

    public boolean func_177556_c() {
        return this.renderer.doInventoryRendering();
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.renderer.getIcon();
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return this.itemRenderer.func_188617_f();
    }
}

