/*
 * Decompiled with CFR 0.152.
 */
package crybaby.items;

import crybaby.Crybaby;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTearBottle
extends Item {
    private static ItemTearBottle instance;

    public static ItemTearBottle getInstance() {
        return instance == null ? (instance = new ItemTearBottle()) : instance;
    }

    public ItemTearBottle() {
        this.func_77637_a(Crybaby.getInstance().getCreativeTab());
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.func_77655_b("tear_bottle");
        this.setRegistryName(new ResourceLocation("crybaby:tear_bottle"));
        GameRegistry.register((IForgeRegistryEntry)this);
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.registerModels();
        }
    }

    public ItemStack initStack(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_150297_b("crying", 1)) {
            stack.func_77978_p().func_74757_a("crying", false);
        }
        return stack;
    }

    public ItemStack initStack() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("crying", true);
        ItemStack stack = new ItemStack((Item)ItemTearBottle.getInstance(), 1, Crybaby.getInstance().getCryingTime());
        stack.func_77982_d(nbt);
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        int cryingTime = Crybaby.getInstance().getCryingTime();
        for (int meta = 0; meta <= cryingTime; ++meta) {
            int tears = 6 * (cryingTime - meta) / cryingTime;
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)meta, (ModelResourceLocation)new ModelResourceLocation("crybaby:tear_bottle_" + tears));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List<ItemStack> list) {
        list.add(this.initStack(new ItemStack(item, 1, 0)));
        list.add(this.initStack());
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (stack.func_77952_i() > 0 && !Crybaby.getInstance().isCrying(player)) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return stack.func_77952_i() == 0 || Crybaby.getInstance().isCrying(stack) ? EnumAction.NONE : EnumAction.DRINK;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entity) {
        if (stack.func_77952_i() > 0 && entity instanceof EntityPlayer && !Crybaby.getInstance().isCrying((EntityPlayer)entity)) {
            Crybaby.getInstance().startCrying(stack);
            int debuffTime = Crybaby.getInstance().getDebuffTime();
            for (String potionName : Crybaby.getInstance().getDebuffs()) {
                Potion potion = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation(potionName));
                PotionEffect effect = entity.func_70660_b(potion);
                if (effect != null) {
                    entity.func_70690_d(new PotionEffect(potion, effect.func_76459_b() + debuffTime, effect.func_76458_c(), effect.func_82720_e(), effect.func_188418_e()));
                    continue;
                }
                entity.func_70690_d(new PotionEffect(potion, debuffTime));
            }
        }
        return stack;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof EntityPlayer && Crybaby.getInstance().isCrying(stack)) {
            EntityPlayer player = (EntityPlayer)entity;
            if (!Crybaby.getInstance().isDoubleCrying(player)) {
                if (stack != null && stack.func_77973_b().equals((Object)ItemTearBottle.getInstance()) && stack.func_77952_i() > 0) {
                    stack.func_77964_b(stack.func_77952_i() - 1);
                    if (stack.func_77952_i() <= 0) {
                        stack.func_77964_b(0);
                        Crybaby.getInstance().stopCrying(stack);
                    }
                }
            } else {
                Crybaby.getInstance().stopCrying(stack);
            }
        }
    }
}

