/*
 * Decompiled with CFR 0.152.
 */
package crybaby;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import crybaby.CrybabyRecipes;
import crybaby.items.ItemSaltBottle;
import crybaby.items.ItemTearBottle;
import crybaby.recipe.ShapelessOreOutRecipe;
import crybaby.sounds.CrybabySounds;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.RecipeSorter;

@Mod(modid="crybaby", acceptedMinecraftVersions="[1.10.2]")
public class Crybaby {
    @Mod.Instance
    private static Crybaby instance;
    private CreativeTabs creativeTab = new CreativeTabs("crybaby"){

        public Item func_78016_d() {
            return ItemTearBottle.getInstance();
        }
    };
    private Configuration config;
    private int smeltExperience;
    private int cryingTime;
    private int debuffTime;
    private float cryingVolume;
    private List<String> debuffs;
    private Map<UUID, Long> lastCries = Maps.newHashMap();

    private void loadConfig() {
        this.smeltExperience = this.config.getInt("smeltExperience", "general", 5, 0, Integer.MAX_VALUE, "Amount of experience from smelting one bottle of tears into a bottle of salt");
        this.cryingTime = this.config.getInt("cryingTime", "general", 400, 1, Integer.MAX_VALUE, "Time, in ticks, to fully fill a bottle with tears (Note: this will affect the meta value of the empty bottle, but not the filled one)");
        this.debuffTime = this.config.getInt("debuffTime", "general", 400, 0, Integer.MAX_VALUE, "Time, int ticks, of the debuffs a player gets from crying");
        this.debuffs = ImmutableList.copyOf((Object[])this.config.getStringList("debuffs", "general", new String[]{"minecraft:slowness", "minecraft:weakness"}, "List of debuffs a player gets from crying"));
        this.cryingVolume = this.config.getFloat("cryingVolume", "general", 0.5f, 0.0f, 1.0f, "Volume of crying sound");
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        this.loadConfig();
        ItemTearBottle.getInstance();
        ItemSaltBottle.getInstance();
        CrybabySounds.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
        RecipeSorter.register((String)"crybaby:shapelessoreout", ShapelessOreOutRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapelessore");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        CrybabyRecipes.init();
    }

    public void startCrying(ItemStack stack) {
        if (stack != null && stack.func_77973_b() == ItemTearBottle.getInstance()) {
            ItemTearBottle.getInstance().initStack(stack).func_77978_p().func_74757_a("crying", true);
        }
    }

    public void stopCrying(ItemStack stack) {
        if (stack != null && stack.func_77973_b() == ItemTearBottle.getInstance()) {
            if (stack.func_77942_o()) {
                stack.func_77978_p().func_74757_a("crying", false);
            } else {
                ItemTearBottle.getInstance().initStack(stack).func_77978_p().func_74757_a("crying", false);
            }
        }
    }

    public boolean isCrying(EntityPlayer player) {
        for (ItemStack stack : player.field_71069_bz.field_75153_a) {
            if (!this.isCrying(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean isDoubleCrying(EntityPlayer player) {
        boolean single = false;
        for (ItemStack stack : player.field_71069_bz.field_75153_a) {
            if (!this.isCrying(stack)) continue;
            if (single) {
                return true;
            }
            single = true;
        }
        return false;
    }

    public boolean isCrying(ItemStack stack) {
        if (stack != null && stack.func_77973_b() == ItemTearBottle.getInstance()) {
            return ItemTearBottle.getInstance().initStack(stack).func_77978_p().func_74767_n("crying");
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSound(PlaySoundAtEntityEvent event) {
        if (!event.isCanceled() && event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (event.getSound().equals(SoundEvents.field_187664_bz) && player.func_184607_cu().func_77973_b().equals((Object)ItemTearBottle.getInstance())) {
                long lastCry = this.lastCries.getOrDefault(player.func_110124_au(), 0L);
                if (System.currentTimeMillis() - lastCry >= 3000L) {
                    this.lastCries.put(player.func_110124_au(), System.currentTimeMillis());
                    event.setSound(CrybabySounds.crying);
                    event.setVolume(this.getCryingVolume());
                } else {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDamage(LivingAttackEvent event) {
        if (!event.isCanceled() && event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            for (Slot slot : player.field_71069_bz.field_75151_b) {
                ItemStack stack = slot.func_75211_c();
                if (stack == null || !stack.func_77973_b().equals((Object)ItemTearBottle.getInstance()) || stack.func_77952_i() <= 0) continue;
                stack.func_77964_b(stack.func_77952_i() - 1);
                player.field_71071_by.func_70299_a(slot.getSlotIndex(), stack);
                break;
            }
        }
    }

    public static Crybaby getInstance() {
        return instance;
    }

    public CreativeTabs getCreativeTab() {
        return this.creativeTab;
    }

    public int getSmeltExperience() {
        return this.smeltExperience;
    }

    public int getCryingTime() {
        return this.cryingTime;
    }

    public int getDebuffTime() {
        return this.debuffTime;
    }

    public float getCryingVolume() {
        return this.cryingVolume;
    }

    public List<String> getDebuffs() {
        return this.debuffs;
    }
}

