/*
 * Decompiled with CFR 0.152.
 */
package com.voxels.worldgen;

import com.voxels.Voxels;
import com.voxels.entities.EntityCreeperChild;
import com.voxels.entities.EntityCreeperCitizen;
import com.voxels.entities.EntityCreeperFarmer;
import com.voxels.entities.EntityCreeperGuard;
import com.voxels.entities.EntityCreeperMiner;
import com.voxels.entities.EntityCreeperRancher;
import com.voxels.entities.EntityCreeperScientist;
import com.voxels.worldgen.WorldGenCreeperVillage;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenCV
implements IWorldGenerator {
    private int villFlag = 500;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 0: {
                this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    private void generateSurface(World world, Random random, int BlockX, int BlockZ) {
        ++this.villFlag;
        int villFreq = 800;
        villFreq = Voxels.CreeperVillageFrequency <= 1 ? 1200 : (Voxels.CreeperVillageFrequency >= 10 ? 120 : 1200 - Voxels.CreeperVillageFrequency * 100);
        if (this.villFlag > villFreq) {
            boolean creeperFlag = false;
            int esize = world.field_72996_f.size();
            for (int k = 0; k <= esize - 1; ++k) {
                Entity entity = (Entity)world.field_72996_f.get(k);
                if (entity == null || !(entity instanceof EntityVillager) && !(entity instanceof EntityCreeperCitizen) && !(entity instanceof EntityCreeperGuard) && !(entity instanceof EntityCreeperMiner) && !(entity instanceof EntityCreeperFarmer) && !(entity instanceof EntityCreeperRancher) && !(entity instanceof EntityCreeperChild) && !(entity instanceof EntityCreeperScientist)) continue;
                double xt = entity.field_70165_t;
                double yt = entity.field_70163_u;
                double zt = entity.field_70161_v;
                int x1 = BlockX;
                int y1 = (int)entity.field_70163_u;
                int z1 = BlockZ;
                double x2 = xt - (double)x1;
                double y2 = yt - (double)y1;
                double z2 = zt - (double)z1;
                if (MathHelper.func_76130_a((int)((int)x2)) >= 200 || MathHelper.func_76130_a((int)((int)z2)) >= 50 || MathHelper.func_76130_a((int)((int)y2)) >= 200) continue;
                creeperFlag = true;
                break;
            }
            if (!creeperFlag) {
                int Zcoord;
                int Xcoord = BlockX + random.nextInt(16);
                Biome biomegenbase = world.func_180494_b(new BlockPos(Xcoord, 0, Zcoord = BlockZ + random.nextInt(16)));
                if (biomegenbase.func_185359_l().contains("Plains") && Voxels.villagePlains || biomegenbase.func_185359_l().equals("Desert") && Voxels.villageDesert || biomegenbase.func_185359_l().equals("Savanna") && Voxels.villageSavanna || biomegenbase.func_185359_l().equals("Ocean") && Voxels.villageOcean) {
                    this.villFlag = 0;
                    BlockPos chk = new BlockPos(BlockX, 0, BlockZ);
                    int RandPosX = BlockX + random.nextInt(16);
                    int RandPosY = world.func_175672_r(chk).func_177956_o();
                    int RandPosZ = BlockZ + random.nextInt(16);
                    new WorldGenCreeperVillage().func_180709_b(world, random, new BlockPos(RandPosX, RandPosY, RandPosZ));
                } else {
                    villFreq /= 3;
                }
            } else {
                villFreq /= 3;
            }
        }
    }
}

