/*
 * Decompiled with CFR 0.152.
 */
package com.voxels.events;

import com.voxels.ModSoundEvents;
import com.voxels.VoxelAchievements;
import com.voxels.Voxels;
import com.voxels.capabilities.CapabilityRefs;
import com.voxels.capabilities.ICapabilityPlayer;
import com.voxels.entities.EntityCreeperChild;
import com.voxels.entities.EntityCreeperCitizen;
import com.voxels.entities.EntityCreeperCustom;
import com.voxels.entities.EntityCreeperEliteGuard;
import com.voxels.entities.EntityCreeperFarmer;
import com.voxels.entities.EntityCreeperGuard;
import com.voxels.entities.EntityCreeperLabAssistant;
import com.voxels.entities.EntityCreeperMayor;
import com.voxels.entities.EntityCreeperMegaMayor;
import com.voxels.entities.EntityCreeperMiner;
import com.voxels.entities.EntityCreeperPlant;
import com.voxels.entities.EntityCreeperRancher;
import com.voxels.entities.EntityCreeperScientist;
import com.voxels.entities.EntityCreeperShady;
import com.voxels.network.VoxelSyncMessage;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EventCreeperDeath {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SubscribeEvent
    public void notify(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof EntityCreeperChild || event.getEntityLiving() instanceof EntityCreeperShady || event.getEntityLiving() instanceof EntityCreeperCustom || event.getEntityLiving() instanceof EntityCreeperFarmer || event.getEntityLiving() instanceof EntityCreeperGuard || event.getEntityLiving() instanceof EntityCreeperEliteGuard || event.getEntityLiving() instanceof EntityCreeperLabAssistant || event.getEntityLiving() instanceof EntityCreeperMayor || event.getEntityLiving() instanceof EntityCreeperMiner || event.getEntityLiving() instanceof EntityCreeperPlant || event.getEntityLiving() instanceof EntityCreeperRancher || event.getEntityLiving() instanceof EntityCreeperScientist || event.getEntityLiving() instanceof EntityCreeperCitizen || event.getEntityLiving() instanceof EntityCreeperMegaMayor) {
            EntityArrow entityarrow;
            World world = event.getEntity().field_70170_p;
            EntityPlayer entityplayer = null;
            if (!(event.getSource().func_76364_f() instanceof EntityPlayer) && !(event.getSource().func_76364_f() instanceof EntityArrow) && !(event.getSource().func_76364_f() instanceof EntityThrowable)) return;
            if (event.getSource().func_76364_f() instanceof EntityPlayer) {
                entityplayer = (EntityPlayer)event.getSource().func_76364_f();
            } else if (event.getSource().func_76364_f() instanceof EntityArrow) {
                entityarrow = (EntityArrow)event.getSource().func_76364_f();
                if (entityarrow == null || entityarrow.field_70250_c == null || !(entityarrow.field_70250_c instanceof EntityPlayer)) return;
                entityplayer = (EntityPlayer)entityarrow.field_70250_c;
            } else if (event.getSource().func_76364_f() instanceof EntityThrowable) {
                entityarrow = (EntityThrowable)event.getSource().func_76364_f();
                if (entityarrow == null || entityarrow.func_85052_h() == null || !(entityarrow.func_85052_h() instanceof EntityPlayer)) return;
                entityplayer = (EntityPlayer)entityarrow.func_85052_h();
            }
            if (entityplayer == null) {
                return;
            }
            ICapabilityPlayer props = CapabilityRefs.getPlayerCaps(entityplayer);
            int reputation = props.getReputation();
            int voxels = props.getVoxels();
            boolean mayorFlag = false;
            boolean shadyFlag = false;
            if (event.getEntityLiving() instanceof EntityCreeperChild) {
                reputation -= Voxels.RepKillChild;
                entityplayer.field_70170_p.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, ModSoundEvents.lose_rep, SoundCategory.PLAYERS, 0.3f, 1.0f);
                entityplayer.func_71064_a((StatBase)VoxelAchievements.crime, 1);
            } else if (event.getEntityLiving() instanceof EntityCreeperMayor) {
                reputation -= Voxels.RepKillMayor;
                entityplayer.field_70170_p.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, ModSoundEvents.lose_rep, SoundCategory.PLAYERS, 0.3f, 1.0f);
                entityplayer.func_71064_a((StatBase)VoxelAchievements.crime, 1);
                EntityCreeperMayor ecm = (EntityCreeperMayor)event.getEntityLiving();
                if (ecm.func_95999_t().contains("Mayor Mayo")) {
                    for (int k = 0; k < 64; ++k) {
                        EntityItem entityitem2 = new EntityItem(entityplayer.field_70170_p, entityplayer.field_70165_t + 0.5, entityplayer.field_70163_u + 10.0 + (double)(k * 10), entityplayer.field_70161_v + 0.5, new ItemStack(Voxels.creepermayo, 1));
                        entityplayer.field_70170_p.func_72838_d((Entity)entityitem2);
                    }
                } else {
                    boolean dflag = false;
                    Random rand = new Random();
                    for (int x = -32; x < 32; ++x) {
                        for (int y = -3; y < 32; ++y) {
                            for (int z = -32; z < 32; ++z) {
                                if (y < -2 && rand.nextInt(5) > 0) {
                                    entityplayer.field_70170_p.func_175698_g(new BlockPos((int)ecm.field_70165_t + x, (int)ecm.field_70163_u + y, (int)ecm.field_70161_v + z));
                                    continue;
                                }
                                entityplayer.field_70170_p.func_175698_g(new BlockPos((int)ecm.field_70165_t + x, (int)ecm.field_70163_u + y, (int)ecm.field_70161_v + z));
                            }
                        }
                    }
                    entityplayer.field_70170_p.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, ModSoundEvents.mayor_birth, SoundCategory.PLAYERS, 0.8f, 1.0f);
                    EntityCreeperMegaMayor emm = new EntityCreeperMegaMayor(entityplayer.field_70170_p);
                    emm.func_70107_b(ecm.field_70142_S + 7.0, ecm.field_70137_T, ecm.field_70136_U - 1.0);
                    world.func_72838_d((Entity)emm);
                    mayorFlag = true;
                }
            } else if (event.getEntityLiving() instanceof EntityCreeperShady) {
                reputation += Voxels.RepKillShady;
                entityplayer.field_70170_p.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, ModSoundEvents.gain_rep, SoundCategory.PLAYERS, 0.3f, 0.6f);
                shadyFlag = true;
            } else if (event.getEntityLiving() instanceof EntityCreeperMegaMayor) {
                reputation += Voxels.RepKillMegaMayor;
                entityplayer.field_70170_p.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, ModSoundEvents.gain_rep, SoundCategory.PLAYERS, 0.3f, 0.6f);
                entityplayer.func_71064_a((StatBase)VoxelAchievements.killMegaMayor, 1);
                mayorFlag = true;
            } else {
                reputation -= Voxels.RepKillCreeper;
                entityplayer.field_70170_p.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, ModSoundEvents.lose_rep, SoundCategory.PLAYERS, 0.3f, 1.0f);
                entityplayer.func_71064_a((StatBase)VoxelAchievements.crime, 1);
            }
            if (!entityplayer.field_71075_bZ.field_75098_d) {
                props.setReputation(reputation);
                props.setVoxels(voxels);
                Voxels.snw.sendTo((IMessage)new VoxelSyncMessage(reputation, voxels), (EntityPlayerMP)entityplayer);
            }
            boolean dflag = false;
            for (int x = -16; x < 16; ++x) {
                block5: for (int y = -10; y < 10; ++y) {
                    for (int z = -16; z < 16; ++z) {
                        Block chk = entityplayer.field_70170_p.func_180495_p(new BlockPos((int)entityplayer.field_70165_t + x, (int)entityplayer.field_70163_u + y, (int)entityplayer.field_70161_v + z)).func_177230_c();
                        if (chk == null || chk != Voxels.transgressiondetector) continue;
                        dflag = true;
                        continue block5;
                    }
                }
            }
            if (!shadyFlag && dflag && !mayorFlag) {
                entityplayer.field_70170_p.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, ModSoundEvents.detected, SoundCategory.PLAYERS, 100.0f, 0.9f);
            }
            if (entityplayer.field_70170_p.field_72995_K || reputation > -3 || !dflag || mayorFlag) return;
            entityplayer.field_70170_p.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, ModSoundEvents.alarm, SoundCategory.PLAYERS, 0.8f, 0.9f);
            entityplayer.func_71064_a((StatBase)VoxelAchievements.crime, 1);
            int esize = world.field_72996_f.size();
            for (int k = 0; k <= esize - 1; ++k) {
                EntityCreature ecg;
                Entity entity = (Entity)world.field_72996_f.get(k);
                if (entity != null && entity instanceof EntityCreeperGuard) {
                    ecg = (EntityCreeperGuard)entity;
                    ecg.func_70604_c((EntityLivingBase)entityplayer);
                    ecg.func_70652_k((Entity)entityplayer);
                    ecg.func_70624_b((EntityLivingBase)entityplayer);
                    ecg.func_130011_c((Entity)entityplayer);
                    continue;
                }
                if (entity == null || !(entity instanceof EntityCreeperEliteGuard)) continue;
                ecg = (EntityCreeperEliteGuard)entity;
                ecg.func_70604_c((EntityLivingBase)entityplayer);
                ecg.func_70652_k((Entity)entityplayer);
                ecg.func_70624_b((EntityLivingBase)entityplayer);
                ecg.func_130011_c((Entity)entityplayer);
            }
            int posY = world.func_175672_r(new BlockPos((int)entityplayer.field_70165_t - 6, 0, (int)entityplayer.field_70161_v - 6)).func_177956_o();
            EntityCreeperEliteGuard EntityC1 = new EntityCreeperEliteGuard(world);
            EntityC1.func_70107_b(entityplayer.field_70165_t - 6.0, posY + 1, entityplayer.field_70161_v - 6.0);
            world.func_72838_d((Entity)EntityC1);
            EntityC1.func_70604_c((EntityLivingBase)entityplayer);
            EntityC1.func_70652_k((Entity)entityplayer);
            EntityC1.func_70624_b((EntityLivingBase)entityplayer);
            EntityC1.func_130011_c((Entity)entityplayer);
            posY = world.func_175672_r(new BlockPos((int)entityplayer.field_70165_t + 6, 0, (int)entityplayer.field_70161_v + 6)).func_177956_o();
            EntityCreeperEliteGuard EntityC2 = new EntityCreeperEliteGuard(world);
            EntityC2.func_70107_b(entityplayer.field_70165_t + 6.0, posY + 1, entityplayer.field_70161_v + 6.0);
            world.func_72838_d((Entity)EntityC2);
            EntityC2.func_70604_c((EntityLivingBase)entityplayer);
            EntityC2.func_70652_k((Entity)entityplayer);
            EntityC2.func_70624_b((EntityLivingBase)entityplayer);
            EntityC2.func_130011_c((Entity)entityplayer);
            return;
        } else if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)event.getEntityLiving();
            if (entityplayer.field_71075_bZ.field_75098_d) return;
            ICapabilityPlayer props = CapabilityRefs.getPlayerCaps(entityplayer);
            int reputation = props.getReputation();
            int voxels = props.getVoxels();
            if (Voxels.LoseVoxelsonDeath != 1) {
                if (Voxels.LoseVoxelsonDeath == 3) {
                    int lost = (int)((double)voxels * 0.5);
                    voxels -= lost;
                    TextComponentTranslation bob1 = new TextComponentTranslation("message.voxels_voxels.lost", new Object[0]);
                    bob1.func_150258_a(lost + " ");
                    bob1.func_150257_a((ITextComponent)new TextComponentTranslation("message.voxels_voxels", new Object[0]));
                    bob1.func_150256_b().func_150238_a(TextFormatting.WHITE);
                    entityplayer.func_146105_b((ITextComponent)bob1);
                } else if (Voxels.LoseVoxelsonDeath == 4) {
                    entityplayer.func_146105_b((ITextComponent)new TextComponentTranslation("message.voxels_voxels.all", new Object[0]));
                    voxels = 0;
                } else {
                    int lost = (int)((double)voxels * 0.1);
                    voxels -= lost;
                    TextComponentTranslation bob1 = new TextComponentTranslation("message.voxels_voxels.lost", new Object[0]);
                    bob1.func_150258_a(" " + lost + " ");
                    bob1.func_150257_a((ITextComponent)new TextComponentTranslation("message.voxels_voxels", new Object[0]));
                    bob1.func_150256_b().func_150238_a(TextFormatting.WHITE);
                    entityplayer.func_146105_b((ITextComponent)bob1);
                }
            }
            props.setReputation(reputation);
            props.setVoxels(voxels);
            Voxels.snw.sendTo((IMessage)new VoxelSyncMessage(reputation, voxels), (EntityPlayerMP)entityplayer);
            return;
        } else {
            if (!(event.getEntityLiving() instanceof EntityCreeper) || !(event.getSource().func_76364_f() instanceof EntityPlayer)) return;
            Random rand = new Random();
            int chance = rand.nextInt(100);
            int chooser = rand.nextInt(3);
            if (chooser == 0) {
                if (chance >= 3) return;
                ItemStack bob = new ItemStack(Voxels.enchantedtnt, 1);
                EntityItem entityitem = new EntityItem(event.getEntityLiving().field_70170_p, event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, bob);
                event.getEntityLiving().field_70170_p.func_72838_d((Entity)entityitem);
                return;
            } else if (chooser == 1) {
                if (chance >= 6) return;
                ItemStack bob = new ItemStack(Voxels.enchantedgunpowder, 1);
                EntityItem entityitem = new EntityItem(event.getEntityLiving().field_70170_p, event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, bob);
                event.getEntityLiving().field_70170_p.func_72838_d((Entity)entityitem);
                return;
            } else {
                if (chooser != 2 || chance >= 11) return;
                ItemStack bob = new ItemStack(Voxels.enchantedflint, 1);
                EntityItem entityitem = new EntityItem(event.getEntityLiving().field_70170_p, event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, bob);
                event.getEntityLiving().field_70170_p.func_72838_d((Entity)entityitem);
            }
        }
    }
}

