/*
 * Decompiled with CFR 0.152.
 */
package com.voxels.events;

import com.voxels.VoxelAchievements;
import com.voxels.Voxels;
import com.voxels.capabilities.CapabilityRefs;
import com.voxels.capabilities.ICapabilityPlayer;
import com.voxels.network.VoxelSyncMessage;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CommandSetVoxels
extends CommandBase {
    public String func_71517_b() {
        return "voxels";
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "/voxels <voxels> or /voxels <player> <voxels>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender icommandsender, String[] astring) throws CommandException {
        if (icommandsender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)icommandsender;
            EntityPlayer affectedPlayer = null;
            if (astring.length == 0) {
                icommandsender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + I18n.func_74838_a((String)"message.voxels_voxels.usage")));
                return;
            }
            if (CommandSetVoxels.isParsable(astring[0]) && Integer.parseInt(astring[0]) < 0) {
                icommandsender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + I18n.func_74838_a((String)"message.voxels_voxels.negative")));
                return;
            }
            if (astring.length == 1 && !CommandSetVoxels.isParsable(astring[0])) {
                icommandsender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "'" + astring[0] + "'" + I18n.func_74838_a((String)"message.voxels_voxels.valid")));
                return;
            }
            if (astring.length == 2 && !CommandSetVoxels.isParsable(astring[1])) {
                icommandsender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "'" + astring[0] + "'" + I18n.func_74838_a((String)"message.voxels_voxels.valid")));
                return;
            }
            if (astring.length == 2 && CommandSetVoxels.isParsable(astring[1]) && (affectedPlayer = player.field_70170_p.func_72924_a(astring[0])) == null) {
                icommandsender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "'" + astring[0] + "' " + I18n.func_74838_a((String)"message.voxels_voxels.noplayer")));
                return;
            }
            if (astring.length == 1) {
                this.updateRep(icommandsender, astring[0]);
            } else if (astring.length == 2 && affectedPlayer != null) {
                this.updateRep((ICommandSender)affectedPlayer, astring[1]);
            }
        }
    }

    public void updateRep(ICommandSender icommandsender, String points) {
        EntityPlayer entityplayer = (EntityPlayer)icommandsender;
        ICapabilityPlayer props = CapabilityRefs.getPlayerCaps(entityplayer);
        int reputation = props.getReputation();
        int voxels = Integer.parseInt(points);
        props.setReputation(reputation);
        props.setVoxels(voxels);
        Voxels.snw.sendTo((IMessage)new VoxelSyncMessage(reputation, voxels), (EntityPlayerMP)entityplayer);
        if (voxels >= 1) {
            entityplayer.func_71064_a((StatBase)VoxelAchievements.voxel1, 1);
        }
        if (voxels >= 10) {
            entityplayer.func_71064_a((StatBase)VoxelAchievements.voxel10, 1);
        }
        if (voxels >= 100) {
            entityplayer.func_71064_a((StatBase)VoxelAchievements.voxel100, 1);
        }
        if (voxels >= 1000) {
            entityplayer.func_71064_a((StatBase)VoxelAchievements.voxel1000, 1);
        }
        if (voxels >= 10000) {
            entityplayer.func_71064_a((StatBase)VoxelAchievements.voxel10000, 1);
        }
        if (voxels >= 100000) {
            entityplayer.func_71064_a((StatBase)VoxelAchievements.voxel1000000, 1);
        }
        icommandsender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + I18n.func_74838_a((String)"message.voxels_voxels.set") + " " + points));
    }

    public static boolean isParsable(String input) {
        boolean parsable = true;
        try {
            Integer.parseInt(input);
        }
        catch (NumberFormatException e) {
            parsable = false;
        }
        return parsable;
    }
}

