/*
 * Decompiled with CFR 0.152.
 */
package com.voxels.entities;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.voxels.VoxelAchievements;
import com.voxels.Voxels;
import com.voxels.capabilities.CapabilityRefs;
import com.voxels.capabilities.ICapabilityPlayer;
import com.voxels.entities.EntityCreeperEliteGuard;
import com.voxels.entities.EntityCreeperGuard;
import com.voxels.entities.EntityCreeperMegaMayor;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.stats.StatBase;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class EntityVoxelsAIEntity<T extends Entity>
extends EntityAIBase {
    private EntityCreature theEntity;
    private double farSpeed;
    private double nearSpeed;
    private Entity closestLivingEntity;
    private float distanceFromEntity;
    private int speechDelay;
    private final Predicate<Entity> canBeSeenSelector = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity p_apply_1_) {
            return p_apply_1_.func_70089_S() && EntityVoxelsAIEntity.this.theEntity.func_70635_at().func_75522_a(p_apply_1_);
        }
    };
    private final float avoidDistance;
    private Path entityPathEntity;
    private final PathNavigate entityPathNavigate;
    private final Class<T> classToAvoid;
    private final Predicate<? super T> avoidTargetSelector;

    public EntityVoxelsAIEntity(EntityCreature theEntityIn, Class<T> classToAvoidIn, float avoidDistanceIn, double farSpeedIn, double nearSpeedIn) {
        this(theEntityIn, classToAvoidIn, Predicates.alwaysTrue(), avoidDistanceIn, farSpeedIn, nearSpeedIn);
    }

    public EntityVoxelsAIEntity(EntityCreature theEntityIn, Class<T> classToAvoidIn, Predicate<? super T> avoidTargetSelectorIn, float avoidDistanceIn, double farSpeedIn, double nearSpeedIn) {
        this.theEntity = theEntityIn;
        this.classToAvoid = classToAvoidIn;
        this.avoidTargetSelector = avoidTargetSelectorIn;
        this.avoidDistance = avoidDistanceIn;
        this.farSpeed = farSpeedIn;
        this.nearSpeed = nearSpeedIn;
        this.entityPathNavigate = theEntityIn.func_70661_as();
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        EntityPlayer entityplayer;
        if (this.classToAvoid == EntityPlayer.class && (entityplayer = this.theEntity.field_70170_p.func_184137_a(this.theEntity.field_70165_t, this.theEntity.field_70163_u, this.theEntity.field_70161_v, 10.0, false)) != null) {
            this.closestLivingEntity = entityplayer;
            ICapabilityPlayer props = CapabilityRefs.getPlayerCaps(entityplayer);
            int reputation = props.getReputation();
            boolean monocleFlag = false;
            boolean shadesFlag = false;
            if (entityplayer.field_70170_p.field_72995_K) {
                ItemStack[] itemchk = entityplayer.field_71071_by.field_70460_b;
                if (itemchk != null && itemchk[3] != null && itemchk[3].func_77973_b() == Voxels.monocle) {
                    monocleFlag = true;
                } else if (itemchk != null && itemchk[3] != null && itemchk[3].func_77973_b() == Voxels.shadyglasses) {
                    shadesFlag = true;
                }
            }
            boolean targetFlag = false;
            int esize2 = entityplayer.field_70170_p.field_72996_f.size();
            for (int k = 0; k <= esize2 - 1; ++k) {
                EntityCreature ecg;
                Entity entity = (Entity)entityplayer.field_70170_p.field_72996_f.get(k);
                if (entity == null || !(entity instanceof EntityCreeperGuard) && !(entity instanceof EntityCreeperEliteGuard) && !(entity instanceof EntityCreeperMegaMayor)) continue;
                if (entity instanceof EntityCreeperGuard) {
                    ecg = (EntityCreeperGuard)entity;
                    if (ecg.func_70638_az() == null || ecg.func_70638_az() != entityplayer || !((double)ecg.func_70032_d((Entity)entityplayer) < 30.0)) continue;
                    targetFlag = true;
                    continue;
                }
                if (entity instanceof EntityCreeperEliteGuard) {
                    ecg = (EntityCreeperEliteGuard)entity;
                    if (ecg.func_70638_az() == null || ecg.func_70638_az() != entityplayer || !((double)ecg.func_70032_d((Entity)entityplayer) < 30.0)) continue;
                    targetFlag = true;
                    continue;
                }
                if (!(entity instanceof EntityCreeperMegaMayor) || (ecg = (EntityCreeperMegaMayor)entity).func_70638_az() == null || ecg.func_70638_az() != entityplayer || !((double)ecg.func_70032_d((Entity)entityplayer) < 30.0)) continue;
                targetFlag = true;
            }
            Random rand = new Random();
            --this.speechDelay;
            if (this.speechDelay <= 0) {
                TextComponentTranslation bob1;
                this.speechDelay = rand.nextInt(5) + 5;
                if (!(reputation < Voxels.CreeperRepHigh || monocleFlag || targetFlag || shadesFlag)) {
                    if (rand.nextInt(36) < 1) {
                        int message = rand.nextInt(10);
                        bob1 = new TextComponentTranslation(TextFormatting.WHITE + "<" + TextFormatting.DARK_GREEN + this.theEntity.func_95999_t() + TextFormatting.WHITE + "> ", new Object[0]);
                        bob1.func_150257_a((ITextComponent)new TextComponentTranslation("message.voxels_highrep." + message, new Object[0]));
                        entityplayer.func_146105_b((ITextComponent)bob1);
                    }
                } else if (reputation < Voxels.CreeperRepLow && !monocleFlag && !shadesFlag || targetFlag) {
                    Vec3d vec3d;
                    if (rand.nextInt(36) < 1) {
                        int message = rand.nextInt(12);
                        bob1 = new TextComponentTranslation(TextFormatting.WHITE + "<" + TextFormatting.DARK_GREEN + this.theEntity.func_95999_t() + TextFormatting.WHITE + "> ", new Object[0]);
                        bob1.func_150257_a((ITextComponent)new TextComponentTranslation("message.voxels_lowrep." + message, new Object[0]));
                        entityplayer.func_146105_b((ITextComponent)bob1);
                    }
                    if ((vec3d = RandomPositionGenerator.func_75461_b((EntityCreature)this.theEntity, (int)16, (int)7, (Vec3d)new Vec3d(entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v))) != null) {
                        this.entityPathEntity = this.entityPathNavigate.func_75488_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
                        return this.entityPathEntity != null;
                    }
                } else if (!(reputation >= Voxels.CreeperRepHigh || reputation <= Voxels.CreeperRepLow || monocleFlag || shadesFlag || targetFlag)) {
                    if (rand.nextInt(36) < 1) {
                        int message = rand.nextInt(12);
                        bob1 = new TextComponentTranslation(TextFormatting.WHITE + "<" + TextFormatting.DARK_GREEN + this.theEntity.func_95999_t() + TextFormatting.WHITE + "> ", new Object[0]);
                        bob1.func_150257_a((ITextComponent)new TextComponentTranslation("message.voxels_medrep." + message, new Object[0]));
                        entityplayer.func_146105_b((ITextComponent)bob1);
                    }
                } else if (monocleFlag && !targetFlag) {
                    if (rand.nextInt(36) < 1) {
                        int message = rand.nextInt(11);
                        entityplayer.func_71064_a((StatBase)VoxelAchievements.wearMonocle, 1);
                        bob1 = new TextComponentTranslation(TextFormatting.WHITE + "<" + TextFormatting.DARK_GREEN + this.theEntity.func_95999_t() + TextFormatting.WHITE + "> ", new Object[0]);
                        bob1.func_150257_a((ITextComponent)new TextComponentTranslation("message.voxels_monocle." + message, new Object[0]));
                        entityplayer.func_146105_b((ITextComponent)bob1);
                    }
                } else if (shadesFlag && !targetFlag) {
                    if (rand.nextInt(36) < 1) {
                        int message = rand.nextInt(11);
                        bob1 = new TextComponentTranslation(TextFormatting.WHITE + "<" + TextFormatting.DARK_GREEN + this.theEntity.func_95999_t() + TextFormatting.WHITE + "> ", new Object[0]);
                        bob1.func_150257_a((ITextComponent)new TextComponentTranslation("message.voxels_shades." + message, new Object[0]));
                        entityplayer.func_146105_b((ITextComponent)bob1);
                    }
                } else {
                    return false;
                }
            }
        }
        return false;
    }

    public boolean func_75253_b() {
        return !this.entityPathNavigate.func_75500_f();
    }

    public void func_75249_e() {
        this.entityPathNavigate.func_75484_a(this.entityPathEntity, this.farSpeed);
    }

    public void func_75251_c() {
        this.closestLivingEntity = null;
    }

    public void func_75246_d() {
        if (this.theEntity.func_70068_e(this.closestLivingEntity) < 49.0) {
            this.theEntity.func_70661_as().func_75489_a(this.nearSpeed);
        } else {
            this.theEntity.func_70661_as().func_75489_a(this.farSpeed);
        }
    }
}

