/*
 * Decompiled with CFR 0.152.
 */
package com.voxels.entities;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.voxels.ModSoundEvents;
import com.voxels.Voxels;
import com.voxels.capabilities.CapabilityRefs;
import com.voxels.capabilities.ICapabilityPlayer;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class EntityShadyAICallEntity<T extends Entity>
extends EntityAIBase {
    private EntityCreature theEntity;
    private double farSpeed;
    private double nearSpeed;
    private Entity closestLivingEntity;
    private float distanceFromEntity;
    private int speechDelay;
    private final Predicate<Entity> canBeSeenSelector = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity p_apply_1_) {
            return p_apply_1_.func_70089_S() && EntityShadyAICallEntity.this.theEntity.func_70635_at().func_75522_a(p_apply_1_);
        }
    };
    private final float avoidDistance;
    private Path entityPathEntity;
    private final PathNavigate entityPathNavigate;
    private final Class<T> classToAvoid;
    private final Predicate<? super T> avoidTargetSelector;

    public EntityShadyAICallEntity(EntityCreature theEntityIn, Class<T> classToAvoidIn, float avoidDistanceIn, double farSpeedIn, double nearSpeedIn) {
        this(theEntityIn, classToAvoidIn, Predicates.alwaysTrue(), avoidDistanceIn, farSpeedIn, nearSpeedIn);
    }

    public EntityShadyAICallEntity(EntityCreature theEntityIn, Class<T> classToAvoidIn, Predicate<? super T> avoidTargetSelectorIn, float avoidDistanceIn, double farSpeedIn, double nearSpeedIn) {
        this.theEntity = theEntityIn;
        this.classToAvoid = classToAvoidIn;
        this.avoidTargetSelector = avoidTargetSelectorIn;
        this.avoidDistance = avoidDistanceIn;
        this.farSpeed = farSpeedIn;
        this.nearSpeed = nearSpeedIn;
        this.entityPathNavigate = theEntityIn.func_70661_as();
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        EntityPlayer entityplayer;
        if (this.classToAvoid == EntityPlayer.class && (entityplayer = this.theEntity.field_70170_p.func_184137_a(this.theEntity.field_70165_t, this.theEntity.field_70163_u, this.theEntity.field_70161_v, 10.0, false)) != null) {
            this.closestLivingEntity = entityplayer;
            ICapabilityPlayer props = CapabilityRefs.getPlayerCaps(entityplayer);
            int reputation = props.getReputation();
            boolean monocleFlag = false;
            ItemStack[] itemchk = entityplayer.field_71071_by.field_70460_b;
            if (itemchk != null && itemchk[3] != null && itemchk[3].func_77973_b() == Voxels.monocle) {
                monocleFlag = true;
            }
            if (!monocleFlag) {
                Random rand = new Random();
                --this.speechDelay;
                if (this.speechDelay <= 0) {
                    this.speechDelay = rand.nextInt(40) + 40;
                    int message = rand.nextInt(8);
                    if (message == 7) {
                        TextComponentTranslation bob1 = new TextComponentTranslation(TextFormatting.WHITE + "<" + TextFormatting.DARK_GREEN + this.theEntity.func_95999_t() + TextFormatting.WHITE + "> ", new Object[0]);
                        bob1.func_150257_a((ITextComponent)new TextComponentTranslation("message.voxels_shady.7", new Object[0]));
                        bob1.func_150258_a(entityplayer.getDisplayNameString());
                        bob1.func_150257_a((ITextComponent)new TextComponentTranslation("message.voxels_shady.7b", new Object[0]));
                        entityplayer.func_146105_b((ITextComponent)bob1);
                        entityplayer.field_70170_p.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, ModSoundEvents.shady_heyyou, SoundCategory.PLAYERS, 0.6f, 1.0f);
                    } else {
                        TextComponentTranslation bob1 = new TextComponentTranslation(TextFormatting.WHITE + "<" + TextFormatting.DARK_GREEN + this.theEntity.func_95999_t() + TextFormatting.WHITE + "> ", new Object[0]);
                        bob1.func_150257_a((ITextComponent)new TextComponentTranslation("message.voxels_shady." + message, new Object[0]));
                        entityplayer.func_146105_b((ITextComponent)bob1);
                        if (message == 0) {
                            entityplayer.field_70170_p.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, ModSoundEvents.shady_pssst, SoundCategory.PLAYERS, 0.6f, 1.0f);
                        } else if (message == 1) {
                            entityplayer.field_70170_p.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, ModSoundEvents.shady_heyyou, SoundCategory.PLAYERS, 0.6f, 1.0f);
                        } else if (message == 2) {
                            entityplayer.field_70170_p.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, ModSoundEvents.shady_check, SoundCategory.PLAYERS, 0.6f, 1.0f);
                        } else if (message == 3) {
                            entityplayer.field_70170_p.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, ModSoundEvents.shady_buddy, SoundCategory.PLAYERS, 0.6f, 1.0f);
                        } else if (message == 4) {
                            entityplayer.field_70170_p.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, ModSoundEvents.shady_needrep, SoundCategory.PLAYERS, 0.6f, 1.0f);
                        } else if (message == 5) {
                            entityplayer.field_70170_p.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, ModSoundEvents.shady_overhere, SoundCategory.PLAYERS, 0.6f, 1.0f);
                        } else if (message == 6) {
                            entityplayer.field_70170_p.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, ModSoundEvents.shady_lookie, SoundCategory.PLAYERS, 0.6f, 1.0f);
                        }
                    }
                }
            } else {
                this.closestLivingEntity = entityplayer;
                Vec3d vec3d = RandomPositionGenerator.func_75461_b((EntityCreature)this.theEntity, (int)16, (int)7, (Vec3d)new Vec3d(entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v));
                if (vec3d != null) {
                    this.entityPathEntity = this.entityPathNavigate.func_75488_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
                    return this.entityPathEntity != null;
                }
            }
        }
        return false;
    }

    public boolean func_75253_b() {
        return !this.entityPathNavigate.func_75500_f();
    }

    public void func_75249_e() {
        this.entityPathNavigate.func_75484_a(this.entityPathEntity, this.farSpeed);
    }

    public void func_75251_c() {
        this.closestLivingEntity = null;
    }

    public void func_75246_d() {
        if (this.theEntity.func_70068_e(this.closestLivingEntity) < 49.0) {
            this.theEntity.func_70661_as().func_75489_a(this.nearSpeed);
        } else {
            this.theEntity.func_70661_as().func_75489_a(this.farSpeed);
        }
    }
}

