/*
 * Decompiled with CFR 0.152.
 */
package com.voxels.entities;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.voxels.Voxels;
import com.voxels.capabilities.CapabilityRefs;
import com.voxels.capabilities.ICapabilityPlayer;
import com.voxels.entities.EntityCreeperEliteGuard;
import com.voxels.entities.EntityCreeperGuard;
import com.voxels.entities.EntityCreeperMegaMayor;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class EntityMayorAISpeechEntity<T extends Entity>
extends EntityAIBase {
    private EntityCreature theEntity;
    private double farSpeed;
    private double nearSpeed;
    private Entity closestLivingEntity;
    private float distanceFromEntity;
    private int speechDelay;
    private final Predicate<Entity> canBeSeenSelector = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity p_apply_1_) {
            return p_apply_1_.func_70089_S() && EntityMayorAISpeechEntity.this.theEntity.func_70635_at().func_75522_a(p_apply_1_);
        }
    };
    private final float avoidDistance;
    private Path entityPathEntity;
    private final PathNavigate entityPathNavigate;
    private final Class<T> classToAvoid;
    private final Predicate<? super T> avoidTargetSelector;

    public EntityMayorAISpeechEntity(EntityCreature theEntityIn, Class<T> classToAvoidIn, float avoidDistanceIn, double farSpeedIn, double nearSpeedIn) {
        this(theEntityIn, classToAvoidIn, Predicates.alwaysTrue(), avoidDistanceIn, farSpeedIn, nearSpeedIn);
    }

    public EntityMayorAISpeechEntity(EntityCreature theEntityIn, Class<T> classToAvoidIn, Predicate<? super T> avoidTargetSelectorIn, float avoidDistanceIn, double farSpeedIn, double nearSpeedIn) {
        this.theEntity = theEntityIn;
        this.classToAvoid = classToAvoidIn;
        this.avoidTargetSelector = avoidTargetSelectorIn;
        this.avoidDistance = avoidDistanceIn;
        this.farSpeed = farSpeedIn;
        this.nearSpeed = nearSpeedIn;
        this.entityPathNavigate = theEntityIn.func_70661_as();
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        EntityPlayer entityplayer;
        if (this.classToAvoid == EntityPlayer.class && (entityplayer = this.theEntity.field_70170_p.func_184137_a(this.theEntity.field_70165_t, this.theEntity.field_70163_u, this.theEntity.field_70161_v, 10.0, false)) != null) {
            ICapabilityPlayer props = CapabilityRefs.getPlayerCaps(entityplayer);
            int reputation = props.getReputation();
            boolean monocleFlag = false;
            ItemStack[] itemchk = entityplayer.field_71071_by.field_70460_b;
            if (itemchk != null && itemchk[3] != null && itemchk[3].func_77973_b() == Voxels.monocle) {
                monocleFlag = true;
            }
            boolean targetFlag = false;
            int esize2 = entityplayer.field_70170_p.field_72996_f.size();
            for (int k = 0; k <= esize2 - 1; ++k) {
                EntityCreature ecg;
                Entity entity = (Entity)entityplayer.field_70170_p.field_72996_f.get(k);
                if (entity == null || !(entity instanceof EntityCreeperGuard) && !(entity instanceof EntityCreeperEliteGuard) && !(entity instanceof EntityCreeperMegaMayor)) continue;
                if (entity instanceof EntityCreeperGuard) {
                    ecg = (EntityCreeperGuard)entity;
                    if (ecg.func_70638_az() == null || ecg.func_70638_az() != entityplayer || !((double)ecg.func_70032_d((Entity)entityplayer) < 30.0)) continue;
                    targetFlag = true;
                    continue;
                }
                if (entity instanceof EntityCreeperEliteGuard) {
                    ecg = (EntityCreeperEliteGuard)entity;
                    if (ecg.func_70638_az() == null || ecg.func_70638_az() != entityplayer || !((double)ecg.func_70032_d((Entity)entityplayer) < 30.0)) continue;
                    targetFlag = true;
                    continue;
                }
                if (!(entity instanceof EntityCreeperMegaMayor) || (ecg = (EntityCreeperMegaMayor)entity).func_70638_az() == null || ecg.func_70638_az() != entityplayer || !((double)ecg.func_70032_d((Entity)entityplayer) < 30.0)) continue;
                targetFlag = true;
            }
            Random rand = new Random();
            --this.speechDelay;
            if (this.speechDelay <= 0) {
                TextComponentTranslation bob1;
                this.speechDelay = rand.nextInt(60) + 60;
                if (reputation > Voxels.CreeperRepLow && !targetFlag && !Voxels.proxy.isMayorGuiOpen()) {
                    int message = rand.nextInt(8);
                    bob1 = new TextComponentTranslation(TextFormatting.WHITE + "<" + TextFormatting.DARK_GREEN + this.theEntity.func_95999_t() + TextFormatting.WHITE + "> ", new Object[0]);
                    String nmchk = this.theEntity.func_95999_t();
                    if (nmchk.contains("Leafcutter") || nmchk.contains("Bombastic") || nmchk.contains("Gunpowderson") || nmchk.contains("Hissenberg") || nmchk.contains("Stevekiller") || nmchk.contains("Smithereens")) {
                        bob1.func_150257_a((ITextComponent)new TextComponentTranslation("speech.voxels_mayor1." + message, new Object[0]));
                    } else if (nmchk.contains("Crepe Suzette") || nmchk.contains("Creeperson") || nmchk.contains("Ballotstuffer") || nmchk.contains("Mayo") || nmchk.contains("Mickerson")) {
                        bob1.func_150257_a((ITextComponent)new TextComponentTranslation("speech.voxels_mayor2." + message, new Object[0]));
                    } else {
                        bob1.func_150257_a((ITextComponent)new TextComponentTranslation("speech.voxels_mayor3." + message, new Object[0]));
                    }
                    entityplayer.func_146105_b((ITextComponent)bob1);
                } else if (reputation < Voxels.CreeperRepLow && !monocleFlag || targetFlag) {
                    int message = rand.nextInt(12);
                    bob1 = new TextComponentTranslation(TextFormatting.WHITE + "<" + TextFormatting.DARK_GREEN + this.theEntity.func_95999_t() + TextFormatting.WHITE + "> ", new Object[0]);
                    bob1.func_150257_a((ITextComponent)new TextComponentTranslation("message.voxels_mayorscared." + message, new Object[0]));
                    entityplayer.func_146105_b((ITextComponent)bob1);
                }
            }
        }
        return false;
    }

    public boolean func_75253_b() {
        return !this.entityPathNavigate.func_75500_f();
    }

    public void func_75249_e() {
        this.entityPathNavigate.func_75484_a(this.entityPathEntity, this.farSpeed);
    }

    public void func_75251_c() {
        this.closestLivingEntity = null;
    }

    public void func_75246_d() {
        if (this.theEntity.func_70068_e(this.closestLivingEntity) < 49.0) {
            this.theEntity.func_70661_as().func_75489_a(this.nearSpeed);
        } else {
            this.theEntity.func_70661_as().func_75489_a(this.farSpeed);
        }
    }
}

