/*
 * Decompiled with CFR 0.152.
 */
package com.voxels.entities;

import com.voxels.Voxels;
import com.voxels.capabilities.CapabilityRefs;
import com.voxels.capabilities.ICapabilityPlayer;
import com.voxels.entities.EntityCreeperEliteGuard;
import com.voxels.entities.EntityCreeperGuard;
import com.voxels.entities.EntityCreeperMegaMayor;
import com.voxels.entities.EntityScientistTradePlayer;
import com.voxels.entities.EntityVoxelsAIEntity;
import com.voxels.io.ScientistTraderReader;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.AnimalChest;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCreeperScientist
extends EntityCreature
implements IInventoryChangedListener {
    private static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(EntityCreeperScientist.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> POWERED = EntityDataManager.func_187226_a(EntityCreeperScientist.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IGNITED = EntityDataManager.func_187226_a(EntityCreeperScientist.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> VOXELS = EntityDataManager.func_187226_a(EntityCreeperScientist.class, (DataSerializer)DataSerializers.field_187192_b);
    private int chkDelay = 100;
    private int interest = -10;
    private int lastActiveTime;
    private int timeSinceIgnited;
    private int fuseTime = 30;
    private int explosionRadius = 3;
    private String[] creepNames = new String[]{"Eggbert", "Beaker", "Butterfingers", "Forgetsaton", "Mixalot", "Nanopatience", "Explodenstein", "Failmode", "Stargazer", "Wingnut", "Slipknot", "Bunkerbean", "Calculus", "Pocketprotector"};
    private EntityPlayer buyingPlayer;
    private int timeUntilReset;
    private boolean needsInitilization;
    private int wealth;
    private String lastBuyingPlayer;
    private float field_82191_bN;
    public AnimalChest creeperChest;
    private String field_110286_bQ;

    public EntityCreeperScientist(World p_i1733_1_) {
        super(p_i1733_1_);
        Random rand = new Random();
        int nameChk = rand.nextInt(14);
        String randName = this.creepNames[nameChk];
        this.func_96094_a("Head Scientist " + randName);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityScientistTradePlayer(this));
        this.field_70714_bg.func_75776_a(3, new EntityVoxelsAIEntity<EntityPlayer>(this, EntityPlayer.class, 6.0f, 1.0, 1.3));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.wealth = this.getRiches();
        this.initCreeperChest();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.34);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean isAIEnabled() {
        return true;
    }

    public int getMaxSafePointTries() {
        return this.func_70638_az() == null ? 3 : 3 + (int)(this.func_110143_aJ() - 1.0f);
    }

    public int func_82143_as() {
        return this.func_70638_az() == null ? 3 : 3 + (int)(this.func_110143_aJ() - 1.0f);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance, damageMultiplier);
        this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + distance * 1.5f);
        if (this.timeSinceIgnited > this.fuseTime - 5) {
            this.timeSinceIgnited = this.fuseTime - 5;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATE, (Object)-1);
        this.field_70180_af.func_187214_a(POWERED, (Object)false);
        this.field_70180_af.func_187214_a(IGNITED, (Object)false);
        this.field_70180_af.func_187214_a(VOXELS, (Object)2000);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (((Boolean)this.field_70180_af.func_187225_a(POWERED)).booleanValue()) {
            compound.func_74757_a("powered", true);
        }
        compound.func_74768_a("Riches", this.getRiches());
        compound.func_74777_a("Fuse", (short)this.fuseTime);
        compound.func_74774_a("ExplosionRadius", (byte)this.explosionRadius);
        compound.func_74757_a("ignited", this.hasIgnited());
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.creeperChest.func_70302_i_(); ++i) {
            ItemStack itemstack = this.creeperChest.func_70301_a(i);
            if (itemstack == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            itemstack.func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(POWERED, (Object)compound.func_74767_n("powered"));
        if (compound.func_150297_b("Fuse", 99)) {
            this.fuseTime = compound.func_74765_d("Fuse");
        }
        if (compound.func_150297_b("ExplosionRadius", 99)) {
            this.explosionRadius = compound.func_74771_c("ExplosionRadius");
        }
        if (compound.func_74767_n("ignited")) {
            this.ignite();
        }
        this.setRiches(compound.func_74762_e("Riches"));
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        this.initCreeperChest();
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.creeperChest.func_70302_i_()) continue;
            this.creeperChest.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1));
        }
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            int i;
            ++this.chkDelay;
            int intRate = Voxels.CreeperReplenishVoxelsRate;
            if (this.interest == -10) {
                this.interest = intRate == 1 ? 50 : (intRate == 2 ? 300 : (intRate == 4 ? 1200 : 800));
            }
            --this.interest;
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.hasIgnited()) {
                this.setCreeperState(1);
            }
            if ((i = this.getCreeperState()) > 0 && this.timeSinceIgnited == 0) {
                this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 0.5f);
            }
            if (this.interest < 0) {
                this.interest = intRate == 1 ? 50 : (intRate == 2 ? 300 : (intRate == 4 ? 1200 : 800));
                int riches = this.getRiches();
                this.setRiches(++riches);
            }
        }
        super.func_70071_h_();
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187570_aq;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187568_ap;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
    }

    public boolean func_70652_k(Entity entity) {
        return true;
    }

    public boolean getPowered() {
        return (Boolean)this.field_70180_af.func_187225_a(POWERED);
    }

    public int getRiches() {
        return (Integer)this.field_70180_af.func_187225_a(VOXELS);
    }

    public String func_70005_c_() {
        return this.func_95999_t();
    }

    public void setRiches(int riches) {
        this.wealth = riches;
        this.field_70180_af.func_187227_b(VOXELS, (Object)this.wealth);
    }

    @SideOnly(value=Side.CLIENT)
    public float getCreeperFlashIntensity(float p_70831_1_) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * p_70831_1_) / 1.0f;
    }

    protected Item func_146068_u() {
        return Items.field_151016_H;
    }

    protected void func_70628_a(boolean par1, int par2) {
        int h = this.field_70146_Z.nextInt(30);
        if (h >= 2 && h <= 20) {
            this.func_145779_a(Items.field_151016_H, 1);
            this.func_145779_a(Voxels.voxel, 1);
        } else if (h == 1) {
            this.func_145779_a(Items.field_151016_H, 1);
            int h2 = this.field_70146_Z.nextInt(10) + 1;
            this.func_145779_a(Voxels.voxel, h2);
        }
    }

    public int getCreeperState() {
        return (Integer)this.field_70180_af.func_187225_a(STATE);
    }

    public void setCreeperState(int state) {
        this.field_70180_af.func_187227_b(STATE, (Object)state);
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        super.func_70077_a(lightningBolt);
        this.field_70180_af.func_187227_b(POWERED, (Object)true);
    }

    protected boolean func_184645_a(EntityPlayer entityplayer, EnumHand hand, @Nullable ItemStack stack) {
        ICapabilityPlayer props = CapabilityRefs.getPlayerCaps(entityplayer);
        int reputation = props.getReputation();
        boolean monocleFlag = false;
        ItemStack[] itemchk = entityplayer.field_71071_by.field_70460_b;
        if (itemchk != null && itemchk[3] != null && itemchk[3].func_77973_b() == Voxels.monocle) {
            monocleFlag = true;
        }
        boolean targetFlag = false;
        int esize = entityplayer.field_70170_p.field_72996_f.size();
        for (int k = 0; k <= esize - 1; ++k) {
            EntityCreature ecg;
            Entity entity = (Entity)entityplayer.field_70170_p.field_72996_f.get(k);
            if (entity == null || !(entity instanceof EntityCreeperGuard) && !(entity instanceof EntityCreeperEliteGuard) && !(entity instanceof EntityCreeperMegaMayor)) continue;
            if (entity instanceof EntityCreeperGuard) {
                ecg = (EntityCreeperGuard)entity;
                if (ecg.func_70638_az() == null || ecg.func_70638_az() != entityplayer || !((double)ecg.func_70032_d((Entity)entityplayer) < 30.0)) continue;
                targetFlag = true;
                continue;
            }
            if (entity instanceof EntityCreeperEliteGuard) {
                ecg = (EntityCreeperEliteGuard)entity;
                if (ecg.func_70638_az() == null || ecg.func_70638_az() != entityplayer || !((double)ecg.func_70032_d((Entity)entityplayer) < 30.0)) continue;
                targetFlag = true;
                continue;
            }
            if (!(entity instanceof EntityCreeperMegaMayor) || (ecg = (EntityCreeperMegaMayor)entity).func_70638_az() == null || ecg.func_70638_az() != entityplayer || !((double)ecg.func_70032_d((Entity)entityplayer) < 30.0)) continue;
            targetFlag = true;
        }
        if (!(!this.func_70089_S() || this.isTrading() || this.func_70631_g_() || entityplayer.func_70093_af() || reputation <= Voxels.CreeperRepLow && !monocleFlag || this.func_70638_az() == entityplayer || targetFlag)) {
            if (!this.field_70170_p.field_72995_K) {
                this.setCustomer(entityplayer);
                this.creeperChest.func_110133_a(this.func_70005_c_());
                entityplayer.openGui((Object)Voxels.instance, Voxels.creeperScientistGUI_ID, entityplayer.field_70170_p, this.func_145782_y(), 0, 0);
            } else {
                this.setCustomer(entityplayer);
            }
            return true;
        }
        return super.func_184645_a(entityplayer, hand, stack);
    }

    public void setCustomer(EntityPlayer entityplayer) {
        this.buyingPlayer = entityplayer;
    }

    public EntityPlayer getCustomer() {
        return this.buyingPlayer;
    }

    public boolean isTrading() {
        return this.buyingPlayer != null;
    }

    private void initCreeperChest() {
        AnimalChest animalchest = this.creeperChest;
        this.creeperChest = new AnimalChest("creeperChest", 36);
        this.creeperChest.func_110133_a(this.func_70005_c_());
        PotionType[] potionList = new PotionType[]{PotionTypes.field_185220_C, PotionTypes.field_185243_o, PotionTypes.field_185241_m, PotionTypes.field_185254_z, PotionTypes.field_185250_v, PotionTypes.field_185223_F, PotionTypes.field_185226_I, PotionTypes.field_185246_r, PotionTypes.field_185238_j, PotionTypes.field_185236_h, PotionTypes.field_185234_f, PotionTypes.field_185248_t, PotionTypes.field_185253_y, PotionTypes.field_185251_w, PotionTypes.field_185240_l, PotionTypes.field_185219_B, PotionTypes.field_185222_E, PotionTypes.field_185225_H, PotionTypes.field_185245_q, PotionTypes.field_185242_n, PotionTypes.field_185237_i, PotionTypes.field_185239_k, PotionTypes.field_185235_g, PotionTypes.field_185218_A, PotionTypes.field_185221_D, PotionTypes.field_185247_s, PotionTypes.field_185224_G, PotionTypes.field_185244_p, PotionTypes.field_185248_t, PotionTypes.field_185243_o, PotionTypes.field_185252_x, PotionTypes.field_185227_J};
        if (animalchest != null) {
            animalchest.func_110132_b((IInventoryChangedListener)this);
            int i = Math.min(animalchest.func_70302_i_(), this.creeperChest.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = animalchest.func_70301_a(j);
                if (itemstack == null) continue;
                this.creeperChest.func_70299_a(j, itemstack.func_77946_l());
            }
            animalchest = null;
        } else {
            Item good = null;
            int goodsize = 0;
            Random rand = new Random();
            for (int b = 0; b < 27; ++b) {
                if (this.creeperChest.func_70301_a(b) != null) continue;
                ItemStack good2 = new ItemStack(Items.field_151170_bI);
                if (Voxels.EnableCustomScientistTrades) {
                    if (b == 0) {
                        good2 = this.getItem("0").func_77946_l();
                    } else if (b == 1) {
                        good2 = this.getItem("1").func_77946_l();
                    } else if (b == 2) {
                        good2 = this.getItem("2").func_77946_l();
                    } else if (b == 3) {
                        good2 = this.getItem("3").func_77946_l();
                    } else if (b == 4) {
                        good2 = this.getItem("4").func_77946_l();
                    } else if (b == 5) {
                        good2 = this.getItem("5").func_77946_l();
                    } else if (b == 6) {
                        good2 = this.getItem("6").func_77946_l();
                    } else if (b == 7) {
                        good2 = this.getItem("7").func_77946_l();
                    } else if (b == 8) {
                        good2 = this.getItem("8").func_77946_l();
                    } else if (b == 9) {
                        good2 = this.getItem("9").func_77946_l();
                    } else if (b == 10) {
                        good2 = this.getItem("10").func_77946_l();
                    } else if (b == 11) {
                        good2 = this.getItem("11").func_77946_l();
                    } else if (b == 12) {
                        good2 = this.getItem("12").func_77946_l();
                    } else if (b == 13) {
                        good2 = this.getItem("13").func_77946_l();
                    } else if (b == 14) {
                        good2 = this.getItem("14").func_77946_l();
                    } else if (b == 15) {
                        good2 = this.getItem("15").func_77946_l();
                    } else if (b == 16) {
                        good2 = this.getItem("16").func_77946_l();
                    } else if (b == 17) {
                        good2 = this.getItem("17").func_77946_l();
                    } else if (b == 18) {
                        good2 = this.getItem("18").func_77946_l();
                    } else if (b == 19) {
                        good2 = this.getItem("19").func_77946_l();
                    } else if (b == 20) {
                        good2 = this.getItem("20").func_77946_l();
                    } else if (b == 21) {
                        good2 = this.getItem("21").func_77946_l();
                    } else if (b == 22) {
                        good2 = this.getItem("22").func_77946_l();
                    } else if (b == 23) {
                        good2 = this.getItem("23").func_77946_l();
                    } else if (b == 24) {
                        good2 = this.getItem("24").func_77946_l();
                    } else if (b == 25) {
                        good2 = this.getItem("25").func_77946_l();
                    } else if (b == 26) {
                        good2 = this.getItem("26").func_77946_l();
                    }
                } else {
                    good2 = b == 0 ? (rand.nextInt(2) == 0 ? PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potionList[0]) : PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potionList[1])) : (b == 1 ? (rand.nextInt(2) == 0 ? PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potionList[2]) : PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potionList[3])) : (b == 2 ? (rand.nextInt(2) == 0 ? PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potionList[4]) : PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potionList[5])) : (b == 3 ? (rand.nextInt(2) == 0 ? PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potionList[6]) : PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potionList[7])) : (b == 4 ? (rand.nextInt(2) == 0 ? PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potionList[8]) : PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potionList[9])) : (b == 5 ? (rand.nextInt(2) == 0 ? PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potionList[10]) : PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potionList[11])) : (b == 6 ? PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potionList[12]) : (b == 7 ? PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potionList[13]) : (b == 8 ? PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potionList[14]) : (b == 9 ? PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potionList[15]) : (b == 10 ? PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potionList[16]) : (b == 11 ? PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potionList[17]) : (b == 12 ? PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potionList[18]) : (b == 13 ? PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potionList[19]) : (b == 14 ? PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potionList[20]) : (b == 15 ? PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potionList[21]) : (b == 16 ? PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potionList[22]) : (b == 17 ? PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potionList[23]) : (b == 18 ? PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potionList[24]) : (b == 19 ? PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potionList[25]) : (b == 20 ? PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potionList[26]) : (b == 21 ? PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potionList[27]) : (b == 22 ? PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potionList[28]) : (b == 23 ? PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potionList[29]) : (b == 24 ? PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potionList[30]) : (b == 25 ? PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potionList[31]) : (b == 26 ? new ItemStack(Items.field_151073_bk) : new ItemStack(good, goodsize)))))))))))))))))))))))))));
                }
                this.creeperChest.func_70299_a(b, good2);
            }
        }
        this.creeperChest.func_110134_a((IInventoryChangedListener)this);
    }

    public boolean hasIgnited() {
        return (Boolean)this.field_70180_af.func_187225_a(IGNITED);
    }

    public void ignite() {
        this.field_70180_af.func_187227_b(IGNITED, (Object)true);
    }

    public void func_76316_a(InventoryBasic invBasic) {
    }

    public ItemStack getItem(String slotkey) {
        Item bob;
        ItemStack foundStack = null;
        String moditem = "";
        String item = "";
        String mod = "";
        int sepLoc = 0;
        int metaLoc = 0;
        boolean metaFlag = false;
        String metaVal = "";
        moditem = ScientistTraderReader.main(slotkey);
        sepLoc = moditem.indexOf(":");
        metaLoc = moditem.indexOf("#");
        if (!moditem.contains(":")) {
            foundStack = new ItemStack(Items.field_151170_bI, 1);
            return foundStack;
        }
        mod = moditem.substring(0, sepLoc);
        item = metaLoc > 0 ? moditem.substring(sepLoc + 1, metaLoc) : moditem.substring(sepLoc + 1, moditem.length());
        if (metaLoc > 0) {
            metaFlag = true;
            metaVal = moditem.substring(metaLoc + 1, moditem.length());
        }
        foundStack = (bob = GameRegistry.findItem((String)mod, (String)item)) != null ? (metaFlag ? new ItemStack(bob, 1, Integer.parseInt(metaVal)) : new ItemStack(bob, 1)) : new ItemStack(Items.field_151170_bI, 1);
        return foundStack;
    }

    public static String getModId(Item item) {
        if (item != null) {
            String id = item.getRegistryName().func_110624_b();
            return id == null || id.equals("") ? "minecraft" : id;
        }
        return null;
    }

    public static String getModId(ItemStack key) {
        return EntityCreeperScientist.getModId(key.func_77973_b());
    }
}

