/*
 * Decompiled with CFR 0.152.
 */
package com.voxels.entities;

import com.voxels.Voxels;
import com.voxels.entities.EntityMegaMayorAICallEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCreeperMegaMayor
extends EntityCreature {
    private int lastActiveTime;
    private int timeSinceIgnited;
    private int fuseTime = 30;
    private int explosionRadius = 3;
    private int timeUntilReset;
    private boolean needsInitilization;
    private int healTime = 20;
    private float aliveTime;
    private int grown;
    private static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(EntityCreeperMegaMayor.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> POWERED = EntityDataManager.func_187226_a(EntityCreeperMegaMayor.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IGNITED = EntityDataManager.func_187226_a(EntityCreeperMegaMayor.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> GROWN = EntityDataManager.func_187226_a(EntityCreeperMegaMayor.class, (DataSerializer)DataSerializers.field_187192_b);
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.GREEN, BossInfo.Overlay.PROGRESS).func_186741_a(true);

    public EntityCreeperMegaMayor(World p_i1733_1_) {
        super(p_i1733_1_);
        this.func_96094_a("Mega Mayor");
        this.field_70714_bg.func_75776_a(1, new EntityMegaMayorAICallEntity<EntityPlayer>(this, EntityPlayer.class, 40.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 100.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.func_70105_a(6.0f, 20.0f);
        this.field_70771_an = 10;
        this.field_70138_W = 3.0f;
        this.grown = this.getGrown();
    }

    protected void func_110147_ax() {
        double diff = 1000.0;
        if (Voxels.MegaMayorDifficulty == 1) {
            diff = 250.0;
        } else if (Voxels.MegaMayorDifficulty == 3) {
            diff = 2500.0;
        } else if (Voxels.MegaMayorDifficulty == 4) {
            diff = 5000.0;
        }
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(diff);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean isAIEnabled() {
        return true;
    }

    public int func_82143_as() {
        return this.func_70638_az() == null ? 3 : 3 + (int)(this.func_110143_aJ() - 1.0f);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance, damageMultiplier);
        this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + distance * 1.5f);
        if (this.timeSinceIgnited > this.fuseTime - 5) {
            this.timeSinceIgnited = this.fuseTime - 5;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATE, (Object)-1);
        this.field_70180_af.func_187214_a(POWERED, (Object)false);
        this.field_70180_af.func_187214_a(IGNITED, (Object)false);
        this.field_70180_af.func_187214_a(GROWN, (Object)0);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (((Boolean)this.field_70180_af.func_187225_a(POWERED)).booleanValue()) {
            compound.func_74757_a("powered", true);
        }
        compound.func_74777_a("Fuse", (short)this.fuseTime);
        compound.func_74774_a("ExplosionRadius", (byte)this.explosionRadius);
        compound.func_74757_a("ignited", this.hasIgnited());
        compound.func_74776_a("aliveTime", this.aliveTime);
        compound.func_74768_a("Grown", this.getGrown());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(POWERED, (Object)compound.func_74767_n("powered"));
        if (compound.func_150297_b("Fuse", 99)) {
            this.fuseTime = compound.func_74765_d("Fuse");
        }
        if (compound.func_150297_b("ExplosionRadius", 99)) {
            this.explosionRadius = compound.func_74771_c("ExplosionRadius");
        }
        if (compound.func_74767_n("ignited")) {
            this.ignite();
        }
        if (compound.func_74764_b("aliveTime")) {
            this.aliveTime = compound.func_74760_g("aliveTime");
        }
        this.setGrown(compound.func_74762_e("Grown"));
    }

    public void func_70071_h_() {
        --this.healTime;
        if (this.func_110143_aJ() < 1000.0f && this.healTime <= 0 && this.func_110143_aJ() > 0.0f) {
            this.healTime = 20;
            this.func_70606_j(this.func_110143_aJ() + 5.0f);
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        float aliveTime = this.getEntityData().func_74760_g("aliveTime");
        if (aliveTime < 1.2f) {
            this.getEntityData().func_74776_a("aliveTime", aliveTime += 0.01f);
        } else {
            this.setGrown(1);
        }
        EntityPlayer entityplayer = this.field_70170_p.func_184137_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, false);
        if (entityplayer != null) {
            this.func_70624_b((EntityLivingBase)entityplayer);
            this.func_130011_c((Entity)entityplayer);
        }
        super.func_70071_h_();
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187570_aq;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187568_ap;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
    }

    public boolean func_70652_k(Entity entity) {
        return true;
    }

    public boolean getPowered() {
        return (Boolean)this.field_70180_af.func_187225_a(POWERED);
    }

    @SideOnly(value=Side.CLIENT)
    public float getCreeperFlashIntensity(float p_70831_1_) {
        return 1.0f;
    }

    protected Item func_146068_u() {
        return Items.field_151016_H;
    }

    protected void func_70628_a(boolean par1, int par2) {
        this.func_145779_a(Items.field_151016_H, 1);
        this.func_145779_a(Voxels.voxel, 150 + this.field_70146_Z.nextInt(125));
        this.func_145779_a(Voxels.voxel, 150 + this.field_70146_Z.nextInt(125));
        this.func_145779_a(Voxels.voxel, 150 + this.field_70146_Z.nextInt(125));
        this.func_145779_a(Voxels.voxel, 150 + this.field_70146_Z.nextInt(125));
        this.func_145779_a(Voxels.monocle, 1);
        this.func_145779_a(Voxels.specialchestplate3, 1);
        this.func_145779_a(Voxels.specialboots3, 1);
        this.func_145779_a(Voxels.specialleggings3, 1);
    }

    public int getCreeperState() {
        return (Integer)this.field_70180_af.func_187225_a(STATE);
    }

    public void setCreeperState(int state) {
        this.field_70180_af.func_187227_b(STATE, (Object)state);
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        super.func_70077_a(lightningBolt);
        this.field_70180_af.func_187227_b(POWERED, (Object)true);
    }

    public boolean hasIgnited() {
        return (Boolean)this.field_70180_af.func_187225_a(IGNITED);
    }

    public void ignite() {
        this.field_70180_af.func_187227_b(IGNITED, (Object)true);
    }

    public int getGrown() {
        return (Integer)this.field_70180_af.func_187225_a(GROWN);
    }

    public void setGrown(int grown) {
        this.field_70180_af.func_187227_b(GROWN, (Object)this.grown);
    }
}

