/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.iconprovider;

import net.malisis.core.renderer.icon.ClippedIcon;
import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.renderer.icon.provider.IIconProvider;
import net.malisis.doors.DoorDescriptor;
import net.malisis.doors.descriptor.VanillaDoor;
import net.minecraft.util.EnumFacing;

public class DoorIconProvider
implements IIconProvider {
    protected Icon itemIcon;
    protected Icon top;
    protected Icon bottom;
    protected Icon side;
    protected Icon[] iconTop;
    protected Icon[] iconBottom;

    public DoorIconProvider(DoorDescriptor descriptor) {
        String modid = descriptor.getModId();
        String name = descriptor.getTextureName();
        this.itemIcon = Icon.from((String)(modid + ":items/" + name));
        this.top = Icon.from((String)(modid + ":blocks/" + name + "_upper"));
        this.bottom = Icon.from((String)(modid + ":blocks/" + name + "_lower"));
        if (descriptor instanceof VanillaDoor) {
            modid = "malisisdoors";
        }
        this.side = Icon.from((String)(modid + ":blocks/" + name + "_side"));
        this.buildIcons();
    }

    private void buildIcons() {
        float w = 0.1875f;
        this.iconTop = new Icon[6];
        this.iconTop[0] = new ClippedIcon(this.side, 0.0f, 0.0f, w, 1.0f);
        this.iconTop[0].setRotation(1);
        this.iconTop[1] = this.iconTop[0];
        this.iconTop[2] = this.top;
        this.iconTop[3] = this.top;
        this.iconTop[4] = new ClippedIcon(this.side, w, 0.0f, w, 1.0f);
        this.iconTop[5] = new ClippedIcon(this.side, 2.0f * w, 0.0f, w, 1.0f);
        this.iconBottom = new Icon[6];
        this.iconBottom[0] = this.iconTop[0];
        this.iconBottom[1] = this.iconTop[0];
        this.iconBottom[2] = this.bottom;
        this.iconBottom[3] = this.bottom;
        this.iconBottom[4] = new ClippedIcon(this.side, 3.0f * w, 0.0f, w, 1.0f);
        this.iconBottom[5] = new ClippedIcon(this.side, 4.0f * w, 0.0f, w, 1.0f);
    }

    public Icon getIcon() {
        return this.top;
    }

    public Icon getIcon(boolean isTop, boolean isHingeLeft, EnumFacing side) {
        boolean flipH = false;
        boolean flipV = false;
        switch (side) {
            case WEST: {
                side = isHingeLeft ? EnumFacing.WEST : EnumFacing.EAST;
                break;
            }
            case EAST: {
                side = isHingeLeft ? EnumFacing.EAST : EnumFacing.WEST;
                break;
            }
            case UP: 
            case DOWN: {
                flipV = isHingeLeft;
            }
            case NORTH: 
            case SOUTH: {
                flipH = isHingeLeft;
            }
        }
        Icon icon = isTop ? this.iconTop[side.func_176745_a()] : this.iconBottom[side.func_176745_a()];
        icon.flip(flipH, flipV);
        return icon;
    }
}

