/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.descriptor;

import net.malisis.doors.DoorDescriptor;
import net.malisis.doors.DoorRegistry;
import net.malisis.doors.movement.RotatingDoorMovement;
import net.malisis.doors.sound.IronDoorSound;
import net.malisis.doors.sound.WoodenDoorSound;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;

public class VanillaDoor
extends DoorDescriptor {
    public VanillaDoor(Type type) {
        boolean iron = type == Type.IRON;
        this.setOpeningTime(6);
        this.setMaterial(iron ? Material.field_151573_f : Material.field_151575_d);
        this.setHardness(iron ? 5.0f : 3.0f);
        this.setSoundType(iron ? SoundType.field_185852_e : SoundType.field_185848_a);
        this.setName(type.name);
        this.setTextureName("minecraft", type.texture);
        this.setNumCrafted(3);
        this.setRedstoneBehavior(iron ? DoorDescriptor.RedstoneBehavior.REDSTONE_ONLY : DoorDescriptor.RedstoneBehavior.STANDARD);
        this.setMovement(DoorRegistry.getMovement(RotatingDoorMovement.class));
        this.setSound(DoorRegistry.getSound(iron ? IronDoorSound.class : WoodenDoorSound.class));
        this.setTab(CreativeTabs.field_78028_d);
    }

    public static enum Type {
        OAK("doorOak", "door_wood"),
        SPRUCE("doorSpruce", "door_spruce"),
        BIRCH("doorBirch", "door_birch"),
        JUNGLE("doorJungle", "door_jungle"),
        ACACIA("doorAcacia", "door_acacia"),
        DARK_OAK("doorDarkOak", "door_dark_oak"),
        IRON("doorIron", "door_iron");

        private String name;
        private String texture;

        private Type(String name, String texture) {
            this.name = name;
            this.texture = texture;
        }
    }
}

