/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.block;

import javax.vecmath.Matrix4f;
import net.malisis.core.MalisisCore;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.MalisisBlock;
import net.malisis.core.block.component.DirectionalComponent;
import net.malisis.core.block.component.ItemTransformComponent;
import net.malisis.core.block.component.PowerComponent;
import net.malisis.core.renderer.component.AnimatedModelComponent;
import net.malisis.core.util.AABBUtils;
import net.malisis.core.util.TransformBuilder;
import net.malisis.core.util.chunkcollision.IChunkCollidable;
import net.malisis.doors.MalisisDoors;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModelDoor
extends MalisisBlock
implements IChunkCollidable {
    private static PowerComponent OPENED = new PowerComponent(PowerComponent.InteractionType.BOTH, PowerComponent.ComponentType.RECEIVER);
    private AxisAlignedBB aabb = AABBUtils.identity();
    private AnimatedModelComponent amc = null;

    public ModelDoor() {
        super(Material.field_151573_f);
        this.func_149711_c(4.0f);
        this.func_149647_a(MalisisDoors.tab);
        this.setName("malisisdoors:hitechdoor");
        this.setTexture("malisisdoors:blocks/hitechdoor");
        this.aabb = new AxisAlignedBB(-1.0, 0.0, 0.375, 2.0, 2.0, 0.625);
        OPENED.setMetaOffset(2);
        this.addComponent((IComponent)OPENED);
        this.addComponent((IComponent)new DirectionalComponent());
        if (MalisisCore.isClient()) {
            this.amc = new AnimatedModelComponent("malisisdoors:models/hitechdoor.obj");
            this.amc.onRender((w, p, s, a) -> a.link(p, OPENED.get(s) ? "close" : "open", OPENED.get(s) ? "open" : "close"));
            this.addComponent((IComponent)this.amc);
            this.addComponent((IComponent)this.getTransform());
        }
    }

    @SideOnly(value=Side.CLIENT)
    private ItemTransformComponent getTransform() {
        Matrix4f gui = new TransformBuilder().translate(0.0f, -0.15f, 0.0f).rotate(30.0f, 45.0f, 0.0f).scale(0.34f).get();
        Matrix4f firstPerson = new TransformBuilder().rotate(0.0f, 135.0f, 0.0f).scale(0.2f).get();
        Matrix4f thirdPerson = new TransformBuilder().translate(0.0f, 0.155f, -0.1f).rotateAfter(75.0f, 100.0f, 0.0f).scale(0.25f).get();
        Matrix4f fixed = new TransformBuilder().translate(0.0f, -0.2f, 0.0f).scale(0.4f).get();
        Matrix4f ground = new TransformBuilder().translate(0.0f, 0.3f, 0.0f).scale(0.2f).get();
        return new ItemTransformComponent().thirdPerson(thirdPerson, thirdPerson).firstPerson(firstPerson, firstPerson).fixed(fixed).gui(gui).ground(ground);
    }

    public AxisAlignedBB getBoundingBox(IBlockAccess world, BlockPos pos, IBlockState state, BoundingBoxType type) {
        if (OPENED.get(state) && type == BoundingBoxType.COLLISION) {
            return null;
        }
        return this.aabb;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int blockRange() {
        return 2;
    }

    public void stateCheck(IBlockAccess world, BlockPos pos, IBlockState state, AnimatedModelComponent amc) {
    }
}

