/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.block;

import net.malisis.core.renderer.MalisisRendered;
import net.malisis.core.renderer.icon.provider.IIconProvider;
import net.malisis.core.util.EntityUtils;
import net.malisis.doors.block.Door;
import net.malisis.doors.renderer.CustomDoorRenderer;
import net.malisis.doors.tileentity.CustomDoorTileEntity;
import net.malisis.doors.tileentity.DoorTileEntity;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@MalisisRendered(value=CustomDoorRenderer.class)
public class CustomDoor
extends Door {
    public CustomDoor() {
        super(Material.field_151575_d);
        this.func_149711_c(3.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149663_c("customDoor");
    }

    @Override
    public String getName() {
        return "customDoor";
    }

    @Override
    public IIconProvider getIconProvider() {
        return null;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack itemStack) {
        super.func_180633_a(world, pos, state, placer, itemStack);
        world.func_175664_x(pos);
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        if (CustomDoor.isTop(state)) {
            return null;
        }
        return new CustomDoorTileEntity();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        DoorTileEntity door = Door.getDoor((IBlockAccess)world, target.func_178782_a());
        if (!(door instanceof CustomDoorTileEntity)) {
            return true;
        }
        CustomDoorTileEntity te = (CustomDoorTileEntity)door;
        EntityUtils.addHitEffects((World)world, (RayTraceResult)target, (ParticleManager)manager, (IBlockState[])new IBlockState[]{te.getFrame(), te.getTop(), te.getBottom()});
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        DoorTileEntity door = Door.getDoor((IBlockAccess)world, pos);
        if (!(door instanceof CustomDoorTileEntity)) {
            return true;
        }
        CustomDoorTileEntity te = (CustomDoorTileEntity)door;
        EntityUtils.addDestroyEffects((World)world, (BlockPos)pos, (ParticleManager)manager, (IBlockState[])new IBlockState[]{te.getFrame(), te.getTop(), te.getBottom()});
        return true;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (CustomDoor.isTop(state)) {
            return 0;
        }
        DoorTileEntity te = Door.getDoor(world, pos);
        return te instanceof CustomDoorTileEntity ? ((CustomDoorTileEntity)te).getLightValue() : 0;
    }
}

