/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nonnull;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.gui.recipes.IRecipeGuiLogic;
import mezz.jei.gui.recipes.IRecipeLogicStateListener;
import mezz.jei.gui.recipes.RecipeLayout;
import mezz.jei.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;

public class RecipeGuiLogic
implements IRecipeGuiLogic {
    @Nonnull
    private final IRecipeRegistry recipeRegistry;
    @Nonnull
    private final IRecipeLogicStateListener stateListener;
    private boolean initialState = true;
    @Nonnull
    private State state;
    @Nonnull
    private final Stack<State> history = new Stack();
    private List<IRecipeWrapper> recipes = Collections.emptyList();

    public RecipeGuiLogic(IRecipeRegistry recipeRegistry, IRecipeLogicStateListener stateListener) {
        this.recipeRegistry = recipeRegistry;
        this.stateListener = stateListener;
        IFocus<Object> focus = recipeRegistry.createFocus(IFocus.Mode.NONE, null);
        List<IRecipeCategory> recipeCategories = recipeRegistry.getRecipeCategories();
        this.state = new State(focus, recipeCategories, 0, 0);
    }

    @Override
    public <V> boolean setFocus(IFocus<V> focus) {
        List<IRecipeCategory> recipeCategories = this.recipeRegistry.getRecipeCategories(focus);
        if (recipeCategories.isEmpty()) {
            return false;
        }
        int recipeCategoryIndex = this.getRecipeCategoryIndex(recipeCategories);
        if (!this.initialState) {
            this.history.push(this.state);
        }
        State state = new State(focus, recipeCategories, recipeCategoryIndex, 0);
        this.setState(state);
        return true;
    }

    @Override
    public boolean back() {
        if (this.history.empty()) {
            return false;
        }
        State state = this.history.pop();
        this.setState(state);
        return true;
    }

    @Override
    public void clearHistory() {
        while (!this.history.empty()) {
            this.history.pop();
        }
    }

    private void setState(State state) {
        this.state = state;
        this.initialState = false;
        this.updateRecipes();
        this.stateListener.onStateChange();
    }

    private int getRecipeCategoryIndex(List<IRecipeCategory> recipeCategories) {
        Container container = Minecraft.func_71410_x().field_71439_g.field_71070_bA;
        if (container == null) {
            return 0;
        }
        for (int i = 0; i < recipeCategories.size(); ++i) {
            IRecipeCategory recipeCategory = recipeCategories.get(i);
            if (this.recipeRegistry.getRecipeTransferHandler(container, recipeCategory) == null) continue;
            return i;
        }
        return 0;
    }

    @Override
    public boolean setCategoryFocus() {
        IRecipeCategory recipeCategory = this.getSelectedRecipeCategory();
        if (!this.initialState) {
            this.history.push(this.state);
        }
        List<IRecipeCategory> recipeCategories = this.recipeRegistry.getRecipeCategories();
        int recipeCategoryIndex = recipeCategories.indexOf(recipeCategory);
        IFocus<Object> focus = this.recipeRegistry.createFocus(IFocus.Mode.NONE, null);
        State state = new State(focus, recipeCategories, recipeCategoryIndex, 0);
        this.setState(state);
        return true;
    }

    @Override
    public boolean setCategoryFocus(List<String> recipeCategoryUids) {
        List<IRecipeCategory> recipeCategories = this.recipeRegistry.getRecipeCategories(recipeCategoryUids);
        if (recipeCategories.isEmpty()) {
            return false;
        }
        if (!this.initialState) {
            this.history.push(this.state);
        }
        IFocus<Object> focus = this.recipeRegistry.createFocus(IFocus.Mode.NONE, null);
        State state = new State(focus, recipeCategories, 0, 0);
        this.setState(state);
        return true;
    }

    @Override
    public IFocus getFocus() {
        return this.state.focus;
    }

    @Override
    public List<ItemStack> getRecipeCategoryCraftingItems() {
        IRecipeCategory category = this.getSelectedRecipeCategory();
        IFocus<Object> focusNone = this.recipeRegistry.createFocus(IFocus.Mode.NONE, null);
        return this.recipeRegistry.getCraftingItems(category, focusNone);
    }

    @Override
    public List<ItemStack> getRecipeCategoryCraftingItems(IRecipeCategory recipeCategory) {
        IFocus<Object> focusNone = this.recipeRegistry.createFocus(IFocus.Mode.NONE, null);
        return this.recipeRegistry.getCraftingItems(recipeCategory, focusNone);
    }

    @Override
    public void setRecipesPerPage(int recipesPerPage) {
        if (this.state.recipesPerPage != recipesPerPage) {
            int recipeIndex = this.state.pageIndex * this.state.recipesPerPage;
            this.state.pageIndex = recipeIndex / recipesPerPage;
            this.state.recipesPerPage = recipesPerPage;
            this.updateRecipes();
        }
    }

    private void updateRecipes() {
        IRecipeCategory recipeCategory = this.getSelectedRecipeCategory();
        IFocus<?> focus = this.state.focus;
        this.recipes = this.recipeRegistry.getRecipeWrappers(recipeCategory, focus);
    }

    @Override
    public IRecipeCategory getSelectedRecipeCategory() {
        return (IRecipeCategory)this.state.recipeCategories.get(this.state.recipeCategoryIndex);
    }

    @Override
    public ImmutableList<IRecipeCategory> getRecipeCategories() {
        return this.state.recipeCategories;
    }

    @Override
    public List<RecipeLayout> getRecipeLayouts(int posX, int posY, int spacingY) {
        ArrayList<RecipeLayout> recipeLayouts = new ArrayList<RecipeLayout>();
        IRecipeCategory recipeCategory = this.getSelectedRecipeCategory();
        int recipeWidgetIndex = 0;
        for (int recipeIndex = this.state.pageIndex * this.state.recipesPerPage; recipeIndex < this.recipes.size() && recipeLayouts.size() < this.state.recipesPerPage; ++recipeIndex) {
            IRecipeWrapper recipeWrapper = this.recipes.get(recipeIndex);
            if (recipeWrapper == null) continue;
            RecipeLayout recipeLayout = new RecipeLayout(recipeWidgetIndex++, recipeCategory, recipeWrapper, this.state.focus, posX, posY);
            recipeLayouts.add(recipeLayout);
            posY += spacingY;
        }
        return recipeLayouts;
    }

    @Override
    public void nextRecipeCategory() {
        int recipesTypesCount = this.state.recipeCategories.size();
        this.state.recipeCategoryIndex = (this.state.recipeCategoryIndex + 1) % recipesTypesCount;
        this.state.pageIndex = 0;
        this.updateRecipes();
        this.stateListener.onStateChange();
    }

    @Override
    public void setRecipeCategory(IRecipeCategory category) {
        int index = this.state.recipeCategories.indexOf((Object)category);
        if (index < 0) {
            return;
        }
        this.state.recipeCategoryIndex = index;
        this.state.pageIndex = 0;
        this.updateRecipes();
        this.stateListener.onStateChange();
    }

    @Override
    public boolean hasMultiplePages() {
        return this.recipes.size() > this.state.recipesPerPage;
    }

    @Override
    public void previousRecipeCategory() {
        int recipesTypesCount = this.state.recipeCategories.size();
        this.state.recipeCategoryIndex = (recipesTypesCount + this.state.recipeCategoryIndex - 1) % recipesTypesCount;
        this.state.pageIndex = 0;
        this.updateRecipes();
        this.stateListener.onStateChange();
    }

    @Override
    public void nextPage() {
        int pageCount = this.pageCount(this.state.recipesPerPage);
        this.state.pageIndex = (this.state.pageIndex + 1) % pageCount;
        this.stateListener.onStateChange();
    }

    @Override
    public void previousPage() {
        int pageCount = this.pageCount(this.state.recipesPerPage);
        this.state.pageIndex = (pageCount + this.state.pageIndex - 1) % pageCount;
        this.stateListener.onStateChange();
    }

    private int pageCount(int recipesPerPage) {
        if (this.recipes.size() <= 1) {
            return 1;
        }
        return MathUtil.divideCeil(this.recipes.size(), recipesPerPage);
    }

    @Override
    public String getPageString() {
        return this.state.pageIndex + 1 + "/" + this.pageCount(this.state.recipesPerPage);
    }

    @Override
    public boolean hasMultipleCategories() {
        return this.state.recipeCategories.size() > 1;
    }

    @Override
    public boolean hasAllCategories() {
        return this.state.recipeCategories.size() == this.recipeRegistry.getRecipeCategories().size();
    }

    private static class State {
        @Nonnull
        public final IFocus<?> focus;
        @Nonnull
        public final ImmutableList<IRecipeCategory> recipeCategories;
        public int recipeCategoryIndex;
        public int pageIndex;
        public int recipesPerPage;

        public State(IFocus<?> focus, List<IRecipeCategory> recipeCategories, int recipeCategoryIndex, int pageIndex) {
            Preconditions.checkArgument((!recipeCategories.isEmpty() ? 1 : 0) != 0, (Object)"Recipe categories cannot be empty.");
            Preconditions.checkArgument((recipeCategoryIndex >= 0 ? 1 : 0) != 0, (Object)"Recipe category index cannot be negative.");
            Preconditions.checkArgument((pageIndex >= 0 ? 1 : 0) != 0, (Object)"Page index cannot be negative.");
            this.focus = focus;
            this.recipeCategories = ImmutableList.copyOf(recipeCategories);
            this.recipeCategoryIndex = recipeCategoryIndex;
            this.pageIndex = pageIndex;
        }
    }
}

