/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.tools;

import javax.annotation.Nonnull;
import mcjty.lib.tools.ItemStackTools;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidTools {
    public static ItemStack convertFluidToBucket(@Nonnull FluidStack fluidStack) {
        IFluidHandler fluidHandler = FluidUtil.getFluidHandler((ItemStack)new ItemStack(Items.field_151133_ar));
        if (fluidHandler == null) {
            return FluidContainerRegistry.fillFluidContainer((FluidStack)fluidStack, (ItemStack)new ItemStack(Items.field_151133_ar));
        }
        fluidHandler.fill(fluidStack, true);
        return FluidUtil.tryFillContainer((ItemStack)new ItemStack(Items.field_151133_ar), (IFluidHandler)fluidHandler, (int)1000, null, (boolean)true);
    }

    public static FluidStack convertBucketToFluid(@Nonnull ItemStack bucket) {
        IFluidTankProperties[] tankProperties;
        IFluidHandler fluidHandler = FluidUtil.getFluidHandler((ItemStack)bucket);
        if (fluidHandler == null) {
            return FluidContainerRegistry.getFluidForFilledItem((ItemStack)bucket);
        }
        for (IFluidTankProperties properties : tankProperties = fluidHandler.getTankProperties()) {
            FluidStack contents = properties.getContents();
            if (contents == null) continue;
            return contents;
        }
        return null;
    }

    public static boolean isEmptyContainer(@Nonnull ItemStack itemStack) {
        IFluidTankProperties[] tankProperties;
        IFluidHandler fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack);
        if (fluidHandler == null) {
            return FluidContainerRegistry.isEmptyContainer((ItemStack)itemStack);
        }
        for (IFluidTankProperties properties : tankProperties = fluidHandler.getTankProperties()) {
            if (!properties.canFill() || properties.getCapacity() <= 0) continue;
            FluidStack contents = properties.getContents();
            if (contents == null) {
                return true;
            }
            if (contents.amount <= 0) continue;
            return false;
        }
        return false;
    }

    public static boolean isFilledContainer(@Nonnull ItemStack itemStack) {
        IFluidTankProperties[] tankProperties;
        IFluidHandler fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack);
        if (fluidHandler == null) {
            return FluidContainerRegistry.isFilledContainer((ItemStack)itemStack);
        }
        for (IFluidTankProperties properties : tankProperties = fluidHandler.getTankProperties()) {
            if (!properties.canDrain()) {
                return false;
            }
            FluidStack contents = properties.getContents();
            if (contents != null && contents.amount >= properties.getCapacity()) continue;
            return false;
        }
        return true;
    }

    public static ItemStack drainContainer(@Nonnull ItemStack container) {
        ItemStack empty = container.func_77946_l();
        ItemStackTools.setStackSize(empty, 1);
        IFluidHandler fluidHandler = FluidUtil.getFluidHandler((ItemStack)empty);
        if (fluidHandler == null) {
            return FluidContainerRegistry.drainFluidContainer((ItemStack)container);
        }
        if (fluidHandler.drain(Integer.MAX_VALUE, true) != null) {
            return FluidUtil.tryEmptyContainer((ItemStack)container, (IFluidHandler)fluidHandler, (int)Integer.MAX_VALUE, null, (boolean)true);
        }
        return ItemStackTools.getEmptyStack();
    }

    public static ItemStack fillContainer(@Nonnull FluidStack fluidStack, @Nonnull ItemStack itemStack) {
        IFluidHandler fh = FluidUtil.getFluidHandler((ItemStack)itemStack.func_77946_l());
        if (fh == null) {
            return FluidContainerRegistry.fillFluidContainer((FluidStack)fluidStack, (ItemStack)itemStack);
        }
        int filled = fh.fill(fluidStack, true);
        if (filled == 0) {
            return ItemStackTools.getEmptyStack();
        }
        return FluidUtil.tryFillContainer((ItemStack)itemStack, (IFluidHandler)fh, (int)1000, null, (boolean)true);
    }

    public static int getCapacity(@Nonnull FluidStack fluidStack, @Nonnull ItemStack itemStack) {
        IFluidTankProperties[] tankProperties;
        IFluidHandler fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack);
        if (fluidHandler == null) {
            return FluidContainerRegistry.getContainerCapacity((FluidStack)fluidStack, (ItemStack)itemStack);
        }
        for (IFluidTankProperties properties : tankProperties = fluidHandler.getTankProperties()) {
            if (!properties.canDrainFluidType(fluidStack)) continue;
            return properties.getCapacity();
        }
        return 0;
    }
}

