/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.simplegenerators.core;

import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class SGConfig {
    private static Configuration config;
    private static File file;
    public static boolean enable_tier2;
    public static boolean enable_tier3;
    public static int tier2_multiplier;
    public static String tier2_crafting_item;
    public static int tier2_crafting_meta;
    public static String tier3_crafting_item;
    public static int tier3_crafting_meta;
    public static int furnace_rft;
    public static int furnace_buffer;
    public static int culinary_rft;
    public static int culinary_buffer;
    public static int lava_rft;
    public static int lava_buffer;
    public static int lava_mb_per_operation;
    public static int ender_rft;
    public static int ender_buffer;
    public static int netherstar_rft;
    public static int netherstar_buffer;

    public static void preInit() {
        file = new File("config/simplegenerators.cfg");
        config = new Configuration(file);
        if (file.exists()) {
            config.load();
        }
        enable_tier2 = config.getBoolean("Allow_MKII_Crafting", "General", enable_tier2, "Enables/disables MK.II generators crafting recipes.");
        enable_tier3 = config.getBoolean("Allow_MKIII_Crafting", "General", enable_tier3, "Enables/disables MK.III generators crafting recipes.");
        tier2_crafting_item = config.getString("T2CraftingItem", "General", "minecraft:dragon_breath", "Crafting item for MK.II generators.");
        tier2_crafting_meta = config.getInt("T2CraftingMeta", "General", 0, 0, Integer.MAX_VALUE, "meta of the MK.II crafting item.");
        tier3_crafting_item = config.getString("T3CraftingItem", "General", "minecraft:dragon_breath", "Crafting item for MK.III generators.");
        tier3_crafting_meta = config.getInt("T3CraftingMeta", "General", 0, 0, Integer.MAX_VALUE, "meta of the MK.III crafting item.");
        furnace_rft = config.getInt("rft", "FurnaceGen", furnace_rft, 16, 400, "rf/t for furnace generator");
        furnace_buffer = config.getInt("energybuffer", "FurnaceGen", furnace_buffer, 100000, 10000000, "Energy buffer size for furnace generator");
        culinary_rft = config.getInt("rft", "CulinaryGen", culinary_rft, 16, 400, "rf/t for Culinary generator");
        culinary_buffer = config.getInt("energybuffer", "CulinaryGen", culinary_buffer, 100000, 10000000, "Energy buffer size for Culinary generator");
        lava_rft = config.getInt("rft", "LavaGen", lava_rft, 16, 400, "rf/t for lava generator");
        lava_buffer = config.getInt("energybuffer", "LavaGen", lava_buffer, 100000, 10000000, "Energy buffer size for lava generator");
        lava_mb_per_operation = config.getInt("mbuse", "LavaGen", lava_mb_per_operation, 10, 1000, "Amount of mb the lava gen uses per operation");
        ender_rft = config.getInt("rft", "EnderGen", ender_rft, 16, 400, "rf/t for Ender generator");
        ender_buffer = config.getInt("energybuffer", "EnderGen", ender_buffer, 100000, 10000000, "Energy buffer size for Ender generator");
        netherstar_rft = config.getInt("rft", "NetherStarGen", netherstar_rft, 16, 64000, "rf/t for Nether Star generator");
        netherstar_buffer = config.getInt("energybuffer", "NetherStarGen", netherstar_buffer, 100000, 100000000, "Energy buffer size for Nether Star generator");
        if (!file.exists() || config.hasChanged()) {
            config.save();
        }
    }

    static {
        enable_tier2 = true;
        enable_tier3 = true;
        tier2_multiplier = 8;
        furnace_rft = 64;
        furnace_buffer = 1000000;
        culinary_rft = 32;
        culinary_buffer = 1000000;
        lava_rft = 64;
        lava_buffer = 1000000;
        lava_mb_per_operation = 100;
        ender_rft = 128;
        ender_buffer = 1000000;
        netherstar_rft = 2048;
        netherstar_buffer = 4000000;
    }
}

