/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.tiles;

import com.m4thg33k.tombmanygraves.TombManyGraves;
import com.m4thg33k.tombmanygraves.blocks.BlockDeath;
import com.m4thg33k.tombmanygraves.core.handlers.BaubleHandler;
import com.m4thg33k.tombmanygraves.core.handlers.FriendHandler;
import com.m4thg33k.tombmanygraves.core.util.ChatHelper;
import com.m4thg33k.tombmanygraves.lib.TombManyGravesConfigs;
import de.eydamos.backpack.data.PlayerSave;
import gr8pefish.ironbackpacks.api.items.backpacks.interfaces.IBackpack;
import gr8pefish.ironbackpacks.capabilities.player.PlayerWearingBackpackCapabilities;
import gr8pefish.ironbackpacks.items.upgrades.UpgradeMethods;
import gr8pefish.ironbackpacks.util.helpers.IronBackpacksHelper;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import lain.mods.cos.CosmeticArmorReworked;
import lain.mods.cos.inventory.InventoryCosArmor;
import lellson.expandablebackpack.inventory.iinventory.BackpackSlotInventory;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thut.wearables.inventory.PlayerWearables;
import thut.wearables.inventory.WearableHandler;

public class TileDeathBlock
extends TileEntity {
    private static final boolean DROP_ITEMS = TombManyGravesConfigs.DROP_ITEMS_ON_GROUND;
    private static final String TAG_CAMO = "camo";
    private static final String TAG_CAMO_META = "camoMeta";
    private String playerName = "";
    private InventoryPlayer savedPlayerInventory = new InventoryPlayer(null);
    private NBTTagCompound baublesNBT = new NBTTagCompound();
    private NBTTagCompound cosmeticNBT = new NBTTagCompound();
    private NBTTagCompound expandableBackpackNBT = new NBTTagCompound();
    private NBTTagCompound eydamosBackpackNBT = new NBTTagCompound();
    private NBTTagCompound thutNBT = new NBTTagCompound();
    private NBTTagCompound ironBackpackSlotNBT = new NBTTagCompound();
    private boolean locked = false;
    private UUID playerID = UUID.fromString("905379e2-068f-44c9-965b-6b9fbe1a6140");
    private int angle = 0;
    private boolean renderGround = false;
    private ItemStack skull = null;
    private IBlockState camoState;
    private boolean GIVE_PRIORITY_TO_GRAVE = TombManyGravesConfigs.GIVE_PRIORITY_TO_GRAVE_ITEMS;
    private String timestamp = "";

    public TileDeathBlock() {
        this.locked = TombManyGravesConfigs.DEFAULT_TO_LOCKED;
    }

    public void setPlayerName(String name) {
        this.playerName = name;
        this.setSkull();
    }

    public void setPlayerID(UUID id) {
        this.playerID = id;
    }

    public void grabPlayer(EntityPlayer player) {
        this.angle = (int)player.field_70759_as;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.setPlayerName(player.func_70005_c_());
        this.setPlayerID(player.func_110124_au());
        if (TombManyGravesConfigs.ALLOW_MAIN_INVENTORY) {
            this.setThisInventory(player.field_71071_by);
        }
        if (TombManyGraves.isBaublesInstalled && TombManyGravesConfigs.ALLOW_BAUBLES) {
            this.setBaubleInventory(player);
        }
        if (TombManyGraves.isCosmeticArmorInstalled && TombManyGravesConfigs.ALLOW_COSMETIC_ARMOR) {
            this.setCosmeticInventory(player);
        }
        if (TombManyGraves.isExpandableBackpacksInstalled && TombManyGravesConfigs.ALLOW_EXPANDABLE_BACKPACKS) {
            this.setExpandableBackpackInventory(player);
        }
        if (TombManyGraves.isEydamosBackpacksInstalled && TombManyGravesConfigs.ALLOW_EYDAMOS_BACKPACKS) {
            this.setEydamosBackpackInventory(player);
        }
        if (TombManyGraves.isThutWearablesInstalled && TombManyGravesConfigs.ALLOW_THUT_WEARABLES) {
            this.setThutInventory(player);
        }
        if (TombManyGraves.isIronBackpacksInstalled && TombManyGravesConfigs.ALLOW_IRON_BACKPACKS) {
            this.setIronBackpacksInventory(player);
        }
        this.func_70296_d();
        this.field_145850_b.markAndNotifyBlock(this.field_174879_c, null, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 1);
    }

    public void setBaubleInventory(EntityPlayer player) {
        this.baublesNBT = TileDeathBlock.getBaublesNBTSansSoulbound(player, true);
    }

    public void setThisInventory(InventoryPlayer inventoryPlayer) {
        this.savedPlayerInventory = TileDeathBlock.getInventorySansSoulbound(inventoryPlayer, true);
    }

    public void setCosmeticInventory(EntityPlayer player) {
        this.cosmeticNBT = TileDeathBlock.getCosmeticNBTSansSoulbound(player, true);
    }

    public void setExpandableBackpackInventory(EntityPlayer player) {
        this.expandableBackpackNBT = TileDeathBlock.getExpandableBackpackNBTSansSoulbound(player, true);
    }

    public void setEydamosBackpackInventory(EntityPlayer player) {
        this.eydamosBackpackNBT = TileDeathBlock.getEydamosBackpackNBTSansSoulbound(player, true);
    }

    public void setThutInventory(EntityPlayer player) {
        this.thutNBT = TileDeathBlock.getThutNBTSansSoulbound(player, true);
    }

    public void setIronBackpacksInventory(EntityPlayer player) {
        ItemStack equippedPack = PlayerWearingBackpackCapabilities.getEquippedBackpack((EntityLivingBase)player);
        if (TileDeathBlock.isValidForGrave(equippedPack)) {
            equippedPack.func_77955_b(this.ironBackpackSlotNBT);
            PlayerWearingBackpackCapabilities.setEquippedBackpack((EntityLivingBase)player, null);
        }
    }

    public static boolean isValidForGrave(ItemStack stack) {
        boolean hasSize;
        boolean bl = hasSize = stack != null && stack.field_77994_a > 0;
        if (!hasSize) {
            return false;
        }
        if (TombManyGraves.ITEM_BLACK_LIST_HANDLER.isBlacklisted(stack)) {
            return false;
        }
        boolean notSoulbound = !TileDeathBlock.hasSoulboundEnchantment(stack);
        boolean isBook = stack.func_77973_b() == Items.field_151134_bR;
        return isBook || notSoulbound;
    }

    public void onRightClick(EntityPlayer player) {
        if (this.hasAccess(player)) {
            this.toggleGravePriority();
            if (this.GIVE_PRIORITY_TO_GRAVE) {
                ChatHelper.sayMessage(player.field_70170_p, player, "Grave items will be forced into their original slots.");
            } else {
                ChatHelper.sayMessage(player.field_70170_p, player, "Your current inventory will not be altered.");
            }
        } else {
            ChatHelper.sayMessage(player.field_70170_p, player, "You don't have permission to interact with this grave.");
        }
    }

    public boolean isSamePlayer(EntityPlayer player) {
        return TombManyGravesConfigs.ALLOW_GRAVE_ROBBING || player.func_110124_au().equals(this.playerID);
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.playerName = compound.func_74779_i("PlayerName");
        this.setSkull();
        this.savedPlayerInventory.func_70443_b(compound.func_150295_c("Inventory", 10));
        this.baublesNBT = compound.func_74775_l("BaublesNBT");
        this.expandableBackpackNBT = compound.func_74775_l("ExpandableBackpackNBT");
        this.eydamosBackpackNBT = compound.func_74775_l("EydamosBackpackNBT");
        this.thutNBT = compound.func_74775_l("ThutNBT");
        this.ironBackpackSlotNBT = compound.func_74775_l("IronBackpacksNBT");
        this.angle = compound.func_74762_e("AngleOfDeath");
        this.locked = compound.func_74767_n("IsLocked");
        this.playerID = compound.func_186857_a("PlayerID");
        this.GIVE_PRIORITY_TO_GRAVE = compound.func_74767_n("GravePriority");
        Block b = Block.func_149684_b((String)compound.func_74779_i(TAG_CAMO));
        if (b != null) {
            this.camoState = b.func_176203_a(compound.func_74762_e(TAG_CAMO_META));
        }
        this.cosmeticNBT = compound.func_74775_l("CosmeticNBT");
        if (compound.func_74764_b("Timestamp")) {
            this.timestamp = compound.func_74779_i("Timestamp");
        }
        this.setRenderGround();
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74778_a("PlayerName", this.playerName);
        NBTTagList tagList = new NBTTagList();
        this.savedPlayerInventory.func_70442_a(tagList);
        compound.func_74782_a("Inventory", (NBTBase)tagList);
        compound.func_74782_a("BaublesNBT", (NBTBase)this.baublesNBT);
        compound.func_74782_a("ExpandableBackpackNBT", (NBTBase)this.expandableBackpackNBT);
        compound.func_74782_a("EydamosBackpackNBT", (NBTBase)this.eydamosBackpackNBT);
        compound.func_74782_a("ThutNBT", (NBTBase)this.thutNBT);
        compound.func_74768_a("AngleOfDeath", this.angle);
        compound.func_74757_a("IsLocked", this.locked);
        if (this.playerID != null) {
            compound.func_186854_a("PlayerID", this.playerID);
        }
        compound.func_74757_a("GravePriority", this.GIVE_PRIORITY_TO_GRAVE);
        if (this.camoState != null) {
            compound.func_74778_a(TAG_CAMO, ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.camoState.func_177230_c())).toString());
            compound.func_74768_a(TAG_CAMO_META, this.camoState.func_177230_c().func_176201_c(this.camoState));
        }
        compound.func_74782_a("CosmeticNBT", (NBTBase)this.cosmeticNBT);
        compound.func_74782_a("IronBackpacksNBT", (NBTBase)this.ironBackpackSlotNBT);
        compound.func_74778_a("Timestamp", this.timestamp);
        return compound;
    }

    private void toggleGravePriority() {
        this.GIVE_PRIORITY_TO_GRAVE = !this.GIVE_PRIORITY_TO_GRAVE;
        this.func_70296_d();
        this.field_145850_b.markAndNotifyBlock(this.field_174879_c, null, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
    }

    public void onCollision(EntityPlayer player) {
        if (this.field_145850_b.field_72995_K || this.locked || !this.hasAccess(player)) {
            return;
        }
        if (DROP_ITEMS) {
            this.dropAllItems();
        } else {
            if (this.GIVE_PRIORITY_TO_GRAVE) {
                this.swapPlayerInventory(player);
            } else {
                this.replacePlayerInventory(player);
            }
            if (TombManyGraves.isBaublesInstalled) {
                if (this.GIVE_PRIORITY_TO_GRAVE) {
                    this.swapPlayerBaubles(player);
                } else {
                    this.replaceBaublesInventory(player);
                }
            }
            if (TombManyGraves.isCosmeticArmorInstalled) {
                if (this.GIVE_PRIORITY_TO_GRAVE) {
                    this.swapPlayerCosmetic(player);
                } else {
                    this.replaceCosmeticInventory(player);
                }
            }
            if (TombManyGraves.isExpandableBackpacksInstalled) {
                if (this.GIVE_PRIORITY_TO_GRAVE) {
                    this.swapExpandableBackpack(player);
                } else {
                    this.replaceExpandableBackpack(player);
                }
            }
            if (TombManyGraves.isEydamosBackpacksInstalled) {
                if (this.GIVE_PRIORITY_TO_GRAVE) {
                    this.swapEydamosBackpack(player);
                } else {
                    this.replaceEydamosBackpack(player);
                }
            }
            if (TombManyGraves.isThutWearablesInstalled) {
                if (this.GIVE_PRIORITY_TO_GRAVE) {
                    this.swapThutInventory(player);
                } else {
                    this.replaceThutInventory(player);
                }
            }
            if (TombManyGraves.isIronBackpacksInstalled) {
                if (this.GIVE_PRIORITY_TO_GRAVE) {
                    this.swapIronBackpacks(player);
                } else {
                    this.replaceIronBackpacks(player);
                }
            }
        }
        this.field_145850_b.func_175698_g(this.field_174879_c);
    }

    public void swapPlayerInventory(EntityPlayer player) {
        InventoryPlayer current = new InventoryPlayer(player);
        current.func_70455_b(player.field_71071_by);
        player.field_71071_by.func_174888_l();
        this.replaceSpecificInventory(player, (IInventory)player.field_71071_by, (IInventory)this.savedPlayerInventory);
        this.replaceSpecificInventory(player, (IInventory)player.field_71071_by, (IInventory)current);
        this.savedPlayerInventory = new InventoryPlayer(player);
    }

    public void swapPlayerBaubles(EntityPlayer player) {
        NBTTagCompound playerB = BaubleHandler.getBaubleNBT(player);
        BaubleHandler.clearBaubles(player);
        this.replaceBaublesInventory(player);
        this.baublesNBT = playerB;
        this.replaceBaublesInventory(player);
        this.baublesNBT = new NBTTagCompound();
    }

    public void swapPlayerCosmetic(EntityPlayer player) {
        InventoryCosArmor playerCos = CosmeticArmorReworked.invMan.getCosArmorInventory(player.func_110124_au());
        NBTTagCompound playerC = new NBTTagCompound();
        playerCos.writeToNBT(playerC);
        InventoryCosArmor currentCos = new InventoryCosArmor();
        currentCos.readFromNBT(playerC);
        playerCos.func_174888_l();
        this.replaceCosmeticInventory(player);
        this.cosmeticNBT = playerC;
        this.replaceCosmeticInventory(player);
        this.cosmeticNBT = new NBTTagCompound();
    }

    public void swapExpandableBackpack(EntityPlayer player) {
        BackpackSlotInventory backpackInventory = new BackpackSlotInventory(player);
        if (backpackInventory.func_70301_a(0) != null) {
            InventoryHelper.func_180175_a((World)player.field_70170_p, (BlockPos)player.func_180425_c(), (IInventory)backpackInventory);
        }
        ItemStack savedBackpack = ItemStack.func_77949_a((NBTTagCompound)this.expandableBackpackNBT);
        backpackInventory.func_70299_a(0, savedBackpack);
        this.expandableBackpackNBT = new NBTTagCompound();
    }

    public void swapEydamosBackpack(EntityPlayer player) {
        ItemStack savedBackpack = ItemStack.func_77949_a((NBTTagCompound)this.eydamosBackpackNBT);
        if (savedBackpack == null || savedBackpack.field_77994_a == 0) {
            return;
        }
        PlayerSave playerSave = PlayerSave.loadPlayer((World)player.field_70170_p, (EntityPlayer)player);
        ItemStack currentBackpack = playerSave.getBackpack();
        if (currentBackpack != null) {
            EntityItem entityItem = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, currentBackpack);
            player.field_70170_p.func_72838_d((Entity)entityItem);
        }
        playerSave.func_70299_a(0, savedBackpack);
        this.eydamosBackpackNBT = new NBTTagCompound();
    }

    public void swapThutInventory(EntityPlayer player) {
        PlayerWearables currentInventory = WearableHandler.getInstance().getPlayerData(this.playerID);
        NBTTagCompound current = new NBTTagCompound();
        currentInventory.writeToNBT(current);
        currentInventory.func_174888_l();
        this.replaceThutInventory(player);
        this.thutNBT = current;
        this.replaceThutInventory(player);
        this.thutNBT = new NBTTagCompound();
    }

    public void swapIronBackpacks(EntityPlayer player) {
        ItemStack savedBackpack = ItemStack.func_77949_a((NBTTagCompound)this.ironBackpackSlotNBT);
        if (savedBackpack != null && savedBackpack.field_77994_a > 0) {
            ItemStack currentPack = PlayerWearingBackpackCapabilities.getEquippedBackpack((EntityLivingBase)player);
            if (currentPack != null) {
                EntityItem toDrop = new EntityItem(this.field_145850_b, player.field_70165_t, player.field_70163_u, player.field_70161_v, currentPack);
                this.field_145850_b.func_72838_d((Entity)toDrop);
            }
            PlayerWearingBackpackCapabilities.setEquippedBackpack((EntityLivingBase)player, (ItemStack)savedBackpack);
            this.ironBackpackSlotNBT = new NBTTagCompound();
        }
    }

    public void replaceSpecificInventory(EntityPlayer player, IInventory playerInventory, IInventory savedInventory) {
        for (int i = 0; i < playerInventory.func_70302_i_(); ++i) {
            if (savedInventory.func_70301_a(i) == null || savedInventory.func_70301_a((int)i).field_77994_a <= 0) continue;
            if (playerInventory.func_70301_a(i) == null) {
                playerInventory.func_70299_a(i, savedInventory.func_70301_a(i));
                continue;
            }
            EntityItem entityItem = new EntityItem(this.field_145850_b, player.field_70165_t, player.field_70163_u, player.field_70161_v, savedInventory.func_70301_a(i));
            this.field_145850_b.func_72838_d((Entity)entityItem);
        }
    }

    public void replaceIronBackpacks(EntityPlayer player) {
        ItemStack savedBackpack = ItemStack.func_77949_a((NBTTagCompound)this.ironBackpackSlotNBT);
        if (savedBackpack != null && savedBackpack.field_77994_a > 0) {
            ItemStack currentPack = PlayerWearingBackpackCapabilities.getEquippedBackpack((EntityLivingBase)player);
            if (currentPack != null) {
                EntityItem toDrop = new EntityItem(this.field_145850_b, player.field_70165_t, player.field_70163_u, player.field_70161_v, savedBackpack);
                this.field_145850_b.func_72838_d((Entity)toDrop);
            } else {
                PlayerWearingBackpackCapabilities.setEquippedBackpack((EntityLivingBase)player, (ItemStack)savedBackpack);
            }
            this.ironBackpackSlotNBT = new NBTTagCompound();
        }
    }

    public void replacePlayerInventory(EntityPlayer player) {
        this.replaceSpecificInventory(player, (IInventory)player.field_71071_by, (IInventory)this.savedPlayerInventory);
        this.savedPlayerInventory = new InventoryPlayer(null);
    }

    public void replaceBaublesInventory(EntityPlayer player) {
        IInventory currentBaubles = BaubleHandler.getCurrentBaubles(player);
        IInventory savedBaubles = BaubleHandler.getSavedBaubles(this.baublesNBT, player);
        this.replaceSpecificInventory(player, currentBaubles, savedBaubles);
        BaubleHandler.setPlayerBaubles(player, currentBaubles);
        this.baublesNBT = new NBTTagCompound();
    }

    public void replaceCosmeticInventory(EntityPlayer player) {
        InventoryCosArmor currentCos = CosmeticArmorReworked.invMan.getCosArmorInventory(player.func_110124_au());
        InventoryCosArmor savedCos = new InventoryCosArmor();
        savedCos.readFromNBT(this.cosmeticNBT);
        this.replaceSpecificInventory(player, (IInventory)currentCos, (IInventory)savedCos);
        this.cosmeticNBT = new NBTTagCompound();
    }

    public void replaceExpandableBackpack(EntityPlayer player) {
        BackpackSlotInventory backpackInventory = new BackpackSlotInventory(player);
        ItemStack savedBackpack = ItemStack.func_77949_a((NBTTagCompound)this.expandableBackpackNBT);
        if (savedBackpack == null || savedBackpack.field_77994_a == 0) {
            return;
        }
        if (backpackInventory.func_70301_a(0) == null) {
            backpackInventory.func_70299_a(0, savedBackpack);
        } else {
            EntityItem entityItem = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, savedBackpack);
            player.field_70170_p.func_72838_d((Entity)entityItem);
        }
        this.expandableBackpackNBT = new NBTTagCompound();
    }

    public void replaceEydamosBackpack(EntityPlayer player) {
        PlayerSave playerSave = PlayerSave.loadPlayer((World)player.field_70170_p, (EntityPlayer)player);
        ItemStack savedBackpack = ItemStack.func_77949_a((NBTTagCompound)this.eydamosBackpackNBT);
        if (savedBackpack == null || savedBackpack.field_77994_a == 0) {
            return;
        }
        ItemStack currentBackpack = playerSave.getBackpack();
        if (currentBackpack != null) {
            EntityItem entityItem = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, savedBackpack);
            player.field_70170_p.func_72838_d((Entity)entityItem);
        } else {
            playerSave.func_70299_a(0, savedBackpack);
        }
        this.eydamosBackpackNBT = new NBTTagCompound();
    }

    public void replaceThutInventory(EntityPlayer player) {
        PlayerWearables saved = new PlayerWearables();
        saved.readFromNBT(this.thutNBT);
        this.replaceSpecificInventory(player, (IInventory)WearableHandler.getInstance().getPlayerData(this.playerID), (IInventory)saved);
        this.thutNBT = new NBTTagCompound();
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.playerName = pkt.func_148857_g().func_74779_i("PlayerName");
        this.setSkull();
        this.angle = pkt.func_148857_g().func_74762_e("AngleOfDeath");
        this.locked = pkt.func_148857_g().func_74767_n("IsLocked");
        this.playerID = pkt.func_148857_g().func_186857_a("PlayerID");
        this.GIVE_PRIORITY_TO_GRAVE = pkt.func_148857_g().func_74767_n("GravePriority");
        Block b = Block.func_149684_b((String)pkt.func_148857_g().func_74779_i(TAG_CAMO));
        if (b != null) {
            this.camoState = b.func_176203_a(pkt.func_148857_g().func_74762_e(TAG_CAMO_META));
        }
        this.setRenderGround();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = this.func_189517_E_();
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, compound);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public int getAngle() {
        return this.angle;
    }

    public void dropAllItems() {
        ItemStack pack;
        ItemStack itemStack;
        InventoryHelper.func_180175_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, (IInventory)this.savedPlayerInventory);
        if (TombManyGraves.isBaublesInstalled) {
            InventoryHelper.func_180175_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, (IInventory)BaubleHandler.getSavedBaubles(this.baublesNBT));
        }
        if (TombManyGraves.isCosmeticArmorInstalled) {
            InventoryCosArmor cosArmor = new InventoryCosArmor();
            cosArmor.readFromNBT(this.cosmeticNBT);
            InventoryHelper.func_180175_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, (IInventory)cosArmor);
        }
        if (TombManyGraves.isExpandableBackpacksInstalled && (itemStack = ItemStack.func_77949_a((NBTTagCompound)this.expandableBackpackNBT)) != null && itemStack.field_77994_a > 0) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), itemStack));
        }
        if (TombManyGraves.isEydamosBackpacksInstalled && (itemStack = ItemStack.func_77949_a((NBTTagCompound)this.eydamosBackpackNBT)) != null && itemStack.field_77994_a > 0) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), itemStack));
        }
        if (TombManyGraves.isThutWearablesInstalled) {
            PlayerWearables playerWearables = new PlayerWearables();
            playerWearables.readFromNBT(this.thutNBT);
            InventoryHelper.func_180175_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, (IInventory)playerWearables);
        }
        if (TombManyGraves.isIronBackpacksInstalled && (pack = ItemStack.func_77949_a((NBTTagCompound)this.ironBackpackSlotNBT)) != null && pack.field_77994_a > 0) {
            EntityItem entityItem = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), pack);
            this.field_145850_b.func_72838_d((Entity)entityItem);
        }
    }

    public static boolean isInventoryEmpty(EntityPlayer player) {
        boolean toReturn = TileDeathBlock.isSpecificInventoryEmpty((IInventory)player.field_71071_by);
        if (TombManyGraves.isBaublesInstalled) {
            boolean bl = toReturn = toReturn && TileDeathBlock.isSpecificInventoryEmpty(BaubleHandler.getCurrentBaubles(player));
        }
        if (TombManyGraves.isCosmeticArmorInstalled) {
            boolean bl = toReturn = toReturn && TileDeathBlock.isSpecificInventoryEmpty((IInventory)CosmeticArmorReworked.invMan.getCosArmorInventory(player.func_110124_au()));
        }
        if (TombManyGraves.isExpandableBackpacksInstalled) {
            BackpackSlotInventory backpack = new BackpackSlotInventory(player);
            boolean bl = toReturn = toReturn && TileDeathBlock.isSpecificInventoryEmpty((IInventory)backpack);
        }
        if (TombManyGraves.isEydamosBackpacksInstalled) {
            boolean bl = toReturn = toReturn && TileDeathBlock.isSpecificInventoryEmpty((IInventory)PlayerSave.loadPlayer((World)player.field_70170_p, (EntityPlayer)player));
        }
        if (TombManyGraves.isThutWearablesInstalled) {
            boolean bl = toReturn = toReturn && TileDeathBlock.isSpecificInventoryEmpty((IInventory)WearableHandler.getInstance().getPlayerData(player));
        }
        if (TombManyGraves.isIronBackpacksInstalled) {
            toReturn = toReturn && !TileDeathBlock.doesPlayerHaveIronBackpackForGrave(player);
        }
        return toReturn;
    }

    public static boolean isSpecificInventoryEmpty(IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i) == null || inventory.func_70301_a((int)i).field_77994_a <= 0 || inventory.func_70301_a(i).func_77973_b() != Items.field_151134_bR && TileDeathBlock.hasSoulboundEnchantment(inventory.func_70301_a(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean doesPlayerHaveIronBackpackForGrave(EntityPlayer player) {
        ItemStack pack = PlayerWearingBackpackCapabilities.getEquippedBackpack((EntityLivingBase)player);
        return pack != null && !UpgradeMethods.hasEternityUpgrade((ArrayList)IronBackpacksHelper.getUpgradesAppliedFromNBT((ItemStack)pack));
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void toggleLock(EntityPlayer player) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.hasAccess(player)) {
            boolean bl = this.locked = !this.locked;
            if (TombManyGravesConfigs.ALLOW_LOCKING_MESSAGES) {
                ChatHelper.sayMessage(player.field_70170_p, player, "This grave is now " + (this.locked ? "locked!" : "unlocked!"));
            }
            this.func_70296_d();
            this.field_145850_b.markAndNotifyBlock(this.field_174879_c, null, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
        } else {
            ChatHelper.sayMessage(player.field_70170_p, player, "You do not have permission to modify this grave.");
        }
    }

    public boolean isFriend(EntityPlayer player) {
        return FriendHandler.isFriendOf(this.playerID, player.func_110124_au());
    }

    public boolean hasAccess(EntityPlayer player) {
        return TombManyGravesConfigs.ALLOW_GRAVE_ROBBING || this.isSamePlayer(player) || this.isFriend(player);
    }

    public boolean getRenderGround() {
        return this.renderGround;
    }

    public ItemStack getSkull() {
        return this.skull;
    }

    private void setSkull() {
        this.skull = new ItemStack(Items.field_151144_bL, 1, 3);
        this.skull.func_77982_d(new NBTTagCompound());
        this.skull.func_77978_p().func_74782_a("SkullOwner", (NBTBase)new NBTTagString(this.playerName));
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return true;
    }

    public void setCamoState(IBlockState state) {
        this.camoState = state;
        this.setRenderGround();
    }

    public IBlockState getCamoState() {
        return this.camoState;
    }

    public void setRenderGround() {
        this.renderGround = this.camoState != null && !(this.camoState.func_177230_c() instanceof BlockDeath);
    }

    public static boolean hasInvalidEnchantment(ItemStack stack) {
        if (stack == null || stack.field_77994_a == 0) {
            return false;
        }
        Map enchantMap = EnchantmentHelper.func_82781_a((ItemStack)stack);
        for (Enchantment enchantment : enchantMap.keySet()) {
            String enchantName = enchantment.getRegistryName().toString();
            if (!TombManyGravesConfigs.BLACKLISTED_ENCHANTMENTS.containsKey(enchantName) || TombManyGravesConfigs.BLACKLISTED_ENCHANTMENTS.get(enchantName) >= (Integer)enchantMap.get(enchantment)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSoulboundEnchantment(ItemStack stack) {
        if (stack == null || stack.field_77994_a == 0) {
            return false;
        }
        if (TileDeathBlock.hasInvalidEnchantment(stack)) {
            return true;
        }
        if (TombManyGraves.isIronBackpacksInstalled && stack.func_77973_b() instanceof IBackpack && UpgradeMethods.hasEternityUpgrade((ArrayList)IronBackpacksHelper.getUpgradesAppliedFromNBT((ItemStack)stack))) {
            return true;
        }
        if (stack.func_77942_o()) {
            NBTTagCompound tagCompound = stack.func_77978_p();
            if (tagCompound.func_74764_b("TinkerData")) {
                if ((tagCompound = tagCompound.func_74775_l("TinkerData")).func_74764_b("Modifiers")) {
                    NBTTagList modifiers = tagCompound.func_150295_c("Modifiers", 8);
                    for (int i = 0; i < modifiers.func_74745_c(); ++i) {
                        if (!"soulbound".equals(modifiers.func_150307_f(i))) continue;
                        return true;
                    }
                }
            } else if (tagCompound.func_74764_b("spectreAnchor")) {
                return true;
            }
        }
        return false;
    }

    public static void copyInventoryWithoutSoulbound(IInventory original, IInventory newer, boolean clearOriginal) {
        TileDeathBlock.copyInventoryWithoutSoulbound(original, newer, clearOriginal, new ArrayList<Integer>());
    }

    public static void copyInventoryWithoutSoulbound(IInventory original, IInventory newer, boolean clearOriginal, ArrayList<Integer> blacklistedSlots) {
        for (int i = 0; i < newer.func_70302_i_(); ++i) {
            if (blacklistedSlots.contains(i) || !TileDeathBlock.isValidForGrave(original.func_70301_a(i))) continue;
            newer.func_70299_a(i, original.func_70301_a(i).func_77946_l());
            if (!clearOriginal) continue;
            original.func_70299_a(i, null);
        }
    }

    public static InventoryPlayer getInventorySansSoulbound(InventoryPlayer original, boolean clearOriginal) {
        InventoryPlayer toReturn = new InventoryPlayer(original.field_70458_d);
        TileDeathBlock.copyInventoryWithoutSoulbound((IInventory)original, (IInventory)toReturn, clearOriginal, TombManyGravesConfigs.BLACKLISTED_PLAYER_INVENTORY);
        return toReturn;
    }

    public static NBTTagCompound getBaublesNBTSansSoulbound(EntityPlayer player, boolean clearOriginal) {
        InventoryBasic toReturn = new InventoryBasic("Temp", false, BaubleHandler.getNumSlots());
        IInventory current = BaubleHandler.getCurrentBaubles(player);
        TileDeathBlock.copyInventoryWithoutSoulbound(current, (IInventory)toReturn, clearOriginal);
        BaubleHandler.setPlayerBaubles(player, current);
        NBTTagCompound compound = BaubleHandler.getNBTFromInventory((IInventory)toReturn);
        return compound;
    }

    public static NBTTagCompound getCosmeticNBTSansSoulbound(EntityPlayer player, boolean clearOriginal) {
        InventoryCosArmor toReturn = new InventoryCosArmor();
        InventoryCosArmor current = CosmeticArmorReworked.invMan.getCosArmorInventory(player.func_110124_au());
        TileDeathBlock.copyInventoryWithoutSoulbound((IInventory)current, (IInventory)toReturn, clearOriginal);
        NBTTagCompound compound = new NBTTagCompound();
        toReturn.writeToNBT(compound);
        return compound;
    }

    public static NBTTagCompound getExpandableBackpackNBTSansSoulbound(EntityPlayer player, boolean clearOriginal) {
        BackpackSlotInventory inventory = new BackpackSlotInventory(player);
        NBTTagCompound compound = new NBTTagCompound();
        ItemStack itemStack = inventory.func_70301_a(0);
        if (TileDeathBlock.isValidForGrave(itemStack)) {
            itemStack.func_77955_b(compound);
            if (clearOriginal) {
                inventory.func_70299_a(0, null);
            }
        }
        return compound;
    }

    public static NBTTagCompound getEydamosBackpackNBTSansSoulbound(EntityPlayer player, boolean clearOriginal) {
        PlayerSave playerSave = PlayerSave.loadPlayer((World)player.field_70170_p, (EntityPlayer)player);
        ItemStack backpack = playerSave.getBackpack();
        NBTTagCompound compound = new NBTTagCompound();
        if (TileDeathBlock.isValidForGrave(backpack)) {
            backpack.func_77955_b(compound);
            if (clearOriginal) {
                playerSave.func_70299_a(0, null);
            }
        }
        return compound;
    }

    public static NBTTagCompound getThutNBTSansSoulbound(EntityPlayer player, boolean clearOriginal) {
        PlayerWearables playerWearables = WearableHandler.getInstance().getPlayerData(player);
        PlayerWearables toReturn = new PlayerWearables();
        NBTTagCompound compound = new NBTTagCompound();
        TileDeathBlock.copyInventoryWithoutSoulbound((IInventory)playerWearables, (IInventory)toReturn, clearOriginal);
        toReturn.writeToNBT(compound);
        return compound;
    }

    public boolean areGraveItemsForced() {
        return this.GIVE_PRIORITY_TO_GRAVE;
    }

    public void setTimeStamp(String stamp) {
        this.timestamp = stamp;
        this.func_70296_d();
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void clearInventory() {
        this.savedPlayerInventory.func_174888_l();
        this.baublesNBT = new NBTTagCompound();
        this.cosmeticNBT = new NBTTagCompound();
        this.expandableBackpackNBT = new NBTTagCompound();
        this.eydamosBackpackNBT = new NBTTagCompound();
        this.thutNBT = new NBTTagCompound();
        this.ironBackpackSlotNBT = new NBTTagCompound();
    }
}

