/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.core.util;

import com.google.common.primitives.Bytes;
import com.m4thg33k.tombmanygraves.core.util.LogHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class NBTBlacklistItem {
    private List<String> names = new ArrayList<String>();
    private List<NBTBase> data = new ArrayList<NBTBase>();
    private boolean stillValid = true;

    public NBTBlacklistItem(String string) {
        Pattern pattern = Pattern.compile("([^,]+)");
        Matcher matcher = pattern.matcher(string);
        while (this.stillValid && matcher.find()) {
            String name;
            int type;
            String match = matcher.group();
            try {
                type = Integer.parseInt(match);
                matcher.find();
                name = matcher.group();
            }
            catch (Exception e) {
                this.stillValid = false;
                LogHelper.warn("Invalid NBT path: " + string);
                return;
            }
            NBTTagList base = null;
            switch (type) {
                case 1: {
                    if (!matcher.find()) break;
                    int value = this.getInteger(matcher, string);
                    base = new NBTTagByte((byte)value);
                    break;
                }
                case 2: {
                    if (!matcher.find()) break;
                    int value = this.getInteger(matcher, string);
                    base = new NBTTagShort((short)value);
                    break;
                }
                case 3: {
                    if (!matcher.find()) break;
                    int value = this.getInteger(matcher, string);
                    base = new NBTTagInt(value);
                    break;
                }
                case 4: {
                    if (!matcher.find()) break;
                    long value = this.getLong(matcher, string);
                    base = new NBTTagLong(value);
                    break;
                }
                case 5: {
                    if (!matcher.find()) break;
                    float value = this.getFloat(matcher, string);
                    base = new NBTTagFloat(value);
                    break;
                }
                case 6: {
                    if (!matcher.find()) break;
                    double value = this.getDouble(matcher, string);
                    base = new NBTTagDouble(value);
                    break;
                }
                case 7: {
                    if (!matcher.find()) break;
                    byte[] value = this.getByteArray(matcher, string);
                    base = new NBTTagByteArray(value);
                    break;
                }
                case 8: {
                    base = new NBTTagString(name);
                    break;
                }
                case 9: {
                    base = new NBTTagList();
                    break;
                }
                case 10: {
                    base = new NBTTagCompound();
                    break;
                }
                case 11: {
                    if (!matcher.find()) break;
                    int[] value = this.getIntArray(matcher, string);
                    base = new NBTTagIntArray(value);
                    break;
                }
                default: {
                    base = null;
                }
            }
            if (!this.stillValid) continue;
            this.names.add(name);
            this.data.add((NBTBase)base);
        }
    }

    public void printData() {
        LogHelper.info(this.names.toString());
        LogHelper.info(this.data.toString());
    }

    private int getInteger(Matcher matcher, String string) {
        try {
            return Integer.parseInt(matcher.group());
        }
        catch (Exception e) {
            LogHelper.warn("Invalid NBT path: " + string);
            this.stillValid = false;
            return 0;
        }
    }

    private long getLong(Matcher matcher, String string) {
        try {
            return Long.parseLong(matcher.group());
        }
        catch (Exception e) {
            LogHelper.warn("Invalid NBT path: " + string);
            this.stillValid = false;
            return 0L;
        }
    }

    private float getFloat(Matcher matcher, String string) {
        try {
            return Float.parseFloat(matcher.group());
        }
        catch (Exception e) {
            LogHelper.warn("Invalid NBT path: " + string);
            this.stillValid = false;
            return 0.0f;
        }
    }

    private double getDouble(Matcher matcher, String string) {
        try {
            return Double.parseDouble(matcher.group());
        }
        catch (Exception e) {
            LogHelper.warn("Invalid NBT path: " + string);
            this.stillValid = false;
            return 0.0;
        }
    }

    private byte[] getByteArray(Matcher matcher, String string) {
        try {
            int length = this.getInteger(matcher, string);
            ArrayList<Byte> bytes = new ArrayList<Byte>();
            for (int i = 0; i < length; ++i) {
                if (!matcher.find()) {
                    this.stillValid = false;
                    return new byte[0];
                }
                bytes.add((byte)this.getInteger(matcher, string));
            }
            return Bytes.toArray(bytes);
        }
        catch (Exception e) {
            LogHelper.warn("Invalid NBT path: " + string);
            this.stillValid = false;
            return new byte[0];
        }
    }

    private String getString(Matcher matcher, String string) {
        try {
            return matcher.group();
        }
        catch (Exception e) {
            LogHelper.warn("Invalid NBT path: " + string);
            this.stillValid = false;
            return "ERROR";
        }
    }

    private int[] getIntArray(Matcher matcher, String string) {
        try {
            int length = this.getInteger(matcher, string);
            ArrayList<Integer> integers = new ArrayList<Integer>();
            for (int i2 = 0; i2 < length; ++i2) {
                if (!matcher.find()) {
                    this.stillValid = false;
                    return new int[0];
                }
                integers.add(this.getInteger(matcher, string));
            }
            return integers.stream().mapToInt(i -> i).toArray();
        }
        catch (Exception e) {
            LogHelper.warn("Invalid NBT path: " + string);
            this.stillValid = false;
            return new int[0];
        }
    }

    public boolean isStillValid() {
        return this.stillValid;
    }

    public List<String> getNames() {
        return this.names;
    }

    public List<NBTBase> getData() {
        return this.data;
    }
}

