/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.core.handlers;

import com.m4thg33k.tombmanygraves.core.util.LogHelper;
import com.m4thg33k.tombmanygraves.lib.TombManyGravesConfigs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemBlackListHandler {
    private HashMap<String, Set<NBTTagCompound>> blacklistedData = new HashMap();

    public ItemBlackListHandler() {
        ArrayList<String> blacklistedStrings = TombManyGravesConfigs.BLACKLISTED_ITEMS_AS_STRINGS;
        for (String string : blacklistedStrings) {
            NBTTagCompound compound;
            String modName;
            block7: {
                int colon = string.indexOf(":");
                if (colon == -1) {
                    this.giveWarning(string);
                    continue;
                }
                modName = string.substring(0, colon);
                String remainder = string.substring(colon + 1, string.length());
                if (remainder.length() == 0) {
                    this.giveWarning(string);
                    continue;
                }
                compound = new NBTTagCompound();
                int meta = remainder.indexOf("#");
                if (meta != -1) {
                    String itemName = remainder.substring(0, meta);
                    try {
                        int metaVal = Integer.parseInt(remainder.substring(meta + 1, remainder.length()));
                        compound.func_74778_a("Name", itemName);
                        compound.func_74768_a("Meta", metaVal);
                        break block7;
                    }
                    catch (Exception e) {
                        this.giveWarning(string);
                        continue;
                    }
                }
                compound.func_74778_a("Name", remainder);
            }
            if (!this.blacklistedData.containsKey(modName)) {
                this.blacklistedData.put(modName, new HashSet());
            }
            this.blacklistedData.get(modName).add(compound);
        }
    }

    private void giveWarning(String string) {
        LogHelper.warn("The blacklisted item [" + string + "] is not properly formatted!");
    }

    public boolean isBlacklisted(ItemStack stack) {
        if (stack == null || stack.field_77994_a == 0) {
            return false;
        }
        String modName = stack.func_77973_b().getRegistryName().func_110624_b();
        if (!this.blacklistedData.containsKey(modName)) {
            return false;
        }
        for (NBTTagCompound compound : this.blacklistedData.get(modName)) {
            if (!compound.func_74779_i("Name").equals(stack.func_77973_b().getRegistryName().func_110623_a())) continue;
            if (!compound.func_74764_b("Meta")) {
                return true;
            }
            if (compound.func_74762_e("Meta") != stack.func_77952_i()) continue;
            return true;
        }
        return false;
    }
}

