/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.core.handlers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.m4thg33k.tombmanygraves.TombManyGraves;
import com.m4thg33k.tombmanygraves.core.handlers.Friends;
import com.m4thg33k.tombmanygraves.core.util.LogHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class FriendHandler {
    private static ArrayList<Friends> friendList;
    private static String FILE_PREFIX;
    private static String FILENAME;

    public static void importFriendLists() {
        BufferedReader reader = null;
        try {
            FriendHandler.checkFilePath();
            reader = new BufferedReader(new FileReader(TombManyGraves.file + FILE_PREFIX + FILENAME));
            Gson gson = new GsonBuilder().create();
            friendList = new ArrayList<Object>(Arrays.asList((Object[])gson.fromJson((Reader)reader, Friends[].class)));
            reader.close();
        }
        catch (Exception e) {
            LogHelper.error("");
            LogHelper.error("Got an error while importing Friends");
            FriendHandler.renameFile();
            friendList = null;
            friendList = new ArrayList();
        }
        FriendHandler.writeFriends();
    }

    public static void checkFilePath() {
        File file = new File(TombManyGraves.file + FILE_PREFIX);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static boolean hasAsFriend(UUID player1, UUID player2) {
        if (friendList != null) {
            for (Friends fList : friendList) {
                if (!fList.getOwner().equals(player1)) continue;
                return fList.isFriend(player2);
            }
            return false;
        }
        return false;
    }

    public static void writeFriends() {
        FriendHandler.checkFilePath();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (FileWriter file = new FileWriter(TombManyGraves.file + FILE_PREFIX + FILENAME);){
            file.write(gson.toJson(friendList));
            file.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void renameFile() {
        File newName;
        String filename_error = "/friends_ERROR";
        File oldName = new File(TombManyGraves.file + FILE_PREFIX + FILENAME);
        boolean success = oldName.renameTo(newName = new File(TombManyGraves.file + FILE_PREFIX + filename_error));
        if (!success) {
            LogHelper.error("Something is very wrong.");
        }
    }

    public static boolean hasFriendList(UUID playerID) {
        for (Friends friends : friendList) {
            if (!friends.getOwner().equals(playerID)) continue;
            return true;
        }
        return false;
    }

    public static void createFriendListFor(UUID playerID) {
        if (!FriendHandler.hasFriendList(playerID)) {
            friendList.add(new Friends(playerID));
            FriendHandler.writeFriends();
        }
    }

    public static Friends getFriendListFor(UUID playerID) {
        for (Friends friends : friendList) {
            if (!friends.getOwner().equals(playerID)) continue;
            return friends;
        }
        return null;
    }

    public static List<String> getFriendStringListFor(MinecraftServer server, UUID playerID) {
        ArrayList<UUID> friendIDs = FriendHandler.getFriendListFor(playerID).getFriends();
        ArrayList<String> friendNames = new ArrayList<String>();
        for (UUID id : friendIDs) {
            friendNames.add(server.func_152358_ax().func_152652_a(id).getName());
        }
        return friendNames;
    }

    @SubscribeEvent
    public void onPlayerJoin(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            FriendHandler.createFriendListFor(event.getEntity().func_110124_au());
        }
    }

    public static boolean addToFriendList(UUID owner, UUID friendToAdd) {
        for (Friends friends : friendList) {
            if (!friends.getOwner().equals(owner)) continue;
            boolean toReturn = friends.addFriend(friendToAdd);
            FriendHandler.writeFriends();
            return toReturn;
        }
        return false;
    }

    public static void printFriendList(MinecraftServer server, EntityPlayer player) {
        UUID playerID = player.func_110124_au();
        ArrayList<UUID> friends = FriendHandler.getFriendListFor(playerID).getFriends();
        if (friends.size() == 0) {
            player.func_145747_a((ITextComponent)new TextComponentString("You have not added any friends yet."));
            return;
        }
        for (UUID id : friends) {
            player.func_145747_a((ITextComponent)new TextComponentString(server.func_152358_ax().func_152652_a(id).getName()));
        }
    }

    public static boolean removeFriend(UUID ownerID, UUID friendID) {
        for (Friends friends : friendList) {
            if (!friends.getOwner().equals(ownerID)) continue;
            boolean toReturn = friends.removeFriend(friendID);
            FriendHandler.writeFriends();
            return toReturn;
        }
        return false;
    }

    public static void clearFriends(UUID owner) {
        for (Friends friends : friendList) {
            if (!friends.getOwner().equals(owner)) continue;
            friends.clearFriends();
            FriendHandler.writeFriends();
            return;
        }
    }

    public static boolean isFriendOf(UUID owner, UUID friend) {
        for (Friends friends : friendList) {
            if (!friends.getOwner().equals(owner)) continue;
            return friends.isFriend(friend);
        }
        return false;
    }

    static {
        FILE_PREFIX = "/TooManyGravesData/friendList";
        FILENAME = "/friends.json";
    }
}

