/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.core.handlers;

import baubles.api.BaublesApi;
import com.m4thg33k.tombmanygraves.TombManyGraves;
import com.m4thg33k.tombmanygraves.core.handlers.BaubleHandler;
import com.m4thg33k.tombmanygraves.core.handlers.DeathInventoryHandler;
import com.m4thg33k.tombmanygraves.core.util.ChatHelper;
import com.m4thg33k.tombmanygraves.items.ModItems;
import com.m4thg33k.tombmanygraves.lib.TombManyGravesConfigs;
import com.m4thg33k.tombmanygraves.tiles.TileDeathBlock;
import gr8pefish.ironbackpacks.capabilities.player.PlayerWearingBackpackCapabilities;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import lain.mods.cos.CosmeticArmorReworked;
import lain.mods.cos.inventory.InventoryCosArmor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thut.wearables.inventory.PlayerWearables;
import thut.wearables.inventory.WearableHandler;

public class DeathInventory {
    private NBTTagCompound allNBT = new NBTTagCompound();

    public DeathInventory(EntityPlayer player, BlockPos pos) {
        ItemStack pack;
        NBTTagList tagList = new NBTTagList();
        InventoryPlayer inventoryToWrite = TileDeathBlock.getInventorySansSoulbound(player.field_71071_by, false);
        if (TombManyGravesConfigs.ALLOW_MAIN_INVENTORY) {
            inventoryToWrite.func_70442_a(tagList);
        }
        this.allNBT.func_74782_a("Main", (NBTBase)tagList);
        NBTTagCompound baublesNBT = new NBTTagCompound();
        if (TombManyGraves.isBaublesInstalled && TombManyGravesConfigs.ALLOW_BAUBLES) {
            baublesNBT = TileDeathBlock.getBaublesNBTSansSoulbound(player, false);
        }
        this.allNBT.func_74782_a("Baubles", (NBTBase)baublesNBT);
        NBTTagCompound cosmeticNBT = new NBTTagCompound();
        if (TombManyGraves.isCosmeticArmorInstalled && TombManyGravesConfigs.ALLOW_COSMETIC_ARMOR) {
            cosmeticNBT = TileDeathBlock.getCosmeticNBTSansSoulbound(player, false);
        }
        this.allNBT.func_74782_a("Cosmetic", (NBTBase)cosmeticNBT);
        NBTTagCompound expandableBackpackNBT = new NBTTagCompound();
        if (TombManyGraves.isExpandableBackpacksInstalled && TombManyGravesConfigs.ALLOW_EXPANDABLE_BACKPACKS) {
            expandableBackpackNBT = TileDeathBlock.getExpandableBackpackNBTSansSoulbound(player, false);
        }
        this.allNBT.func_74782_a("ExpandableBackpack", (NBTBase)expandableBackpackNBT);
        NBTTagCompound eydamosBackpackNBT = new NBTTagCompound();
        if (TombManyGraves.isEydamosBackpacksInstalled && TombManyGravesConfigs.ALLOW_EYDAMOS_BACKPACKS) {
            eydamosBackpackNBT = TileDeathBlock.getEydamosBackpackNBTSansSoulbound(player, false);
        }
        this.allNBT.func_74782_a("EydamosBackpack", (NBTBase)eydamosBackpackNBT);
        NBTTagCompound thutNBT = new NBTTagCompound();
        if (TombManyGraves.isThutWearablesInstalled && TombManyGravesConfigs.ALLOW_THUT_WEARABLES) {
            thutNBT = TileDeathBlock.getThutNBTSansSoulbound(player, false);
        }
        this.allNBT.func_74782_a("ThutWearables", (NBTBase)thutNBT);
        NBTTagCompound ironBackpack = new NBTTagCompound();
        if (TombManyGraves.isIronBackpacksInstalled && TombManyGravesConfigs.ALLOW_IRON_BACKPACKS && (pack = PlayerWearingBackpackCapabilities.getEquippedBackpack((EntityLivingBase)player)) != null) {
            pack.func_77955_b(ironBackpack);
        }
        this.allNBT.func_74782_a("IronBackpacks", (NBTBase)ironBackpack);
        NBTTagCompound miscNBT = new NBTTagCompound();
        boolean flag = pos == null;
        miscNBT.func_74768_a("x", flag ? -1 : pos.func_177958_n());
        miscNBT.func_74768_a("y", flag ? -1 : pos.func_177956_o());
        miscNBT.func_74768_a("z", flag ? -1 : pos.func_177952_p());
        this.allNBT.func_74782_a("Misc", (NBTBase)miscNBT);
    }

    public static boolean writePortion(String fileName, String toWrite) {
        boolean didWork = true;
        try (FileWriter file = new FileWriter(fileName);){
            file.write(toWrite);
            file.close();
        }
        catch (Exception e) {
            didWork = false;
        }
        return didWork;
    }

    public String writeFile(EntityPlayer player) {
        String filename = "/" + player.func_70005_c_();
        String timeStamp = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date());
        String filePostfix = timeStamp + ".json";
        this.allNBT.func_74775_l("Misc").func_74778_a("Timestamp", timeStamp);
        String fullFileName = TombManyGraves.file + DeathInventoryHandler.FILE_PREFIX + filename + "#" + filePostfix;
        boolean didWork = DeathInventory.writePortion(TombManyGraves.file + DeathInventoryHandler.FILE_PREFIX + filename + "#" + filePostfix, this.allNBT.toString());
        if (didWork) {
            try {
                Path from = Paths.get(fullFileName, new String[0]);
                Path to = Paths.get(TombManyGraves.file + DeathInventoryHandler.FILE_PREFIX + filename + "#" + "latest.json", new String[0]);
                Files.copy(from, to, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return timeStamp;
        }
        return null;
    }

    public static void clearLatest(EntityPlayer player) {
        String filename = "/" + player.func_70005_c_();
        String timeStamp = "latest";
        String filePostfix = timeStamp + ".json";
        String fullFileName = TombManyGraves.file + DeathInventoryHandler.FILE_PREFIX + filename + "#" + filePostfix;
        DeathInventory.writePortion(fullFileName, "{}");
    }

    public boolean dropAll(EntityPlayer player, BlockPos position, String timestamp) {
        boolean didWork = true;
        String filename = TombManyGraves.file + DeathInventoryHandler.FILE_PREFIX + "/" + player.func_70005_c_() + "#" + timestamp + ".json";
        try {
            ItemStack pack;
            ItemStack stack;
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            String fileData = reader.readLine();
            this.allNBT = JsonToNBT.func_180713_a((String)fileData);
            InventoryPlayer inventoryPlayer = new InventoryPlayer(player);
            inventoryPlayer.func_70443_b(this.allNBT.func_150295_c("Main", 10));
            InventoryHelper.func_180175_a((World)player.field_70170_p, (BlockPos)position, (IInventory)inventoryPlayer);
            if (TombManyGraves.isBaublesInstalled) {
                IInventory inventoryBaubles = BaubleHandler.getSavedBaubles(this.allNBT.func_74775_l("Baubles"), BaublesApi.getBaublesHandler((EntityPlayer)player));
                InventoryHelper.func_180175_a((World)player.field_70170_p, (BlockPos)position, (IInventory)inventoryBaubles);
            }
            if (TombManyGraves.isCosmeticArmorInstalled) {
                InventoryCosArmor cosArmor = new InventoryCosArmor();
                cosArmor.readFromNBT(this.allNBT.func_74775_l("Cosmetic"));
                InventoryHelper.func_180175_a((World)player.field_70170_p, (BlockPos)position, (IInventory)cosArmor);
            }
            if (TombManyGraves.isExpandableBackpacksInstalled && (stack = ItemStack.func_77949_a((NBTTagCompound)this.allNBT.func_74775_l("ExpandableBackpack"))) != null && stack.field_77994_a > 0) {
                player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, (double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p(), stack));
            }
            if (TombManyGraves.isEydamosBackpacksInstalled && (stack = ItemStack.func_77949_a((NBTTagCompound)this.allNBT.func_74775_l("EydamosBackpack"))) != null && stack.field_77994_a > 0) {
                player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, (double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p(), stack));
            }
            if (TombManyGraves.isThutWearablesInstalled) {
                PlayerWearables playerWearables = new PlayerWearables();
                playerWearables.readFromNBT(this.allNBT.func_74775_l("ThutWearables"));
                InventoryHelper.func_180175_a((World)player.field_70170_p, (BlockPos)position, (IInventory)playerWearables);
            }
            if (TombManyGraves.isIronBackpacksInstalled && (pack = ItemStack.func_77949_a((NBTTagCompound)this.allNBT.func_74775_l("IronBackpacks"))) != null) {
                EntityItem item = new EntityItem(player.field_70170_p, (double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p(), pack);
                player.field_70170_p.func_72838_d((Entity)item);
            }
            reader.close();
        }
        catch (Exception e) {
            didWork = false;
        }
        return didWork;
    }

    public boolean restoreAll(EntityPlayer player, String timestamp) {
        boolean didWork = true;
        String filename = TombManyGraves.file + DeathInventoryHandler.FILE_PREFIX + "/" + player.func_70005_c_() + "#" + timestamp + ".json";
        try {
            ItemStack pack;
            ItemStack stack;
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            String fileData = reader.readLine();
            this.allNBT = JsonToNBT.func_180713_a((String)fileData);
            player.field_71071_by.func_70443_b(this.allNBT.func_150295_c("Main", 10));
            if (TombManyGraves.isBaublesInstalled) {
                BaubleHandler.setPlayerBaubles(player, this.allNBT.func_74775_l("Baubles"));
            }
            if (TombManyGraves.isCosmeticArmorInstalled) {
                InventoryCosArmor cosArmor = new InventoryCosArmor();
                cosArmor.readFromNBT(this.allNBT.func_74775_l("Cosmetic"));
                InventoryCosArmor playerCos = CosmeticArmorReworked.invMan.getCosArmorInventory(player.func_110124_au());
                for (int i = 0; i < playerCos.func_70302_i_(); ++i) {
                    playerCos.func_70299_a(i, cosArmor.func_70301_a(i));
                }
            }
            if (TombManyGraves.isExpandableBackpacksInstalled && (stack = ItemStack.func_77949_a((NBTTagCompound)this.allNBT.func_74775_l("ExpandableBackpack"))) != null && stack.field_77994_a > 0) {
                player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, stack));
            }
            if (TombManyGraves.isEydamosBackpacksInstalled && (stack = ItemStack.func_77949_a((NBTTagCompound)this.allNBT.func_74775_l("EydamosBackpack"))) != null && stack.field_77994_a > 0) {
                player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, stack));
            }
            if (TombManyGraves.isThutWearablesInstalled) {
                WearableHandler.getInstance().getPlayerData(player).func_174888_l();
                WearableHandler.getInstance().getPlayerData(player).readFromNBT(this.allNBT.func_74775_l("ThutWearables"));
            }
            if (TombManyGraves.isIronBackpacksInstalled && (pack = ItemStack.func_77949_a((NBTTagCompound)this.allNBT.func_74775_l("IronBackpacks"))) != null) {
                player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, pack));
            }
            reader.close();
        }
        catch (Exception e) {
            didWork = false;
        }
        return didWork;
    }

    public boolean getDeathList(EntityPlayer player, String playerName, String timestamp) {
        boolean didWork = true;
        String filename = TombManyGraves.file + DeathInventoryHandler.FILE_PREFIX + "/" + playerName + "#" + timestamp + ".json";
        try {
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            String fileData = reader.readLine();
            this.allNBT = JsonToNBT.func_180713_a((String)fileData);
            if (this.allNBT.func_150296_c().size() > 0) {
                ItemStack theList = new ItemStack((Item)ModItems.itemDeathList, 1);
                theList.func_77982_d(this.allNBT);
                EntityItem entityItem = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, theList);
                player.field_70170_p.func_72838_d((Entity)entityItem);
            } else {
                ChatHelper.sayMessage(player.field_70170_p, player, playerName + " had no items upon death!");
            }
            reader.close();
        }
        catch (Exception e) {
            didWork = false;
        }
        return didWork;
    }
}

