/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.core.handlers;

import baubles.api.BaublesApi;
import baubles.api.cap.BaublesContainer;
import baubles.api.cap.IBaublesItemHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class BaubleHandler {
    public static final String BAUBLES_NBT = "Items";

    public static NBTTagCompound getNBTFromInventory(IInventory inventory) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null) continue;
            NBTTagCompound slot = new NBTTagCompound();
            stack.func_77955_b(slot);
            slot.func_74768_a("Slot", i);
            list.func_74742_a((NBTBase)slot);
        }
        compound.func_74782_a(BAUBLES_NBT, (NBTBase)list);
        compound.func_74768_a("Size", inventory.func_70302_i_());
        return compound;
    }

    public static NBTTagCompound getBaubleNBT(EntityPlayer player) {
        IBaublesItemHandler iBaublesItemHandler = BaublesApi.getBaublesHandler((EntityPlayer)player);
        return BaubleHandler.getBaubleNBT(iBaublesItemHandler);
    }

    public static NBTTagCompound getBaubleNBT(IBaublesItemHandler baubles) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < baubles.getSlots(); ++i) {
            ItemStack stack = baubles.getStackInSlot(i);
            if (stack == null) continue;
            NBTTagCompound slot = new NBTTagCompound();
            stack.func_77955_b(slot);
            slot.func_74768_a("Slot", i);
            tagList.func_74742_a((NBTBase)slot);
        }
        compound.func_74782_a(BAUBLES_NBT, (NBTBase)tagList);
        compound.func_74768_a("Size", baubles.getSlots());
        return compound;
    }

    public static IInventory getSavedBaubles(NBTTagCompound compound) {
        return BaubleHandler.getSavedBaubles(compound, (IBaublesItemHandler)new BaublesContainer());
    }

    public static IInventory getSavedBaubles(NBTTagCompound compound, IBaublesItemHandler baubles) {
        InventoryBasic basic = new InventoryBasic("SavedBaubles", false, baubles.getSlots());
        NBTTagList tagList = compound.func_150295_c(BAUBLES_NBT, 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound slot = (NBTTagCompound)tagList.func_179238_g(i);
            basic.func_70299_a(slot.func_74762_e("Slot"), ItemStack.func_77949_a((NBTTagCompound)slot));
        }
        return basic;
    }

    public static IInventory getSavedBaubles(NBTTagCompound compound, EntityPlayer player) {
        return BaubleHandler.getSavedBaubles(compound, BaublesApi.getBaublesHandler((EntityPlayer)player));
    }

    public static IInventory getCurrentBaubles(IBaublesItemHandler baubles) {
        InventoryBasic basic = new InventoryBasic("CurrentBaubles", false, baubles.getSlots());
        for (int i = 0; i < basic.func_70302_i_(); ++i) {
            basic.func_70299_a(i, baubles.getStackInSlot(i));
        }
        return basic;
    }

    public static IInventory getCurrentBaubles(EntityPlayer player) {
        return BaubleHandler.getCurrentBaubles(BaublesApi.getBaublesHandler((EntityPlayer)player));
    }

    public static void setPlayerBaubles(EntityPlayer player, NBTTagCompound compound) {
        IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
        IInventory stored = BaubleHandler.getSavedBaubles(compound, baubles);
        for (int i = 0; i < baubles.getSlots(); ++i) {
            baubles.setStackInSlot(i, stored.func_70301_a(i));
        }
    }

    public static void setPlayerBaubles(EntityPlayer player, IInventory inventory) {
        IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            baubles.setStackInSlot(i, inventory.func_70301_a(i));
        }
    }

    public static void clearBaubles(EntityPlayer player) {
        IBaublesItemHandler handler = BaublesApi.getBaublesHandler((EntityPlayer)player);
        for (int i = 0; i < handler.getSlots(); ++i) {
            handler.setStackInSlot(i, null);
        }
    }

    public static int getNumSlots() {
        return new BaublesContainer().getSlots();
    }
}

