/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.core.events;

import com.m4thg33k.tombmanygraves.blocks.ModBlocks;
import com.m4thg33k.tombmanygraves.lib.TombManyGravesConfigs;
import com.m4thg33k.tombmanygraves.tiles.TileDeathBlock;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class TombManyGravesRenderEventHandler {
    private static TombManyGravesRenderEventHandler INSTANCE;
    public Minecraft mc = Minecraft.func_71410_x();

    public TombManyGravesRenderEventHandler() {
        INSTANCE = this;
    }

    @SubscribeEvent
    public void onBlockHilight(DrawBlockHighlightEvent event) {
        TileEntity tileEntity;
        WorldClient world;
        IBlockState state;
        if (!TombManyGravesConfigs.DISPLAY_GRAVE_NAME) {
            return;
        }
        RayTraceResult trace = event.getTarget();
        if (trace != null && trace.field_72313_a == RayTraceResult.Type.BLOCK && (state = (world = this.mc.field_71441_e).func_180495_p(trace.func_178782_a())).func_177230_c() == ModBlocks.blockDeath && (tileEntity = world.func_175625_s(trace.func_178782_a())) != null && tileEntity instanceof TileDeathBlock) {
            String name = ((TileDeathBlock)tileEntity).getPlayerName();
            boolean giveGravePriority = ((TileDeathBlock)tileEntity).areGraveItemsForced();
            this.renderPlayerName(trace.func_178782_a(), event.getPartialTicks(), name, giveGravePriority);
        }
    }

    private void renderPlayerName(BlockPos pos, float partialTicks, String name, boolean giveGravePriority) {
        if (!name.equals("") && name.length() > 0) {
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            this.renderPlayerName(name, (EntityPlayer)this.mc.field_71439_g, pos, partialTicks, giveGravePriority);
        }
    }

    private void renderPlayerName(String name, EntityPlayer player, BlockPos pos, float partialTicks, boolean giveGravePriority) {
        double x = pos.func_177958_n();
        double y = pos.func_177956_o();
        double z = pos.func_177952_p();
        double dx = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double dy = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double dz = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        float angleH = player.field_70759_as;
        float angleV = 0.0f;
        this.renderLabel(name, x - dx, y - dy, z - dz, angleH, angleV, giveGravePriority);
        if (giveGravePriority) {
            this.renderLabel("swap", x - dx, y - dy - 0.25, z - dz, angleH, angleV, giveGravePriority);
        }
    }

    protected void renderLabel(String name, double x, double y, double z, float angleH, float angleV, boolean giveGravePriority) {
        FontRenderer fontRenderer = this.mc.field_71466_p;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-angleH), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-angleV), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-0.025f, (float)-0.025f, (float)0.025f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexBuffer = tessellator.func_178180_c();
        int strLenHalved = fontRenderer.func_78256_a(name) / 2;
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexBuffer.func_181662_b((double)(-strLenHalved - 1), -1.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        vertexBuffer.func_181662_b((double)(-strLenHalved - 1), 8.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        vertexBuffer.func_181662_b((double)(strLenHalved + 1), 8.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        vertexBuffer.func_181662_b((double)(strLenHalved + 1), -1.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        fontRenderer.func_78276_b(name, -strLenHalved, 0, giveGravePriority ? -1 : 0x20FFFFFF);
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
        fontRenderer.func_78276_b(name, -strLenHalved, 0, giveGravePriority ? 0xFFFFFF : -7929856);
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }
}

