/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.core.events;

import com.m4thg33k.tombmanygraves.blocks.ModBlocks;
import com.m4thg33k.tombmanygraves.core.handlers.DeathInventory;
import com.m4thg33k.tombmanygraves.core.handlers.DeathInventoryHandler;
import com.m4thg33k.tombmanygraves.core.util.ChatHelper;
import com.m4thg33k.tombmanygraves.core.util.LogHelper;
import com.m4thg33k.tombmanygraves.items.ModItems;
import com.m4thg33k.tombmanygraves.lib.TombManyGravesConfigs;
import com.m4thg33k.tombmanygraves.tiles.TileDeathBlock;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class TombManyGravesCommonEvents {
    private static final int MAX_RADIUS = TombManyGravesConfigs.GRAVE_RANGE;
    private static final boolean VOID_SEARCH_1 = TombManyGravesConfigs.VOID_SEARCH_1;

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerDeath(LivingDeathEvent event) {
        EntityPlayer player;
        if (TombManyGravesConfigs.PRINT_DEATH_LOG && event.getEntityLiving() instanceof EntityPlayer && !event.getEntityLiving().func_130014_f_().field_72995_K) {
            player = (EntityPlayer)event.getEntityLiving();
            BlockPos pos = player.func_180425_c();
            LogHelper.info(player.func_70005_c_() + " died in dimension " + player.field_71093_bK + " at (x,y,z) = (" + pos.func_177958_n() + "," + pos.func_177956_o() + "," + pos.func_177952_p() + ")." + (TombManyGravesConfigs.ENABLE_GRAVES ? " Their grave may be near!" : ""));
        }
        if (!event.getEntityLiving().field_70170_p.func_82736_K().func_82766_b("keepInventory") && event.getEntityLiving() instanceof EntityPlayer && !((EntityPlayer)event.getEntityLiving()).field_70170_p.field_72995_K) {
            if (TombManyGravesConfigs.ENABLE_GRAVES) {
                player = (EntityPlayer)event.getEntityLiving();
                if (!TileDeathBlock.isInventoryEmpty(player)) {
                    IBlockState state = ModBlocks.blockDeath.func_176223_P();
                    BlockPos posToPlace = new BlockPos(0, -1, 0);
                    if (TombManyGravesConfigs.ASCEND_LIQUID) {
                        posToPlace = this.findValidLocation(player.field_70170_p, this.ascendFromFluid(player.field_70170_p, player.func_180425_c()));
                    }
                    if (posToPlace.func_177956_o() == -1) {
                        posToPlace = this.findValidLocation(player.field_70170_p, player.func_180425_c());
                    }
                    String timestamp = DeathInventoryHandler.createDeathInventory(player, posToPlace);
                    if (posToPlace.func_177956_o() != -1) {
                        ChatHelper.sayMessage(player.field_70170_p, player, "Place of death (x,y,z) = (" + posToPlace.func_177958_n() + "," + posToPlace.func_177956_o() + "," + posToPlace.func_177952_p() + ")");
                        player.field_70170_p.func_175656_a(posToPlace, state);
                        TileEntity tileEntity = player.field_70170_p.func_175625_s(posToPlace);
                        if (tileEntity != null && tileEntity instanceof TileDeathBlock) {
                            ((TileDeathBlock)tileEntity).grabPlayer(player);
                            IBlockState state1 = this.getBlockBelow(player.field_70170_p, posToPlace);
                            if (state1.func_185904_a() == Material.field_151579_a) {
                                state1 = ModBlocks.blockDeath.func_176223_P();
                            } else if (state1.func_185904_a() == Material.field_151577_b) {
                                state1 = Blocks.field_150346_d.func_176223_P();
                            }
                            ((TileDeathBlock)tileEntity).setCamoState(state1);
                            ((TileDeathBlock)tileEntity).setTimeStamp(timestamp);
                        } else {
                            LogHelper.info("Error! Death block tile not found!");
                        }
                    } else {
                        ChatHelper.sayMessage(player.field_70170_p, player, "Could not find suitable grave location.");
                    }
                } else {
                    ChatHelper.sayMessage(player.field_70170_p, player, "Place of death (x,y,z) = (" + (int)player.field_70165_t + "," + (int)player.field_70163_u + "," + (int)player.field_70161_v + ")");
                    ChatHelper.sayMessage(player.field_70170_p, player, "(But your inventory was empty)");
                    DeathInventory.clearLatest((EntityPlayer)event.getEntityLiving());
                }
            } else {
                DeathInventoryHandler.createDeathInventory((EntityPlayer)event.getEntityLiving(), ((EntityPlayer)event.getEntityLiving()).func_180425_c());
            }
        }
    }

    private BlockPos findValidLocation(World world, BlockPos pos) {
        BlockPos toReturn = new BlockPos(-1, -1, -1);
        BlockPos toCheck = pos.func_177982_a(0, 0, 0);
        if (toCheck.func_177956_o() <= 0) {
            toCheck = toCheck.func_177982_a(0, MathHelper.func_76130_a((int)toCheck.func_177956_o()) + (VOID_SEARCH_1 ? 1 : MAX_RADIUS), 0);
        }
        for (int r = 0; r <= MAX_RADIUS; ++r) {
            toReturn = this.checkLevel(world, toCheck, r, false);
            if (toReturn.func_177956_o() == -1) continue;
            return toReturn;
        }
        return toReturn;
    }

    private BlockPos ascendFromFluid(World world, BlockPos pos) {
        BlockPos toCheck = pos.func_177982_a(0, 0, 0);
        int height = 0;
        while (pos.func_177956_o() + height < world.func_72940_L() - TombManyGravesConfigs.GRAVE_RANGE && !this.isValidLocation(world, toCheck, true)) {
            int temp = pos.func_177956_o() + height;
            int temp2 = world.func_72940_L();
            toCheck = this.checkLevel(world, pos.func_177982_a(0, height, 0), 1, true);
            ++height;
        }
        return toCheck;
    }

    private BlockPos checkLevel(World world, BlockPos pos, int radius, boolean ignoreFluidConfigs) {
        if (radius == 0 && this.isValidLocation(world, pos, ignoreFluidConfigs)) {
            return pos;
        }
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = radius; k >= -radius; --k) {
                    if (MathHelper.func_76130_a((int)i) != radius && MathHelper.func_76130_a((int)j) != radius && MathHelper.func_76130_a((int)k) != radius || !this.isValidLocation(world, pos.func_177982_a(i, j, k), ignoreFluidConfigs)) continue;
                    return pos.func_177982_a(i, j, k);
                }
            }
        }
        return new BlockPos(-1, -1, -1);
    }

    private boolean isValidLocation(World world, BlockPos pos, boolean ignoreFluidConfigs) {
        if (pos.func_177956_o() < 0 || pos.func_177956_o() >= world.func_72940_L()) {
            return false;
        }
        Block theBlock = world.func_180495_p(pos).func_177230_c();
        if (world.func_175623_d(pos)) {
            return true;
        }
        if (!ignoreFluidConfigs) {
            if (TombManyGravesConfigs.ALLOW_GRAVES_IN_LAVA && theBlock == Blocks.field_150353_l) {
                return true;
            }
            if (TombManyGravesConfigs.ALLOW_GRAVES_IN_FLOWING_LAVA && theBlock == Blocks.field_150356_k) {
                return true;
            }
            if (TombManyGravesConfigs.ALLOW_GRAVES_IN_WATER && theBlock == Blocks.field_150355_j) {
                return true;
            }
            if (TombManyGravesConfigs.ALLOW_GRAVES_IN_FLOWING_WATER && theBlock == Blocks.field_150358_i) {
                return true;
            }
        }
        return TombManyGravesConfigs.ALLOW_GRAVES_ON_PLANTS && theBlock instanceof IPlantable;
    }

    private IBlockState getBlockBelow(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177982_a(0, -1, 0));
    }

    @SubscribeEvent
    public void itemToss(ItemTossEvent event) {
        if (event.isCanceled()) {
            return;
        }
        EntityItem entityItem = event.getEntityItem();
        Item item = entityItem.func_92059_d().func_77973_b();
        if (item == Item.func_150898_a((Block)ModBlocks.blockDeath) || item == ModItems.itemDeathList) {
            entityItem.func_70106_y();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void itemDrop(PlayerDropsEvent event) {
        List items = event.getDrops();
        for (EntityItem item : items) {
            if (item.func_92059_d().func_77973_b() != ModItems.itemDeathList && item.func_92059_d().func_77973_b() != Item.func_150898_a((Block)ModBlocks.blockDeath)) continue;
            item.func_70106_y();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerClone(PlayerEvent.Clone event) {
        if (TombManyGravesConfigs.ALLOW_INVENTORY_LISTS && !event.isCanceled() && !event.getEntityLiving().field_70170_p.func_82736_K().func_82766_b("keepInventory") && TombManyGravesConfigs.ALLOW_INVENTORY_SAVES && !event.getEntityLiving().field_70170_p.field_72995_K && event.isWasDeath()) {
            DeathInventoryHandler.getDeathList(event.getEntityPlayer(), event.getEntityPlayer().func_70005_c_(), "latest");
        }
    }
}

