/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.core.commands;

import com.m4thg33k.tombmanygraves.core.handlers.DeathInventoryHandler;
import com.m4thg33k.tombmanygraves.lib.TombManyGravesConfigs;
import com.m4thg33k.tombmanygraves.tiles.TileDeathBlock;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class CommandLoot
implements ICommand {
    public final String COMMAND_NAME = "tmg_loot";
    private final List<String> aliases = new ArrayList<String>();

    public String func_71517_b() {
        return "tmg_loot";
    }

    public String func_71518_a(ICommandSender sender) {
        return "tmg_loot: <player to give items to> [player who owns grave if different] <x> <y> <z>";
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (sender.func_130014_f_().field_72995_K) {
            return;
        }
        if (!TombManyGravesConfigs.ALLOW_INVENTORY_SAVES) {
            sender.func_145747_a((ITextComponent)new TextComponentString("This command has been disabled"));
            return;
        }
        if (args.length < 4 || args.length > 5) {
            sender.func_145747_a((ITextComponent)new TextComponentString(this.func_71518_a(sender)));
            return;
        }
        boolean worked = false;
        EntityPlayerMP toGive = server.func_184103_al().func_152612_a(args[0]);
        if (toGive != null) {
            int z;
            int y;
            int x;
            EntityPlayerMP owner;
            try {
                if (args.length == 4) {
                    owner = toGive;
                    x = Integer.parseInt(args[1]);
                    y = Integer.parseInt(args[2]);
                    z = Integer.parseInt(args[3]);
                } else {
                    owner = server.func_184103_al().func_152612_a(args[1]);
                    x = Integer.parseInt(args[2]);
                    y = Integer.parseInt(args[3]);
                    z = Integer.parseInt(args[4]);
                }
            }
            catch (Exception e) {
                sender.func_145747_a((ITextComponent)new TextComponentString(this.func_71518_a(sender)));
                return;
            }
            BlockPos location = new BlockPos(x, y, z);
            TileEntity tileEntity = sender.func_130014_f_().func_175625_s(location);
            if (tileEntity == null || !(tileEntity instanceof TileDeathBlock)) {
                sender.func_145747_a((ITextComponent)new TextComponentString("There is not a grave at that location."));
                return;
            }
            String timestamp = ((TileDeathBlock)tileEntity).getTimestamp();
            if (timestamp == null || timestamp.equals("")) {
                sender.func_145747_a((ITextComponent)new TextComponentString("The grave was created before this feature was implemented. Sorry. ;_;"));
                return;
            }
            if (owner != null) {
                worked = DeathInventoryHandler.dropPlayerInventory((EntityPlayer)owner, toGive.func_180425_c(), timestamp);
            }
            if (worked) {
                ((TileDeathBlock)tileEntity).clearInventory();
                sender.func_130014_f_().func_175698_g(location);
            }
        }
        if (!worked) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Failed to drop inventory."));
            sender.func_145747_a((ITextComponent)new TextComponentString("Check spelling and block location."));
        }
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender.func_70003_b(this.getRequiredPermissionLevel(), this.func_71517_b());
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        return args.length == 1 || args.length == 2 ? CommandBase.func_71530_a((String[])args, (String[])server.func_71213_z()) : null;
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 0 || index == 1;
    }

    public int compareTo(ICommand o) {
        return this.func_71517_b().compareTo(o.func_71517_b());
    }

    public int getRequiredPermissionLevel() {
        return 4;
    }
}

