/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.client.render.models;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.init.Blocks;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class ModelHelper {
    public static OBJModel loadModel(String suffix) {
        try {
            OBJModel model = (OBJModel)OBJLoader.INSTANCE.loadModel(new ResourceLocation("tombmanygraves:models/block/" + suffix + ".obj"));
            return model;
        }
        catch (Exception e) {
            throw new ReportedException(new CrashReport("Error making the model for " + suffix + "!", (Throwable)e));
        }
    }

    public static IModel retexture(OBJModel model, String toReplace, String suffix) {
        return ((OBJModel)model.retexture(ImmutableMap.of((Object)toReplace, (Object)("tombmanygraves:blocks/" + suffix)))).process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
    }

    public static IModel retexture(OBJModel model, ImmutableMap<String, String> map) {
        return ((OBJModel)model.retexture(map)).process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
    }

    public static IBakedModel bake(IModel model) {
        return model.bake((IModelState)TRSRTransformation.identity(), Attributes.DEFAULT_BAKED_FORMAT, ModelLoader.defaultTextureGetter());
    }

    public static void renderModel(IBakedModel model, int color) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        List quads = model.func_188616_a(null, null, 0L);
        for (BakedQuad quad : quads) {
            LightUtil.renderQuadColor((VertexBuffer)buffer, (BakedQuad)quad, (int)color);
        }
        tessellator.func_78381_a();
    }

    public static TextureAtlasSprite getTextureFromBlockstate(IBlockState state) {
        if (state == null) {
            state = Blocks.field_150346_d.func_176223_P();
        }
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
        return sprite;
    }
}

