/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.client.render.models;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.m4thg33k.tombmanygraves.api.state.TMGStateProps;
import com.m4thg33k.tombmanygraves.blocks.BlockDeath;
import com.m4thg33k.tombmanygraves.blocks.ModBlocks;
import com.m4thg33k.tombmanygraves.client.render.models.ModelHelper;
import com.m4thg33k.tombmanygraves.lib.TombManyGravesConfigs;
import com.m4thg33k.tombmanygraves.tiles.TileDeathBlock;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;

public class GoodGraveModel
implements IBakedModel {
    private final IBakedModel standard;
    private final IRetexturableModel retexturableModel;
    private final Map<String, IBakedModel> cache = Maps.newHashMap();

    public GoodGraveModel(IBakedModel standard, IRetexturableModel retexturableModel) {
        this.standard = standard;
        this.retexturableModel = retexturableModel;
    }

    protected IBakedModel getActualModel(String texture) {
        IBakedModel bakedModel = this.standard;
        if (texture != null) {
            if (this.cache.containsKey(texture)) {
                bakedModel = this.cache.get(texture);
            } else if (this.retexturableModel != null) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                builder.put((Object)"bottom", (Object)texture);
                builder.put((Object)"top", (Object)texture);
                builder.put((Object)"side", (Object)texture);
                IModel retexturedModel = this.retexturableModel.retexture(builder.build());
                bakedModel = retexturedModel.bake((IModelState)TRSRTransformation.identity(), Attributes.DEFAULT_BAKED_FORMAT, ModelLoader.defaultTextureGetter());
                this.cache.put(texture, bakedModel);
            }
        }
        return bakedModel;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, @Nullable EnumFacing side, long rand) {
        if (state.func_177230_c() != ModBlocks.blockDeath) {
            return this.standard.func_188616_a(state, side, rand);
        }
        BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
        IBlockState heldState = (IBlockState)((IExtendedBlockState)state).getValue(TMGStateProps.HELD_STATE);
        IBlockAccess heldWorld = (IBlockAccess)((IExtendedBlockState)state).getValue(TMGStateProps.HELD_WORLD);
        BlockPos heldPos = (BlockPos)((IExtendedBlockState)state).getValue(TMGStateProps.HELD_POS);
        if (heldWorld == null || heldPos == null) {
            return ImmutableList.of();
        }
        if (heldState == null || heldState.func_177230_c() instanceof BlockDeath) {
            return ImmutableList.of();
        }
        if (TombManyGravesConfigs.FORCE_DIRT_RENDER || heldState.func_177230_c() == Blocks.field_150350_a || !heldState.func_177230_c().canRenderInLayer(heldState, layer) || heldState.func_177230_c().hasTileEntity(heldState)) {
            IBlockState dirtState = Blocks.field_150346_d.func_176223_P();
            return this.getActualModel(ModelHelper.getTextureFromBlockstate(dirtState).func_94215_i()).func_188616_a(dirtState, side, rand);
        }
        IBlockState actualState = heldState.func_177230_c().func_176221_a(heldState, (IBlockAccess)new FakeBlockAccess(heldWorld), heldPos);
        IBakedModel model = this.getActualModel(ModelHelper.getTextureFromBlockstate(actualState).func_94215_i());
        return model.func_188616_a(actualState, side, rand);
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return Minecraft.func_71410_x().func_147117_R().func_110572_b("tombmanygraves:blocks/BlockDeath");
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    private static class FakeBlockAccess
    implements IBlockAccess {
        private final IBlockAccess compose;

        private FakeBlockAccess(IBlockAccess compose) {
            this.compose = compose;
        }

        @Nullable
        public TileEntity func_175625_s(BlockPos pos) {
            return this.compose.func_175625_s(pos);
        }

        public int func_175626_b(BlockPos pos, int lightValue) {
            return 0xF000F0;
        }

        public IBlockState func_180495_p(BlockPos pos) {
            IBlockState state = this.compose.func_180495_p(pos);
            if (state.func_177230_c() instanceof BlockDeath) {
                state = ((TileDeathBlock)this.compose.func_175625_s(pos)).getCamoState();
            }
            return state == null ? Blocks.field_150350_a.func_176223_P() : state;
        }

        public boolean func_175623_d(BlockPos pos) {
            return this.compose.func_175623_d(pos);
        }

        public Biome func_180494_b(BlockPos pos) {
            return this.compose.func_180494_b(pos);
        }

        public int func_175627_a(BlockPos pos, EnumFacing direction) {
            return this.compose.func_175627_a(pos, direction);
        }

        public WorldType func_175624_G() {
            return this.compose.func_175624_G();
        }

        public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
            return this.compose.isSideSolid(pos, side, _default);
        }
    }
}

