/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.client.gui;

import com.m4thg33k.tombmanygraves.client.gui.GuiDeathItems;
import org.lwjgl.input.Mouse;

public class Scrollbar {
    private boolean canScroll = true;
    private int x;
    private int y;
    private int scrollbarWidth;
    private int scrollbarHeight;
    private float scrollDelta = 15.0f;
    private float currentScroll;
    private boolean wasClicking = false;
    private boolean isScrolling = false;

    public Scrollbar(int x, int y, int scrollbarWidth, int scrollbarHeight) {
        this.x = x;
        this.y = y;
        this.scrollbarWidth = scrollbarWidth;
        this.scrollbarHeight = scrollbarHeight;
    }

    public int getScrollbarWidth() {
        return this.scrollbarWidth;
    }

    public int getScrollbarHeight() {
        return this.scrollbarHeight;
    }

    public void setCanScroll(boolean canScroll) {
        this.canScroll = canScroll;
    }

    public boolean canScroll() {
        return this.canScroll;
    }

    public float getCurrentScroll() {
        return this.currentScroll;
    }

    public void setCurrentScroll(float newCurrentScroll) {
        int scrollbarItselfHeight;
        int max;
        if (newCurrentScroll < 0.0f) {
            newCurrentScroll = 0.0f;
        }
        if (newCurrentScroll > (float)(max = this.scrollbarHeight - (scrollbarItselfHeight = 12) - 3)) {
            newCurrentScroll = max;
        }
        this.currentScroll = newCurrentScroll;
    }

    public void setScrollDelta(float delta) {
        this.scrollDelta = delta;
    }

    public void draw(GuiDeathItems gui) {
        gui.bindTexture("icons.png");
        gui.drawTexture(gui.getGuiLeft() + this.x, gui.getGuiTop() + this.y + (int)this.currentScroll, this.canScroll() ? 0 : 12, 0, 12, 15);
    }

    public void update(GuiDeathItems gui, int mouseX, int mouseY) {
        if (!this.canScroll()) {
            this.isScrolling = false;
            this.wasClicking = false;
            this.currentScroll = 0.0f;
        } else {
            int wheel = Mouse.getDWheel();
            if ((wheel = Math.max(Math.min(-wheel, 1), -1)) == -1) {
                this.setCurrentScroll(this.currentScroll - this.scrollDelta);
            } else if (wheel == 1) {
                this.setCurrentScroll(this.currentScroll + this.scrollDelta);
            }
            boolean down = Mouse.isButtonDown((int)0);
            if (!this.wasClicking && down && gui.inBounds(this.x, this.y, this.scrollbarWidth, this.scrollbarHeight, mouseX, mouseY)) {
                this.isScrolling = true;
            }
            if (!down) {
                this.isScrolling = false;
            }
            this.wasClicking = down;
            if (this.isScrolling) {
                this.setCurrentScroll(mouseY - gui.getGuiTop());
            }
        }
    }
}

