/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.client.gui;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import com.m4thg33k.tombmanygraves.TombManyGraves;
import com.m4thg33k.tombmanygraves.client.gui.Scrollbar;
import com.m4thg33k.tombmanygraves.core.handlers.BaubleHandler;
import de.eydamos.backpack.data.BackpackSave;
import gr8pefish.ironbackpacks.container.backpack.InventoryBackpack;
import gr8pefish.ironbackpacks.items.backpacks.ItemBackpack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lain.mods.cos.inventory.InventoryCosArmor;
import lellson.expandablebackpack.inventory.iinventory.BackpackInventory;
import lellson.expandablebackpack.item.backpack.Backpack;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import thut.wearables.inventory.PlayerWearables;

public class GuiDeathItems
extends GuiScreen {
    private EntityPlayer player;
    private ItemStack deathList;
    private List<String> header;
    private List<String> mainItems;
    private List<String> baubleItems;
    private List<String> cosmeticItems;
    private List<String> expandableBackpackItems;
    private List<String> eydamosBackpackItems;
    private List<String> thutItems;
    private List<String> ironBackpackItems;
    private Scrollbar scrollbar;
    private int xSize;
    private int ySize;
    private static String MAIN = "Main Inventory";
    private static String BAUBLES = "Baubles";
    private static String COSMETIC = "Cosmetic Armor";
    private static String EXPANDABLE = "Expandable Backpack";
    private static String EYDAMOS = "Eydamos Backpack";
    private static String THUT = "Thut Wearables";
    private static String IRON = "Iron Backpack";
    private static String LINE = "-----------------------------";
    private static String EOF = "END OF FILE";
    private static List<String> END_OF_FILE;

    public GuiDeathItems(EntityPlayer player, ItemStack deathList) {
        this.player = player;
        this.deathList = deathList.func_77946_l();
        this.createHeader();
        this.createListOfItemsInMainInventory();
        this.createListOfItemsInBaublesInventory();
        this.createListOfItemsInCosmeticInventory();
        this.createListOfItemsInExpandableBackpack();
        this.createListOfItemsInEydamosBackpack();
        this.createListOfItemsInThut();
        this.createListOfItemsInIronBackpack();
        END_OF_FILE = new ArrayList<String>();
        END_OF_FILE.add(LINE);
        END_OF_FILE.add(EOF);
        END_OF_FILE.add(LINE);
        this.xSize = 200;
        this.ySize = 150;
        this.scrollbar = new Scrollbar(this.xSize - 12, 0, 12, this.ySize);
        this.scrollbar.setScrollDelta(1.0f);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.bindTexture("DeathListBackground.png");
        this.drawTexture(this.getGuiLeft(), this.getGuiTop(), 0, 0, this.xSize, this.ySize);
        this.scrollbar.update(this, mouseX, mouseY);
        this.scrollbar.draw(this);
        int endHeight = this.drawHeader();
        endHeight = this.drawMainItems(endHeight);
        endHeight = this.drawBaubleItems(endHeight);
        endHeight = this.drawCosmeticItems(endHeight);
        endHeight = this.drawExpandableBackpackItems(endHeight);
        endHeight = this.drawEydamosBackpackItems(endHeight);
        endHeight = this.drawThutItems(endHeight);
        endHeight = this.drawIronBackpackItems(endHeight);
        this.drawEOF(endHeight);
    }

    public boolean func_73868_f() {
        return false;
    }

    private int drawHeader() {
        int height = 0;
        int gLeft = this.getGuiLeft();
        int gTop = this.getGuiTop();
        int counter = 0;
        for (int i = 0; i < this.header.size(); ++i) {
            height = 10 * i + (int)this.scrollbar.getCurrentScroll() * -10 + 10;
            ++counter;
            if (height < 4 || height >= this.ySize - 12) continue;
            this.field_146289_q.func_78276_b(this.header.get(i), gLeft + 12, gTop + height, 0);
        }
        return counter * 10;
    }

    private int drawMainItems(int startHeight) {
        int gLeft = this.getGuiLeft();
        int gTop = this.getGuiTop();
        int counter = 0;
        for (int i = 0; i < this.mainItems.size(); ++i) {
            int height = startHeight + 10 * i + (int)this.scrollbar.getCurrentScroll() * -10 + 10;
            ++counter;
            if (height < 4 || height >= this.ySize - 12) continue;
            this.field_146289_q.func_78276_b(this.mainItems.get(i), gLeft + 12, gTop + height, 0);
        }
        return startHeight + counter * 10;
    }

    private int drawBaubleItems(int startHeight) {
        if (this.baubleItems.size() < 4) {
            return startHeight;
        }
        int gLeft = this.getGuiLeft();
        int gTop = this.getGuiTop();
        int counter = 0;
        for (int i = 0; i < this.baubleItems.size(); ++i) {
            int height = startHeight + 10 * i + (int)this.scrollbar.getCurrentScroll() * -10 + 10;
            ++counter;
            if (height < 4 || height >= this.ySize - 12) continue;
            this.field_146289_q.func_78276_b(this.baubleItems.get(i), gLeft + 12, gTop + height, 0);
        }
        return startHeight + counter * 10;
    }

    private int drawCosmeticItems(int startHeight) {
        if (this.cosmeticItems.size() < 4) {
            return startHeight;
        }
        int gLeft = this.getGuiLeft();
        int gTop = this.getGuiTop();
        int counter = 0;
        for (int i = 0; i < this.cosmeticItems.size(); ++i) {
            int height = startHeight + 10 * i + (int)this.scrollbar.getCurrentScroll() * -10 + 10;
            ++counter;
            if (height < 4 || height >= this.ySize - 12) continue;
            this.field_146289_q.func_78276_b(this.cosmeticItems.get(i), gLeft + 12, gTop + height, 0);
        }
        return startHeight + counter * 10;
    }

    private int drawExpandableBackpackItems(int startHeight) {
        if (this.expandableBackpackItems.size() < 4) {
            return startHeight;
        }
        int gLeft = this.getGuiLeft();
        int gTop = this.getGuiTop();
        int counter = 0;
        for (int i = 0; i < this.expandableBackpackItems.size(); ++i) {
            int height = startHeight + 10 * i + (int)this.scrollbar.getCurrentScroll() * -10 + 10;
            ++counter;
            if (height < 4 || height >= this.ySize - 12) continue;
            this.field_146289_q.func_78276_b(this.expandableBackpackItems.get(i), gLeft + 12, gTop + height, 0);
        }
        return startHeight + counter * 10;
    }

    private int drawEydamosBackpackItems(int startHeight) {
        if (this.eydamosBackpackItems.size() < 4) {
            return startHeight;
        }
        int gLeft = this.getGuiLeft();
        int gTop = this.getGuiTop();
        int counter = 0;
        for (int i = 0; i < this.eydamosBackpackItems.size(); ++i) {
            int height = startHeight + 10 * i + (int)this.scrollbar.getCurrentScroll() * -10 + 10;
            ++counter;
            if (height < 4 || height >= this.ySize - 12) continue;
            this.field_146289_q.func_78276_b(this.eydamosBackpackItems.get(i), gLeft + 12, gTop + height, 0);
        }
        return startHeight + counter * 10;
    }

    private int drawThutItems(int startHeight) {
        if (this.thutItems.size() < 4) {
            return startHeight;
        }
        int gLeft = this.getGuiLeft();
        int gTop = this.getGuiTop();
        int counter = 0;
        for (int i = 0; i < this.thutItems.size(); ++i) {
            int height = startHeight + 10 * i + (int)this.scrollbar.getCurrentScroll() * -10 + 10;
            ++counter;
            if (height < 4 || height >= this.ySize - 12) continue;
            this.field_146289_q.func_78276_b(this.thutItems.get(i), gLeft + 12, gTop + height, 0);
        }
        return startHeight + counter * 10;
    }

    private int drawIronBackpackItems(int startHeight) {
        if (this.ironBackpackItems.size() < 4) {
            return startHeight;
        }
        int gLeft = this.getGuiLeft();
        int gTop = this.getGuiTop();
        int counter = 0;
        for (int i = 0; i < this.ironBackpackItems.size(); ++i) {
            int height = startHeight + 10 * i + (int)this.scrollbar.getCurrentScroll() * -10 + 10;
            ++counter;
            if (height < 4 || height >= this.ySize - 12) continue;
            this.field_146289_q.func_78276_b(this.ironBackpackItems.get(i), gLeft + 12, gTop + height, 0);
        }
        return startHeight + counter * 10;
    }

    private void drawEOF(int startHeight) {
        int gLeft = this.getGuiLeft();
        int gTop = this.getGuiTop();
        for (int i = 0; i < END_OF_FILE.size(); ++i) {
            int height = startHeight + 10 * i + (int)this.scrollbar.getCurrentScroll() * -10 + 10;
            if (height < 4 || height >= this.ySize - 12) continue;
            this.field_146289_q.func_78276_b(END_OF_FILE.get(i), gLeft + 12, gTop + height, i == 1 ? 0xFF0000 : 0);
        }
    }

    private void createHeader() {
        this.header = new ArrayList<String>();
        NBTTagCompound tagCompound = this.deathList.func_77978_p();
        if (tagCompound.func_74764_b("Misc")) {
            NBTTagCompound misc = tagCompound.func_74775_l("Misc");
            int x = misc.func_74762_e("x");
            int y = misc.func_74762_e("y");
            int z = misc.func_74762_e("z");
            if (y < 0) {
                this.header.add("No grave exists.");
            } else {
                this.header.add("Grave at: (x,y,z) = (" + x + "," + y + "," + z + ")");
            }
            this.header.add("Timestamp: " + misc.func_74779_i("Timestamp"));
        }
    }

    private void createListOfItemsInMainInventory() {
        NBTTagList tagList = this.deathList.func_77978_p().func_150295_c("Main", 10);
        InventoryPlayer inventoryPlayer = new InventoryPlayer(this.player);
        inventoryPlayer.func_70443_b(tagList);
        this.mainItems = this.createListFromInventory((IInventory)inventoryPlayer, MAIN);
    }

    private void createListOfItemsInBaublesInventory() {
        if (!TombManyGraves.isBaublesInstalled) {
            this.baubleItems = new ArrayList<String>();
            return;
        }
        NBTTagCompound tag = this.deathList.func_77978_p().func_74775_l("Baubles");
        IBaublesItemHandler inventoryBaubles = BaublesApi.getBaublesHandler((EntityPlayer)this.player);
        IInventory baubles = BaubleHandler.getSavedBaubles(tag, inventoryBaubles);
        this.baubleItems = this.createListFromInventory(baubles, BAUBLES);
    }

    private void createListOfItemsInCosmeticInventory() {
        if (!TombManyGraves.isCosmeticArmorInstalled) {
            this.cosmeticItems = new ArrayList<String>();
            return;
        }
        NBTTagCompound tag = this.deathList.func_77978_p().func_74775_l("Cosmetic");
        InventoryCosArmor cosArmor = new InventoryCosArmor();
        cosArmor.readFromNBT(tag);
        this.cosmeticItems = this.createListFromInventory((IInventory)cosArmor, COSMETIC);
    }

    private void createListOfItemsInThut() {
        if (!TombManyGraves.isThutWearablesInstalled) {
            this.thutItems = new ArrayList<String>();
            return;
        }
        NBTTagCompound tag = this.deathList.func_77978_p().func_74775_l("ThutWearables");
        PlayerWearables playerWearables = new PlayerWearables();
        playerWearables.readFromNBT(tag);
        this.thutItems = this.createListFromInventory((IInventory)playerWearables, THUT);
    }

    private void createListOfItemsInExpandableBackpack() {
        if (!TombManyGraves.isExpandableBackpacksInstalled) {
            this.expandableBackpackItems = new ArrayList<String>();
            return;
        }
        NBTTagCompound tag = this.deathList.func_77978_p().func_74775_l("ExpandableBackpack");
        ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)tag);
        if (stack == null || stack.field_77994_a == 0) {
            this.expandableBackpackItems = new ArrayList<String>();
            return;
        }
        InventoryBasic inventory = new InventoryBasic("temp", false, 1);
        inventory.func_70299_a(0, stack);
        this.expandableBackpackItems = this.createListFromInventory((IInventory)inventory, EXPANDABLE);
    }

    private void createListOfItemsInEydamosBackpack() {
        if (!TombManyGraves.isEydamosBackpacksInstalled) {
            this.eydamosBackpackItems = new ArrayList<String>();
            return;
        }
        NBTTagCompound tag = this.deathList.func_77978_p().func_74775_l("EydamosBackpack");
        ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)tag);
        if (stack == null || stack.field_77994_a == 0) {
            this.eydamosBackpackItems = new ArrayList<String>();
            return;
        }
        InventoryBasic inventory = new InventoryBasic("temp", false, 1);
        inventory.func_70299_a(0, stack);
        this.eydamosBackpackItems = this.createListFromInventory((IInventory)inventory, EYDAMOS);
    }

    private void createListOfItemsInIronBackpack() {
        if (!TombManyGraves.isIronBackpacksInstalled) {
            this.ironBackpackItems = new ArrayList<String>();
            return;
        }
        NBTTagCompound tag = this.deathList.func_77978_p().func_74775_l("IronBackpacks");
        ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)tag);
        if (stack == null || stack.field_77994_a == 0) {
            this.ironBackpackItems = new ArrayList<String>();
            return;
        }
        InventoryBackpack inventory = new InventoryBackpack(stack, true);
        this.ironBackpackItems = this.createListFromInventory((IInventory)inventory, IRON);
    }

    private List<String> createBoringListFromInventory(IInventory inventory) {
        ArrayList<String> stringList = new ArrayList<String>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i) == null || inventory.func_70301_a((int)i).field_77994_a <= 0) continue;
            String name = inventory.func_70301_a(i).func_82833_r();
            stringList.add(name + (inventory.func_70301_a((int)i).field_77994_a > 1 ? " x" + inventory.func_70301_a((int)i).field_77994_a : ""));
            Map enchants = EnchantmentHelper.func_82781_a((ItemStack)inventory.func_70301_a(i));
            for (Enchantment key : enchants.keySet()) {
                stringList.add("  -> " + key.func_77316_c(((Integer)enchants.get(key)).intValue()));
            }
        }
        return stringList;
    }

    private List<String> createListFromInventory(IInventory inventory, String sectionName) {
        ArrayList<String> stringList = new ArrayList<String>();
        stringList.add(LINE);
        stringList.add(sectionName);
        stringList.add(LINE);
        int itemNumber = 1;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            int j;
            if (inventory.func_70301_a(i) == null || inventory.func_70301_a((int)i).field_77994_a <= 0) continue;
            ItemStack inSlot = inventory.func_70301_a(i);
            String name = inSlot.func_82833_r();
            if (name.length() > 28) {
                name = name.substring(0, 25) + "...";
            }
            stringList.add(itemNumber + ") " + name + (inSlot.field_77994_a > 1 ? " x" + inSlot.field_77994_a : ""));
            Map enchants = EnchantmentHelper.func_82781_a((ItemStack)inSlot);
            for (Enchantment key : enchants.keySet()) {
                stringList.add("  -> " + key.func_77316_c(((Integer)enchants.get(key)).intValue()));
            }
            if (TombManyGraves.isEydamosBackpacksInstalled && inSlot.func_77973_b() instanceof de.eydamos.backpack.item.ItemBackpack) {
                BackpackSave instance = BackpackSave.loadBackpack((World)this.player.field_70170_p, (ItemStack)inSlot, (EntityPlayer)this.player, (boolean)false);
                List<String> boringList = this.createBoringListFromInventory((IInventory)instance);
                if (boringList.size() > 0) {
                    stringList.add("  Backpack contents:");
                    for (j = 0; j < boringList.size(); ++j) {
                        stringList.add("  ->" + boringList.get(j));
                    }
                } else {
                    stringList.add("  (Backpack empty)");
                }
            }
            if (TombManyGraves.isExpandableBackpacksInstalled && inSlot.func_77973_b() instanceof Backpack) {
                List itemStacks = BackpackInventory.getStacks((ItemStack)inSlot);
                if (itemStacks.size() > 0) {
                    stringList.add("  Backpack contents:");
                    InventoryBasic basicInventory = new InventoryBasic("verytemp", false, itemStacks.size());
                    for (j = 0; j < itemStacks.size(); ++j) {
                        basicInventory.func_70299_a(j, (ItemStack)itemStacks.get(j));
                    }
                    List<String> boringList = this.createBoringListFromInventory((IInventory)basicInventory);
                    for (String item : boringList) {
                        stringList.add("  ->" + item);
                    }
                } else {
                    stringList.add("  (Backpack empty");
                }
            }
            if (TombManyGraves.isIronBackpacksInstalled && inSlot.func_77973_b() instanceof ItemBackpack) {
                InventoryBackpack backpackInventory = new InventoryBackpack(inSlot, true);
                ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
                for (j = 0; j < backpackInventory.func_70302_i_(); ++j) {
                    ItemStack stack = backpackInventory.func_70301_a(j);
                    if (stack == null) continue;
                    itemStacks.add(stack);
                }
                if (itemStacks.size() > 0) {
                    stringList.add(" Backpack contents:");
                    InventoryBasic basicInventory = new InventoryBasic("verytemp", false, itemStacks.size());
                    for (int j2 = 0; j2 < itemStacks.size(); ++j2) {
                        basicInventory.func_70299_a(j2, (ItemStack)itemStacks.get(j2));
                    }
                    List<String> boringList = this.createBoringListFromInventory((IInventory)basicInventory);
                    for (String item : boringList) {
                        stringList.add("  ->" + item);
                    }
                } else {
                    stringList.add("  (Backpack empty)");
                }
            }
            ++itemNumber;
        }
        return stringList;
    }

    public void bindTexture(String filename) {
        this.bindTexture("tombmanygraves", filename);
    }

    public void bindTexture(String base, String filename) {
        this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation(base, "textures/gui/" + filename));
    }

    public void drawTexture(int x, int y, int textureX, int textureY, int width, int height) {
        this.func_73729_b(x, y, textureX, textureY, width, height);
    }

    public int getGuiLeft() {
        return (this.field_146294_l - this.xSize) / 2;
    }

    public int getGuiTop() {
        return (this.field_146295_m - this.ySize) / 2;
    }

    public boolean inBounds(int x, int y, int w, int h, int ox, int oy) {
        return ox - this.getGuiLeft() >= x && ox - this.getGuiLeft() <= x + w && oy - this.getGuiTop() >= y && oy - this.getGuiTop() <= y + h;
    }

    public int getxSize() {
        return this.xSize;
    }

    public int getySize() {
        return this.ySize;
    }
}

