/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.blocks;

import com.m4thg33k.tombmanygraves.api.state.TMGStateProps;
import com.m4thg33k.tombmanygraves.blocks.BaseBlock;
import com.m4thg33k.tombmanygraves.lib.TombManyGravesConfigs;
import com.m4thg33k.tombmanygraves.tiles.TileDeathBlock;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockDeath
extends BaseBlock {
    public BlockDeath() {
        super("DEATH_BLOCK", Material.field_151575_d, 100.0f, 100.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b());
        this.func_149722_s();
        this.setRegistryName("tombmanygraves", "DEATH_BLOCK");
        this.func_180632_j((IBlockState)((IExtendedBlockState)this.field_176227_L.func_177621_b()).withProperty(TMGStateProps.HELD_STATE, null).withProperty(TMGStateProps.HELD_WORLD, null).withProperty(TMGStateProps.HELD_POS, null));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{TMGStateProps.HELD_STATE, TMGStateProps.HELD_WORLD, TMGStateProps.HELD_POS});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    @Nonnull
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = ((IExtendedBlockState)state).withProperty(TMGStateProps.HELD_WORLD, (Object)world).withProperty(TMGStateProps.HELD_POS, (Object)pos);
        if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileDeathBlock) {
            TileDeathBlock tile = (TileDeathBlock)world.func_175625_s(pos);
            return ((IExtendedBlockState)state).withProperty(TMGStateProps.HELD_STATE, (Object)tile.getCamoState());
        }
        return state;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileDeathBlock();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            TileDeathBlock tileDeathBlock = (TileDeathBlock)worldIn.func_175625_s(pos);
            if (tileDeathBlock == null) {
                return true;
            }
            if (playerIn.func_70093_af()) {
                tileDeathBlock.toggleLock(playerIn);
            } else {
                tileDeathBlock.onRightClick(playerIn);
            }
        }
        return true;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return super.func_180646_a(blockState, worldIn, pos);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn) {
        TileDeathBlock tileDeathBlock = (TileDeathBlock)worldIn.func_175625_s(pos);
        if (entityIn instanceof EntityPlayer && !tileDeathBlock.isLocked() && tileDeathBlock.hasAccess((EntityPlayer)entityIn)) {
            super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn);
        }
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        TileDeathBlock tileDeathBlock = (TileDeathBlock)worldIn.func_175625_s(pos);
        if (entityIn instanceof EntityPlayer && entityIn.func_70089_S()) {
            if (TombManyGravesConfigs.REQUIRE_SNEAKING) {
                if (entityIn.func_70093_af()) {
                    tileDeathBlock.onCollision((EntityPlayer)entityIn);
                }
            } else {
                tileDeathBlock.onCollision((EntityPlayer)entityIn);
            }
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (worldIn.func_175625_s(pos) != null && worldIn.func_175625_s(pos) instanceof TileDeathBlock) {
            ((TileDeathBlock)worldIn.func_175625_s(pos)).dropAllItems();
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.75, 0.75);
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return false;
    }

    public boolean func_176212_b(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return false;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_176214_u() {
        return false;
    }

    public int func_149717_k(IBlockState state) {
        return 0;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return super.canRenderInLayer(state, layer);
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }
}

