/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.util;

import java.util.Objects;
import mods.waterstrainer.Config;
import mods.waterstrainer.WaterStrainer;
import mods.waterstrainer.item.ItemStrainer;
import mods.waterstrainer.registry.ItemRegistry;
import mods.waterstrainer.util.FileReader;
import mods.waterstrainer.util.WaterStrainerUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;

public class FileReaderLootTable
extends FileReader {
    @Override
    public String getFileName() {
        return "waterstrainer_loottables.cfg";
    }

    @Override
    public void parseFileData() {
        WaterStrainer.logger.info("Importing " + this.getFileName() + " ...");
        if (this.fileData == null) {
            WaterStrainer.logger.warn("Import failed! Did not receive any data!");
            return;
        }
        int lineCounter = 0;
        ItemRegistry.resetAllLootTables();
        for (String line : this.fileData) {
            ++lineCounter;
            if ((line = line.replaceAll("\\s", "")).startsWith("//") || line.isEmpty()) continue;
            String[] data = line.split("\\|");
            if (data.length != 6) {
                Config.Files.FILE_LOGFILE.addError("ERROR in line " + lineCounter + ": " + line + this.NEW_LINE + "Wrong number of arguments! Required: 6 | Received: " + data.length);
                continue;
            }
            String[] metaList = data[3].split(",");
            boolean errorFound = false;
            for (String meta : metaList) {
                if (WaterStrainerUtils.isInt(meta) && Integer.parseInt(meta) >= 0) continue;
                Config.Files.FILE_LOGFILE.addError("ERROR in line " + lineCounter + ": " + line + this.NEW_LINE + "Meta [" + meta + "] is invalid! Must be a whole number with a value of 0 or higher.");
                errorFound = true;
                break;
            }
            if (errorFound) continue;
            if (!WaterStrainerUtils.isInt(data[4]) || Integer.parseInt(data[4]) <= 0) {
                Config.Files.FILE_LOGFILE.addError("ERROR in line " + lineCounter + ": " + line + this.NEW_LINE + "Quantity [" + data[4] + "] is invalid! Must be a whole number with a value of 1 or higher.");
                continue;
            }
            if (!WaterStrainerUtils.isInt(data[5]) || Integer.parseInt(data[5]) <= 0) {
                Config.Files.FILE_LOGFILE.addError("ERROR in line " + lineCounter + ": " + line + this.NEW_LINE + "Rarity [" + data[5] + "] is invalid! Must be a whole number with a value of 1 or higher.");
                continue;
            }
            if (!ItemStrainer.isItemValid(data[2])) {
                ResourceLocation rloc = new ResourceLocation(data[2]);
                String modid = rloc.func_110624_b();
                String itemid = rloc.func_110623_a();
                if (Objects.equals(modid, "minecraft")) {
                    Config.Files.FILE_LOGFILE.addError("ERROR in line " + lineCounter + ": " + line + this.NEW_LINE + "Item [" + itemid + "] does not exist in vanilla Minecraft! Make sure it's spelled correctly. (Items are case-sensitive!)");
                    continue;
                }
                if (!Loader.isModLoaded((String)modid)) {
                    Config.Files.FILE_LOGFILE.addError("ERROR in line " + lineCounter + ": " + line + this.NEW_LINE + "Mod [" + modid + "] could not be found! Make sure it's installed and loaded.");
                    continue;
                }
                Config.Files.FILE_LOGFILE.addError("ERROR in line " + lineCounter + ": " + line + this.NEW_LINE + "Item [" + itemid + "] for the mod [" + modid + "] does not exist! Make sure it's spelled correctly. (Items are case-sensitive!)");
                continue;
            }
            errorFound = true;
            if (ItemRegistry.strainer_registry.containsKey(data[0])) {
                errorFound = false;
                ItemRegistry.strainer_registry.get(data[0]).addItemToLootTable(data[1], data[2], data[3], data[4], data[5]);
            }
            if (ItemRegistry.strainer_registry.containsKey(data[0] + "_solid") && Config.miscShareLootTable) {
                errorFound = false;
                ItemRegistry.strainer_registry.get(data[0] + "_solid").addItemToLootTable(data[1], data[2], data[3], data[4], data[5]);
            }
            if (ItemRegistry.strainer_registry.containsKey(data[0] + "_reinforced") && Config.miscShareLootTable) {
                errorFound = false;
                ItemRegistry.strainer_registry.get(data[0] + "_reinforced").addItemToLootTable(data[1], data[2], data[3], data[4], data[5]);
            }
            if (!errorFound) continue;
            Config.Files.FILE_LOGFILE.addError("ERROR in line " + lineCounter + ": " + line + this.NEW_LINE + "Strainer Name [" + data[0] + "] is invalid!");
        }
        WaterStrainer.logger.info("Finished import!");
        int errorcount = Config.Files.FILE_LOGFILE.errorlog.size();
        if (errorcount > 0) {
            WaterStrainer.logger.warn("Found " + WaterStrainerUtils.formPlural(errorcount, "error", "errors") + " while importing! Please check /logs/waterstrainer_errors.log");
            Config.Files.FILE_LOGFILE.createFile();
        } else {
            WaterStrainer.logger.info("No errors were found!");
        }
    }

    @Override
    public boolean createFile() {
        return this.writeLineToFile(this.directoryPath, "// Now supports categories. If you need help with adding items - take a look at the official forum thread." + this.NEW_LINE + "// Syntax is: stainer_id | category | registry_name | metadata | quantity | rarity" + this.NEW_LINE + this.NEW_LINE + "strainer_survivalist|SAND|minecraft:sand|0|1|20" + this.NEW_LINE + "strainer_survivalist|DIRT|minecraft:dirt|0|1|18" + this.NEW_LINE + "strainer_survivalist|STICK|minecraft:stick|0|1|16" + this.NEW_LINE + "strainer_survivalist|GRAVEL|minecraft:gravel|0|1|13" + this.NEW_LINE + "strainer_survivalist|CLAY|minecraft:clay_ball|0|1|12" + this.NEW_LINE + "strainer_survivalist|STONE|minecraft:stone|0|1|10" + this.NEW_LINE + "strainer_survivalist|WOOD|minecraft:planks|0,1,2,3,4,5|1|8" + this.NEW_LINE + "strainer_survivalist|NUGGET|minecraft:gold_nugget|0|1|3" + this.NEW_LINE + this.NEW_LINE + "strainer_survivalist_tight|SAND|minecraft:sand|0|1|40" + this.NEW_LINE + "strainer_survivalist_tight|DIRT|minecraft:dirt|0|1|30" + this.NEW_LINE + "strainer_survivalist_tight|GRAVEL|minecraft:gravel|0|1|25" + this.NEW_LINE + "strainer_survivalist_tight|NUGGET|minecraft:gold_nugget|0|1|5" + this.NEW_LINE + this.NEW_LINE + "strainer_survivalist_wide|STICK|minecraft:stick|0|1|35" + this.NEW_LINE + "strainer_survivalist_wide|CLAY|minecraft:clay_ball|0|1|25" + this.NEW_LINE + "strainer_survivalist_wide|STONE|minecraft:stone|0|1|25" + this.NEW_LINE + "strainer_survivalist_wide|WOOD|minecraft:planks|0,1,2,3,4,5|1|15" + this.NEW_LINE + this.NEW_LINE + "strainer_fisherman|BLANK|BLANK|0|1|34" + this.NEW_LINE + "strainer_fisherman|FISH|minecraft:fish|0,1,2,3|1|50" + this.NEW_LINE + "strainer_fisherman|FISH|harvestcraft:frograwItem|0|1|50" + this.NEW_LINE + "strainer_fisherman|FISH|harvestcraft:snailrawItem|0|1|50" + this.NEW_LINE + "strainer_fisherman|FISH|harvestcraft:shrimprawItem|0|1|50" + this.NEW_LINE + "strainer_fisherman|FISH|harvestcraft:jellyfishrawItem|0|1|50" + this.NEW_LINE + "strainer_fisherman|FISH|harvestcraft:turtlerawItem|0|1|50" + this.NEW_LINE + "strainer_fisherman|FISH|harvestcraft:octopusrawItem|0|1|50" + this.NEW_LINE + "strainer_fisherman|FISH|harvestcraft:crayfishrawItem|0|1|50" + this.NEW_LINE + "strainer_fisherman|FISH|harvestcraft:crabrawItem|0|1|50" + this.NEW_LINE + "strainer_fisherman|FISH|harvestcraft:clamrawItem|0|1|50" + this.NEW_LINE + "strainer_fisherman|FISH|harvestcraft:calamarirawItem|0|1|50" + this.NEW_LINE + "strainer_fisherman|FISH|harvestcraft:scalloprawItem|0|1|50" + this.NEW_LINE + "strainer_fisherman|FISH|harvestcraft:perchrawItem|0|1|50" + this.NEW_LINE + "strainer_fisherman|FISH|harvestcraft:eelrawItem|0|1|50" + this.NEW_LINE + "strainer_fisherman|FISH|harvestcraft:troutrawItem|0|1|50" + this.NEW_LINE + "strainer_fisherman|FISH|harvestcraft:tunarawItem|0|1|50" + this.NEW_LINE + "strainer_fisherman|FISH|harvestcraft:snapperrawItem|0|1|50" + this.NEW_LINE + "strainer_fisherman|FISH|harvestcraft:tilapiarawItem|0|1|50" + this.NEW_LINE + "strainer_fisherman|FISH|harvestcraft:herringrawItem|0|1|50" + this.NEW_LINE + "strainer_fisherman|FISH|harvestcraft:mudfishrawItem|0|1|50" + this.NEW_LINE + "strainer_fisherman|FISH|harvestcraft:grouperrawItem|0|1|50" + this.NEW_LINE + "strainer_fisherman|FISH|harvestcraft:walleyerawItem|0|1|50" + this.NEW_LINE + "strainer_fisherman|FISH|harvestcraft:charrrawItem|0|1|50" + this.NEW_LINE + "strainer_fisherman|FISH|harvestcraft:anchovyrawItem|0|1|50" + this.NEW_LINE + "strainer_fisherman|FISH|harvestcraft:bassrawItem|0|1|50" + this.NEW_LINE + "strainer_fisherman|FISH|harvestcraft:carprawItem|0|1|50" + this.NEW_LINE + "strainer_fisherman|FISH|harvestcraft:catfishrawItem|0|1|50" + this.NEW_LINE + "strainer_fisherman|FISH|harvestcraft:greenheartfishItem|0|1|50" + this.NEW_LINE + "strainer_fisherman|JUNK|minecraft:stick|0|1|15" + this.NEW_LINE + "strainer_fisherman|JUNK|minecraft:string|0|1|15" + this.NEW_LINE + "strainer_fisherman|JUNK|minecraft:bowl|0|1|15" + this.NEW_LINE + "strainer_fisherman|JUNK|minecraft:bone|0|1|15" + this.NEW_LINE + "strainer_fisherman|JUNK|minecraft:vine|0|1|15" + this.NEW_LINE + "strainer_fisherman|JUNK|minecraft:waterlily|0|1|15" + this.NEW_LINE + "strainer_fisherman|TREASURE|minecraft:enchanted_book|0|1|1");
    }
}

