/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.tileentity;

import java.util.Random;
import mods.waterstrainer.Config;
import mods.waterstrainer.block.BlockStrainerBase;
import mods.waterstrainer.item.IIsBait;
import mods.waterstrainer.item.ItemStrainer;
import mods.waterstrainer.registry.BlockRegistry;
import mods.waterstrainer.registry.ItemRegistry;
import mods.waterstrainer.util.Patcher;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;

public class TileEntityStrainer
extends TileEntity
implements ITickable,
ISidedInventory {
    private static final int[] SLOTS_TOP = new int[0];
    private static final int[] SLOTS_ALL = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28};
    private Random rand = new Random();
    private ItemStack[] inventory = new ItemStack[29];
    private int curIdleTime = 0;
    private int maxIdleTime = Config.idleTime * 20;
    private ItemStack lastCheckedInputStack = Patcher.emptyStack();

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            byte j = nbttagcompound.func_74771_c("Slot");
            if (j < 0 || j >= this.inventory.length) continue;
            this.inventory[j] = Patcher.loadStackFromNBT(nbttagcompound);
        }
        this.curIdleTime = compound.func_74762_e("CurIdleTime");
        this.maxIdleTime = compound.func_74762_e("MaxIdleTime");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (Patcher.isStackEmpty(this.inventory[i])) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
        compound.func_74768_a("CurIdleTime", this.curIdleTime);
        compound.func_74768_a("MaxIdleTime", this.maxIdleTime);
        return compound;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a((ItemStack[])this.inventory, (int)index, (int)count);
        if (!Patcher.isStackEmpty(itemstack)) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a((ItemStack[])this.inventory, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory[index] = stack;
        if (!Patcher.isStackEmpty(stack) && Patcher.stackSize(stack) > this.func_70297_j_()) {
            Patcher.setStackSize(stack, this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.func_145831_w().func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (Patcher.isStackEmpty(stack)) {
            return false;
        }
        if (stack.func_77973_b() instanceof ItemStrainer && slot == 0) {
            return true;
        }
        return stack.func_77973_b() instanceof IIsBait && slot == 28;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.inventory.length; ++i) {
            this.inventory[i] = Patcher.emptyStack();
        }
    }

    public boolean func_145818_k_() {
        return false;
    }

    public String func_70005_c_() {
        return "tile.waterstrainer.strainer_base.name";
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.UP ? SLOTS_TOP : SLOTS_ALL;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing direction) {
        return slot != 0 && slot != 28;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    private Block getBlock(BlockPos pos) {
        return this.func_145831_w().func_180495_p(pos).func_177230_c();
    }

    public int calculateEfficiency() {
        Biome biome;
        Chunk chunk;
        if (!Config.miscEnableEfficiency) {
            return 0;
        }
        int efficiency = 0;
        IBlockState blockState = this.func_145831_w().func_180495_p(this.field_174879_c.func_177984_a());
        Block waterBlock = blockState.func_177230_c();
        if (waterBlock == Blocks.field_150355_j || waterBlock == Blocks.field_150358_i) {
            int meta = waterBlock.func_176201_c(blockState);
            if (meta > 0) {
                efficiency += 10;
            }
            if (meta > 1) {
                efficiency -= (meta - 1) * 3;
            }
        }
        BlockPos pos = this.field_174879_c;
        for (int curZ = pos.func_177952_p() - 1; curZ < pos.func_177952_p() + 2; ++curZ) {
            for (int curX = pos.func_177958_n() - 1; curX < pos.func_177958_n() + 2; ++curX) {
                if (curX == pos.func_177958_n() && curZ == pos.func_177952_p() || this.getBlock(new BlockPos(curX, pos.func_177956_o(), curZ)) != BlockRegistry.strainer_base) continue;
                efficiency -= 15;
            }
        }
        World world = this.func_145831_w();
        if (world != null && !(chunk = world.func_175726_f(pos)).func_76621_g() && (biome = chunk.func_177411_a(pos, world.func_72959_q())) != null) {
            if (Patcher.isBiomeOfType(biome, BiomeDictionary.Type.OCEAN)) {
                efficiency += 10;
            } else if (Patcher.isBiomeOfType(biome, BiomeDictionary.Type.BEACH)) {
                efficiency += 15;
            } else if (Patcher.isBiomeOfType(biome, BiomeDictionary.Type.RIVER)) {
                efficiency += 20;
            }
        }
        return efficiency;
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            if (!BlockStrainerBase.canBlockStayAtPos(this.func_145831_w(), this.field_174879_c)) {
                return;
            }
            ++this.curIdleTime;
            ItemStack inputStack = this.func_70301_a(0);
            if (inputStack != this.lastCheckedInputStack) {
                this.lastCheckedInputStack = inputStack;
                if (!Patcher.isStackEmpty(inputStack)) {
                    String itemName = inputStack.func_77973_b().getRegistryName().toString();
                    BlockStrainerBase.setState(this.func_145831_w(), this.field_174879_c, ItemRegistry.getMetaFromName(itemName));
                } else {
                    BlockStrainerBase.setState(this.func_145831_w(), this.field_174879_c, 0);
                }
            }
            block0: for (EntityItem ent : TileEntityHopper.func_184292_a((World)this.func_145831_w(), (double)((double)this.func_174877_v().func_177958_n() + 0.5), (double)((double)this.func_174877_v().func_177956_o() + 0.5), (double)((double)this.func_174877_v().func_177952_p() + 0.5))) {
                for (int i = 1; i < 28; ++i) {
                    if (ent == null) continue;
                    ItemStack entstack = this.addItemStackToSlot(i, ent.func_92059_d());
                    if (!Patcher.isStackEmpty(entstack) && Patcher.stackSize(entstack) != 0) {
                        ent.func_92058_a(entstack);
                        continue;
                    }
                    ent.func_70106_y();
                    continue block0;
                }
            }
            if (this.curIdleTime >= this.maxIdleTime) {
                ItemStrainer itemstrainer;
                ItemStack stack;
                ItemStack strainer;
                int efficiency;
                this.curIdleTime = 0;
                int min = Config.idleTime - Config.idleTimeDeviation;
                int max = Config.idleTime + Config.idleTimeDeviation;
                this.maxIdleTime = (this.rand.nextInt(max - min + 1) + min) * 20;
                if (Config.miscEnableEfficiency && (efficiency = this.calculateEfficiency()) != 0) {
                    this.maxIdleTime = efficiency > 0 ? (this.maxIdleTime -= this.maxIdleTime * efficiency / 100) : (this.maxIdleTime += this.maxIdleTime * Math.abs(efficiency) / 100);
                }
                if (this.func_145831_w().func_180495_p(this.field_174879_c.func_177984_a()).func_177230_c() == Blocks.field_150355_j && !Patcher.isStackEmpty(strainer = this.func_70301_a(0)) && strainer.func_77973_b() instanceof ItemStrainer && !Patcher.isStackEmpty(stack = (itemstrainer = (ItemStrainer)strainer.func_77973_b()).generateRandomItemStack())) {
                    if (itemstrainer == ItemRegistry.strainer_fisherman && !this.consumeBait()) {
                        return;
                    }
                    int stackSize = Patcher.stackSize(stack);
                    for (int i = 1; i < 28 && !Patcher.isStackEmpty(stack = this.addItemStackToSlot(i, stack)); ++i) {
                    }
                    if ((Patcher.isStackEmpty(stack) || stackSize != Patcher.stackSize(stack)) && strainer.func_77984_f()) {
                        strainer.func_77964_b(strainer.func_77952_i() + 1);
                        if (strainer.func_77952_i() >= strainer.func_77958_k()) {
                            this.func_70299_a(0, Patcher.emptyStack());
                        }
                    }
                }
            }
        }
    }

    private boolean consumeBait() {
        ItemStack stack = this.func_70301_a(28);
        if (Patcher.isStackEmpty(stack) || !(stack.func_77973_b() instanceof IIsBait)) {
            return false;
        }
        IIsBait bait = (IIsBait)stack.func_77973_b();
        if (!bait.infiniteBait()) {
            if (stack.func_77976_d() > 1) {
                Patcher.decreaseStackSize(stack, 1);
                if (Patcher.stackSize(stack) <= 0) {
                    this.func_70299_a(28, Patcher.emptyStack());
                }
            } else {
                int baitCount = stack.func_77952_i();
                if (baitCount >= stack.func_77958_k()) {
                    return false;
                }
                if (this.rand.nextInt(2) == 0) {
                    stack.func_77964_b(baitCount + 1);
                }
            }
        }
        return true;
    }

    private ItemStack addItemStackToSlot(int slotIndex, ItemStack newStack) {
        int max;
        ItemStack stackInSlot = this.func_70301_a(slotIndex);
        boolean needsUpdate = false;
        if (Patcher.isStackEmpty(stackInSlot)) {
            int max2 = Math.min(newStack.func_77976_d(), this.func_70297_j_());
            if (max2 >= Patcher.stackSize(newStack)) {
                this.func_70299_a(slotIndex, newStack);
                newStack = Patcher.emptyStack();
            } else {
                this.func_70299_a(slotIndex, newStack.func_77979_a(max2));
            }
            needsUpdate = true;
        } else if (TileEntityStrainer.canCombineStacks(stackInSlot, newStack) && (max = Math.min(newStack.func_77976_d(), this.func_70297_j_())) > Patcher.stackSize(stackInSlot)) {
            int i = max - Patcher.stackSize(stackInSlot);
            int j = Math.min(Patcher.stackSize(newStack), i);
            Patcher.decreaseStackSize(newStack, j);
            Patcher.increaseStackSize(stackInSlot, j);
            boolean bl = needsUpdate = j > 0;
        }
        if (needsUpdate) {
            this.func_70296_d();
        }
        if (!Patcher.isStackEmpty(newStack) && Patcher.stackSize(newStack) == 0) {
            newStack = Patcher.emptyStack();
        }
        return newStack;
    }

    private static boolean canCombineStacks(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() != stack2.func_77973_b() ? false : (stack1.func_77960_j() != stack2.func_77960_j() ? false : (Patcher.stackSize(stack1) > stack1.func_77976_d() ? false : ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2)));
    }
}

