/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.registry;

import java.util.HashMap;
import java.util.Map;
import mods.waterstrainer.Config;
import mods.waterstrainer.item.ItemBaitPot;
import mods.waterstrainer.item.ItemDummy;
import mods.waterstrainer.item.ItemEfficiencyMeter;
import mods.waterstrainer.item.ItemGardenTrowel;
import mods.waterstrainer.item.ItemInfiniteBaitPot;
import mods.waterstrainer.item.ItemNet;
import mods.waterstrainer.item.ItemStrainer;
import mods.waterstrainer.item.ItemWorm;

public class ItemRegistry {
    public static Map<String, Integer> model_registry = new HashMap<String, Integer>();
    public static Map<String, ItemStrainer> strainer_registry = new HashMap<String, ItemStrainer>();
    public static ItemDummy dummy;
    public static ItemStrainer strainer_survivalist;
    public static ItemStrainer strainer_survivalist_solid;
    public static ItemStrainer strainer_survivalist_reinforced;
    public static ItemStrainer strainer_survivalist_tight;
    public static ItemStrainer strainer_survivalist_tight_solid;
    public static ItemStrainer strainer_survivalist_tight_reinforced;
    public static ItemStrainer strainer_survivalist_wide;
    public static ItemStrainer strainer_survivalist_wide_solid;
    public static ItemStrainer strainer_survivalist_wide_reinforced;
    public static ItemStrainer strainer_fisherman;
    public static ItemNet net;
    public static ItemEfficiencyMeter efficiency_meter;
    public static ItemWorm worm;
    public static ItemBaitPot bait_pot;
    public static ItemInfiniteBaitPot infinite_bait_pot;
    public static ItemGardenTrowel garden_trowel;

    public static final void init() {
        if (Config.enableStrainerSurvivalist) {
            strainer_survivalist = new ItemStrainer("strainer_survivalist", Config.durabilityNormalStrainer);
            ItemRegistry.addStrainer(strainer_survivalist, 2);
            if (Config.enableStrainerTypeSolid) {
                strainer_survivalist_solid = new ItemStrainer("strainer_survivalist_solid", Config.durabilitySolidStrainer);
                ItemRegistry.addStrainer(strainer_survivalist_solid, 3);
            }
            if (Config.enableStrainerTypeReinforced) {
                strainer_survivalist_reinforced = new ItemStrainer("strainer_survivalist_reinforced", Config.durabilityReinforcedStrainer);
                ItemRegistry.addStrainer(strainer_survivalist_reinforced, 4);
            }
        }
        if (Config.enableStrainerSurvivalistTight) {
            strainer_survivalist_tight = new ItemStrainer("strainer_survivalist_tight", Config.durabilityNormalStrainer);
            ItemRegistry.addStrainer(strainer_survivalist_tight, 5);
            if (Config.enableStrainerTypeSolid) {
                strainer_survivalist_tight_solid = new ItemStrainer("strainer_survivalist_tight_solid", Config.durabilitySolidStrainer);
                ItemRegistry.addStrainer(strainer_survivalist_tight_solid, 6);
            }
            if (Config.enableStrainerTypeReinforced) {
                strainer_survivalist_tight_reinforced = new ItemStrainer("strainer_survivalist_tight_reinforced", Config.durabilityReinforcedStrainer);
                ItemRegistry.addStrainer(strainer_survivalist_tight_reinforced, 7);
            }
        } else {
            dummy = new ItemDummy();
        }
        if (Config.enableStrainerSurvivalistWide) {
            strainer_survivalist_wide = new ItemStrainer("strainer_survivalist_wide", Config.durabilityNormalStrainer);
            ItemRegistry.addStrainer(strainer_survivalist_wide, 8);
            if (Config.enableStrainerTypeSolid) {
                strainer_survivalist_wide_solid = new ItemStrainer("strainer_survivalist_wide_solid", Config.durabilitySolidStrainer);
                ItemRegistry.addStrainer(strainer_survivalist_wide_solid, 9);
            }
            if (Config.enableStrainerTypeReinforced) {
                strainer_survivalist_wide_reinforced = new ItemStrainer("strainer_survivalist_wide_reinforced", Config.durabilityReinforcedStrainer);
                ItemRegistry.addStrainer(strainer_survivalist_wide_reinforced, 10);
            }
        }
        if (Config.enableStrainerFisherman) {
            strainer_fisherman = new ItemStrainer("strainer_fisherman", Config.durabilityFishermansStrainer);
            ItemRegistry.addStrainer(strainer_fisherman, 11);
            net = new ItemNet();
            worm = new ItemWorm();
            bait_pot = new ItemBaitPot();
            infinite_bait_pot = new ItemInfiniteBaitPot();
            garden_trowel = new ItemGardenTrowel();
        }
        efficiency_meter = new ItemEfficiencyMeter();
    }

    public static void addStrainer(ItemStrainer item, int id) {
        model_registry.put(item.getRegistryName().toString(), id);
        strainer_registry.put(item.getRegistryName().toString().substring("waterstrainer".length() + 1), item);
    }

    public static void resetAllLootTables() {
        for (Map.Entry<String, ItemStrainer> strainer : strainer_registry.entrySet()) {
            strainer.getValue().resetLootTable();
        }
    }

    public static int getMetaFromName(String itemName) {
        if (itemName != null && model_registry.containsKey(itemName)) {
            return model_registry.get(itemName);
        }
        return 0;
    }
}

