/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.util.Translator;
import mods.waterstrainer.jei.StrainerRecipe;
import mods.waterstrainer.jei.StrainerRecipeCategory;
import net.minecraft.util.ResourceLocation;

public class StrainerCategory
extends StrainerRecipeCategory<StrainerRecipe> {
    private final IDrawable BACKGROUND;
    private final String TITLE;
    private final ResourceLocation LOCATION = new ResourceLocation("waterstrainer", "textures/gui/jei_strainer.png");

    public StrainerCategory(IGuiHelper guiHelper) {
        this.BACKGROUND = guiHelper.createDrawable(this.LOCATION, 0, 0, 92, 122);
        this.TITLE = Translator.translateToLocal((String)"itemGroup.waterstrainer.main");
    }

    public IDrawable getBackground() {
        return this.BACKGROUND;
    }

    public String getTitle() {
        return this.TITLE;
    }

    public String getUid() {
        return "waterstrainer.strainer";
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull StrainerRecipe recipeWrapper) {
        int istart;
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 37, 4);
        guiItemStacks.setFromRecipe(0, recipeWrapper.getInputs());
        int icur = istart = 1;
        int imax = 25;
        ArrayList outputlist = new ArrayList();
        while (outputlist.size() < 25) {
            outputlist.add(new ArrayList());
        }
        for (int index = 0; index < recipeWrapper.getOutputs().size(); ++index) {
            ((List)outputlist.get(index % 25)).add(recipeWrapper.getOutputs().get(index));
        }
        for (int i = 0; i < recipeWrapper.getOutputs().size(); ++i) {
            int column = (icur - 1) / 5;
            int row = (icur - 1) % 5;
            int x = 1 + 18 * row;
            int y = 31 + 18 * column;
            guiItemStacks.init(icur, false, x, y);
            List outputs = (List)outputlist.get(icur - 1);
            guiItemStacks.set(icur, (Collection)outputs);
            icur = icur >= imax ? istart : icur + 1;
        }
    }
}

