/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import mods.waterstrainer.WaterStrainer;
import mods.waterstrainer.util.Patcher;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class ItemStrainer
extends Item {
    private int minIndex = 0;
    private int maxIndex = 0;
    private int curTooltipIndex = 0;
    private Random rand = new Random();
    private long updateTime = System.currentTimeMillis();
    private List<String> tooltipData = new ArrayList<String>();
    private List<Integer> sortedRarityList = new ArrayList<Integer>();
    private Map<String, List<String>> categoryTable = new HashMap<String, List<String>>();
    private Map<String, List<ItemStack>> lootTable = new HashMap<String, List<ItemStack>>();
    private Map<Integer, List<String>> lootTableSorted = new HashMap<Integer, List<String>>();

    public ItemStrainer(String name, int maxDurability) {
        this.field_77777_bU = 1;
        this.func_77656_e(maxDurability);
        this.setRegistryName(name);
        this.func_77655_b("waterstrainer." + name);
        this.func_77637_a(WaterStrainer.tabWaterStrainer);
        GameRegistry.register((IForgeRegistryEntry)this);
        WaterStrainer.proxy.registerModel(this, 0, new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        boolean shiftPressed = GuiScreen.func_146272_n();
        if (this.func_77645_m()) {
            int uses = this.func_77612_l() - this.getDamage(stack);
            if (uses <= 1) {
                tooltip.add("\u00a721 use left");
            } else {
                tooltip.add("\u00a72" + uses + " uses left");
            }
        } else {
            tooltip.add("\u00a72Does not break");
        }
        if (shiftPressed) {
            if (this.lootTable.size() > 0) {
                if (this.sortedRarityList.size() == 0) {
                    this.sortLootTable();
                }
                if (this.tooltipData.size() == 0) {
                    this.generateTooltip();
                }
                if (Math.abs(System.currentTimeMillis() - this.updateTime) > 750L) {
                    this.updateTime = System.currentTimeMillis();
                    this.generateTooltip();
                }
                if (this.tooltipData.size() > 0) {
                    for (String t : this.tooltipData) {
                        tooltip.add(t);
                    }
                }
            } else {
                tooltip.add("This item has no valid output items and is therefore useless. Use the configuration files to add valid items or disable it completely.");
            }
        } else {
            if (this.func_77658_a().contains("fish")) {
                tooltip.add("Catches fish, junk and treasures.");
                tooltip.add("Requires Bait or a Bait Pot.");
            } else if (this.func_77658_a().contains("tight")) {
                tooltip.add("Collects general small-sized items.");
            } else if (this.func_77658_a().contains("wide")) {
                tooltip.add("Collects general big-sized items.");
            } else {
                tooltip.add("Collects general items.");
            }
            tooltip.add("Requires a Strainer Base.");
            tooltip.add("\u00a77Press \u00a76shift \u00a77for more info.");
        }
    }

    private void generateTooltip() {
        this.tooltipData.clear();
        for (int rarity : this.sortedRarityList) {
            List<String> categories = this.lootTableSorted.get(rarity);
            for (String category : categories) {
                Item getItem;
                int index;
                ItemStack randItem;
                List<ItemStack> itemlist;
                int size;
                if (!this.lootTable.containsKey(category) || (size = (itemlist = this.lootTable.get(category)).size()) <= 0 || Patcher.isStackEmpty(randItem = itemlist.get(index = this.curTooltipIndex % size)) || (getItem = randItem.func_77973_b()) == null) continue;
                String descrString = "" + Patcher.stackSize(randItem) + "x " + getItem.func_77653_i(randItem);
                int chance = Math.max(1, (int)(100.0f / ((float)this.maxIndex / (float)rarity)));
                if (chance < 10) {
                    this.tooltipData.add("0" + chance + "% - " + descrString);
                    continue;
                }
                this.tooltipData.add(chance + "% - " + descrString);
            }
        }
        ++this.curTooltipIndex;
        if (this.curTooltipIndex >= 1000) {
            this.curTooltipIndex = 0;
        }
    }

    public void resetLootTable() {
        this.tooltipData.clear();
        this.categoryTable.clear();
        this.lootTable.clear();
        this.lootTableSorted.clear();
        this.sortedRarityList.clear();
        this.minIndex = 0;
        this.maxIndex = 0;
    }

    public static boolean isItemValid(String itemName) {
        return Item.func_111206_d((String)itemName) != null || Objects.equals(itemName, "BLANK");
    }

    public void addItemToLootTable(String category, String itemName, String metadata, String quantity, String rarity) {
        if (ItemStrainer.isItemValid(itemName)) {
            if (!this.categoryTable.containsKey(category)) {
                int r = Integer.parseInt(rarity);
                this.minIndex = this.maxIndex + 1;
                this.maxIndex = this.minIndex + r - 1;
                ArrayList<String> data = new ArrayList<String>();
                data.add(Integer.toString(this.minIndex));
                data.add(Integer.toString(this.maxIndex));
                data.add(rarity);
                this.categoryTable.put(category, data);
            }
            List<Object> itemlist = new ArrayList<ItemStack>();
            if (this.lootTable.containsKey(category)) {
                itemlist = this.lootTable.get(category);
            }
            if (!Objects.equals(itemName, "BLANK")) {
                String[] metaList;
                for (String meta : metaList = metadata.split(",")) {
                    itemlist.add(new ItemStack(Item.func_111206_d((String)itemName), Integer.parseInt(quantity), Integer.parseInt(meta)));
                }
            } else {
                itemlist.add(Patcher.emptyStack());
            }
            this.lootTable.put(category, itemlist);
        }
    }

    private void sortLootTable() {
        for (Map.Entry<String, List<String>> entry : this.categoryTable.entrySet()) {
            List<Object> data;
            String category = entry.getKey();
            int rarity = Integer.parseInt(entry.getValue().get(2));
            if (this.lootTableSorted.containsKey(rarity)) {
                data = this.lootTableSorted.get(rarity);
                data.add(category);
                this.lootTableSorted.put(rarity, data);
                continue;
            }
            data = new ArrayList<String>();
            data.add(category);
            this.lootTableSorted.put(rarity, data);
            this.sortedRarityList.add(rarity);
        }
        Collections.sort(this.sortedRarityList);
        Collections.reverse(this.sortedRarityList);
    }

    public ItemStack generateRandomItemStack() {
        if (this.maxIndex < 1) {
            return Patcher.emptyStack();
        }
        int randIndex = this.rand.nextInt(this.maxIndex - 1 + 1) + 1;
        for (Map.Entry<String, List<String>> entry : this.categoryTable.entrySet()) {
            ItemStack randItem;
            int minIndex = Integer.parseInt(entry.getValue().get(0));
            int maxIndex = Integer.parseInt(entry.getValue().get(1));
            if (randIndex < minIndex || randIndex > maxIndex) continue;
            List<ItemStack> itemlist = this.lootTable.get(entry.getKey());
            if (itemlist == null || itemlist.size() <= 0 || Patcher.isStackEmpty(randItem = itemlist.get(this.rand.nextInt(itemlist.size()))) || randItem.func_77973_b() == null) break;
            if (randItem.func_77973_b() == Items.field_151134_bR) {
                randItem = Patcher.emptyStack();
                randItem = EnchantmentHelper.func_77504_a((Random)this.rand, (ItemStack)new ItemStack(Items.field_151122_aG), (int)(this.rand.nextInt(30) + 1), (boolean)true);
                if (!Patcher.isStackEmpty(randItem) && randItem.func_77973_b() != null) {
                    return randItem;
                }
            }
            if (randItem.func_77984_f()) {
                randItem.func_77964_b(this.rand.nextInt(randItem.func_77958_k()));
            }
            if (Patcher.isStackEmpty(randItem) || randItem.func_77973_b() == null) break;
            return new ItemStack(randItem.func_77973_b(), Patcher.stackSize(randItem), randItem.func_77960_j());
        }
        return Patcher.emptyStack();
    }

    public List<ItemStack> getLootTableNoBlanks() {
        ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
        for (Map.Entry<String, List<ItemStack>> entry : this.lootTable.entrySet()) {
            for (ItemStack stack : entry.getValue()) {
                if (Patcher.isStackEmpty(stack)) continue;
                loot.add(stack);
            }
        }
        return loot;
    }
}

