/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.config;

import codechicken.lib.gui.GuiDraw;
import codechicken.lib.util.CommonUtils;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.LayoutManager;
import codechicken.nei.config.Option;
import codechicken.nei.util.LogHelper;
import codechicken.nei.util.NEIClientUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public abstract class DataDumper
extends Option {
    public DataDumper(String name) {
        super(name);
    }

    public abstract String[] header();

    public abstract Iterable<String[]> dump(int var1);

    public String renderName() {
        return this.translateN(this.name + "s", new Object[0]);
    }

    public void dumpFile() {
        try {
            File file = new File(CommonUtils.getMinecraftDir(), "dumps/" + this.getFileName(this.name.replaceFirst(".+\\.", "")));
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            this.dumpTo(file);
            NEIClientUtils.printChatMessage(this.dumpMessage(file));
        }
        catch (Exception e) {
            LogHelper.errorError("Error dumping " + this.renderName() + " mode: " + this.getMode(), e);
        }
    }

    public String getFileName(String prefix) {
        return prefix + this.getFileExtension();
    }

    public String getFileExtension() {
        return ".csv";
    }

    public ITextComponent dumpMessage(File file) {
        return new TextComponentTranslation("nei.options.tools.dump.dumped", new Object[]{this.translateN(this.name, new Object[0]), "dumps/" + file.getName()});
    }

    public void dumpTo(File file) throws IOException {
        int mode = this.getMode();
        PrintWriter w = new PrintWriter(file);
        w.println(DataDumper.concat(this.header()));
        for (String[] line : this.dump(mode)) {
            w.println(DataDumper.concat(line));
        }
        w.close();
    }

    public static String concat(String[] header) {
        StringBuilder sb = new StringBuilder();
        for (String s : header) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            if (s == null) {
                s = "null";
            }
            if (s.indexOf(44) > 0 || s.indexOf(34) > 0) {
                s = '\"' + s.replace("\"", "\"\"") + '\"';
            }
            sb.append(s);
        }
        return sb.toString();
    }

    @Override
    public void draw(int mousex, int mousey, float frame) {
        this.drawPrefix();
        if (this.modeCount() > 1) {
            this.drawButton(mousex, mousey, this.modeButtonSize(), this.modeButtonText());
        }
        this.drawButton(mousex, mousey, this.dumpButtonSize(), this.dumpButtonText());
    }

    public void drawPrefix() {
        GuiDraw.drawString((String)this.renderName(), (int)10, (int)6, (int)-1);
    }

    public Rectangle4i dumpButtonSize() {
        int width = 80;
        return new Rectangle4i(this.slot.slotWidth() - width, 0, width, 20);
    }

    public Rectangle4i modeButtonSize() {
        int width = 60;
        return new Rectangle4i(this.dumpButtonSize().x - width - 6, 0, width, 20);
    }

    public String dumpButtonText() {
        return NEIClientUtils.lang.translate("options.tools.dump.dump");
    }

    public String modeButtonText() {
        return NEIClientUtils.lang.translate("options.tools.dump.mode." + this.getMode());
    }

    public int getMode() {
        return this.renderTag().getIntValue(0);
    }

    public void drawButton(int mousex, int mousey, Rectangle4i b, String text) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean hover = b.contains(mousex, mousey);
        LayoutManager.drawButtonBackground(b.x, b.y, b.w, b.h, true, this.getButtonTex(hover));
        GuiDraw.drawStringC((String)text, (int)b.x, (int)b.y, (int)b.w, (int)b.h, (int)this.getTextColour(hover));
    }

    public int getButtonTex(boolean hover) {
        return hover ? 2 : 1;
    }

    public int getTextColour(boolean hover) {
        return hover ? -96 : -2039584;
    }

    @Override
    public void mouseClicked(int mousex, int mousey, int button) {
        if (this.modeCount() > 1 && this.modeButtonSize().contains(mousex, mousey)) {
            NEIClientUtils.playClickSound();
            this.getTag().setIntValue((this.getMode() + 1) % this.modeCount());
        } else if (this.dumpButtonSize().contains(mousex, mousey)) {
            NEIClientUtils.playClickSound();
            this.dumpFile();
        }
    }

    public int modeCount() {
        return 3;
    }
}

