/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.NEIClientConfig;
import codechicken.nei.network.NEIClientPacketHandler;
import codechicken.nei.util.LogHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemMobSpawner
extends ItemBlock {
    private static Map<Integer, EntityLiving> entityHashMap = new HashMap<Integer, EntityLiving>();
    private static Map<Integer, String> IDtoNameMap = new HashMap<Integer, String>();
    public static int idPig;
    private static boolean loaded;
    private static ItemMobSpawner instance;

    public static void register() {
    }

    public static void initRender() {
    }

    public ItemMobSpawner() {
        super(Blocks.field_150474_ac);
        this.func_77627_a(true);
    }

    public static void onBlockPlaced(World world, BlockPos pos, ItemStack stack) {
        if (!NEIClientConfig.hasSMPCounterPart()) {
            return;
        }
        TileEntityMobSpawner tileentitymobspawner = (TileEntityMobSpawner)world.func_175625_s(pos);
        if (tileentitymobspawner != null) {
            ItemMobSpawner.setDefaultTag(stack);
            String mobtype = IDtoNameMap.get(stack.func_77952_i());
            if (mobtype != null) {
                NEIClientPacketHandler.sendMobSpawnerID(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), mobtype);
                tileentitymobspawner.func_145881_a().func_98272_a(mobtype);
            }
        }
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer par2EntityPlayer, List<String> list, boolean par4) {
        ItemMobSpawner.setDefaultTag(itemstack);
        int meta = itemstack.func_77952_i();
        if (meta == 0) {
            meta = idPig;
        }
        EntityLiving e = ItemMobSpawner.getEntity(meta);
        list.add("\u00a7" + (e instanceof IMob ? "4" : "3") + IDtoNameMap.get(meta));
    }

    public static EntityLiving getEntity(int ID) {
        EntityLiving e = entityHashMap.get(ID);
        if (e == null) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            Class clazz = (Class)EntityList.field_75623_d.get(ID);
            try {
                e = (EntityLiving)clazz.getConstructor(World.class).newInstance(world);
            }
            catch (Throwable t) {
                if (clazz == null) {
                    LogHelper.error("Null class for entity (" + ID + ", " + IDtoNameMap.get(ID));
                } else {
                    LogHelper.errorError("Error creating instance of entity: " + clazz.getName(), t);
                }
                e = ItemMobSpawner.getEntity(idPig);
            }
            entityHashMap.put(ID, e);
        }
        return e;
    }

    private static void setDefaultTag(ItemStack itemstack) {
        if (!IDtoNameMap.containsKey(itemstack.func_77952_i())) {
            itemstack.func_77964_b(idPig);
        }
    }

    public static void loadSpawners(World world) {
        if (loaded) {
            return;
        }
        loaded = true;
        HashMap classToStringMapping = (HashMap)EntityList.field_75626_c;
        HashMap classToIDMapping = (HashMap)EntityList.field_75624_e;
        for (Class entityClass : classToStringMapping.keySet()) {
            if (!EntityLiving.class.isAssignableFrom(entityClass)) continue;
            try {
                EntityLiving entityliving = (EntityLiving)entityClass.getConstructor(World.class).newInstance(world);
                entityliving.func_70631_g_();
                int id = (Integer)classToIDMapping.get(entityClass);
                String name = (String)classToStringMapping.get(entityClass);
                if (name.equals("EnderDragon")) continue;
                IDtoNameMap.put(id, name);
                if (!name.equals("Pig")) continue;
                idPig = id;
            }
            catch (Throwable throwable) {}
        }
        Iterator<Map.Entry<Integer, String>> it = IDtoNameMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, String> e = it.next();
            if (ItemMobSpawner.getEntity(e.getKey()).getClass() != EntityPig.class || e.getValue().equals("Pig")) continue;
            it.remove();
        }
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        if (!NEIClientConfig.hasSMPCounterPart()) {
            list.add(new ItemStack(item));
        } else {
            for (int i : IDtoNameMap.keySet()) {
                list.add(new ItemStack(item, 1, i));
            }
        }
    }
}

